# 初始化用户
INSERT INTO `sys_user` (`id`, `username`, `last_name`, `first_name`, `password`, `source_type`, `enabled`,
                        `create_time`, `modify_time`, `delete_flag`, `need_reset`)
VALUES (1, 'admin', '超级管理员', '',
        '$2a$10$Q4TPFE7lC0zfT6pt9mW6H.4JK6oizWEooZX0lAq0znYvrq1TaXVLK', 'sys', 1, sysdate(), sysdate(), 0, 0);

# 初始化应用角色
INSERT INTO `sys_role` (`id`, `code`, `name`, `enabled`, `create_time`, `modify_time`, `delete_flag`)
VALUES (1, 'ADMIN', '系统管理员', 1, sysdate(), sysdate(), 0);
INSERT INTO `sys_role` (`id`, `code`, `name`, `enabled`, `create_time`, `modify_time`, `delete_flag`)
VALUES (2, 'TENANT_ADMIN', '租户管理员', 1, sysdate(), sysdate(), 0);


# 初始化数据角色
INSERT INTO `sys_data_role` (`id`, `code`, `name`, `advanced_enable`, `enabled`, `create_time`, `modify_time`,
                             `delete_flag`)
VALUES (1, 'ADMIN', '系统数据管理员', 0, 1, sysdate(), sysdate(), 0);
INSERT INTO `sys_data_role` (`id`, `code`, `name`, `advanced_enable`, `enabled`, `create_time`, `modify_time`,
                             `delete_flag`)
VALUES (2, 'TENANT_ADMIN', '租户管理员', 0, 1, sysdate(), sysdate(), 0);

# 初始化用户角色
INSERT INTO `sys_user_role`(`id`, `user_id`, `role_id`, `delete_flag`)
VALUES (1, 1, 1, 0);
INSERT INTO `sys_user_data_role`(`id`, `user_id`, `role_id`, `delete_flag`)
VALUES (1, 1, 1, 0);

# 初始化用户终端
INSERT INTO `sys_user_terminal` VALUES (1, 1, 'BACKEND', '2022-05-10 09:31:53', NULL, NULL, 1, 'admin', '2022-05-10 09:31:53.060384', 1, 'admin', '2022-05-10 09:31:53.060384', 0, NULL, NULL, NULL, NULL);

# 初始化菜单
INSERT INTO `sys_permission` VALUES (101, 'dashboard', '首页', 0, 0, '/', NULL, 1, '/dashboard', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102, 'order', '订单中心', 0, 0, '/', NULL, 2, '/order', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103, 'mg-inventory', '库存中心', 0, 0, '/', NULL, 3, '/inventory', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104, 'mg-purc', '采购中心', 0, 0, '/', NULL, 4, '/purc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (105, 'mg-logistics', '物流中心', 0, 0, '/', NULL, 5, '/logistics', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106, 'support-itemCenter', '商品中心', 0, 0, '/', NULL, 6, '/itemCenter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107, 'support-priceCenter', '价格中心', 0, 0, '/', NULL, 7, '/priceCenter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108, 'supportOrgCenter', '组织中心', 0, 0, '/', NULL, 8, '/orgCenter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109, 'sys', '系统中心', 0, 0, '/', NULL, 9, '/sys', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (110, 'workflow', '工作流', 0, 0, '/', NULL, 10, '/workflow', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112, 'fin', '结算中心', 0, 0, '/', NULL, 12, '/fin', NULL, NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-04 14:56:09.293768', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113, 'salesSupportCenter', '销售支持中心', 0, 0, '/', NULL, 13, '/salesSupportCenter', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114, 'hearquarterToSO', 'B2B销售业务', 0, 0, '/', NULL, 14, '/shell', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102001, 'oms-saleOrderManage', 'B端销售订单管理', 0, 102, '/102/', NULL, 1, '/order/saleOrderManage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102002, 'oms-dispatchBill', '发货单管理', 0, 102, '/102/', NULL, 2, '/order/dispatchBill', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102003, 'oms-groupOrderManage', '集团内销售订单管理', 0, 102, '/102/', NULL, 3, '/order/groupOrderManage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004, 'oms-salesReturnManage', '销售退货管理', 0, 102, '/102/', NULL, 4, '/order/salesReturnManage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102005, 'oms-orderConfig', '订单配置', 0, 102, '/102/', NULL, 5, '/order/orderConfig', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103001, 'seqmanage', '序列号管理', 0, 103, '/103/', NULL, 1, '/inventory/seqmanage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103002, 'wharehousesSetting', '仓库设置', 0, 103, '/103/', NULL, 2, '/inventory/wharehousessetting', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103003, 'purchaseReturn', '采购收货登记', 0, 103, '/103/', NULL, 3, '/inventory/purchaseReturn', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103004, 'suppDeliveryInfo', '供应商发货信息', 0, 103, '/103/', NULL, 4, '/inventory/suppdeliveryinfo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103005, 'inventoryBatchManage', '库存批次管理', 0, 103, '/103/', NULL, 5, '/inventory/inventorybatchmanage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103006, 'itemInventory', '商品库存参数', 0, 103, '/103/', NULL, 6, '/inventory/iteminventory', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103007, 'inventoryAssembly', '库存组装', 0, 103, '/103/', NULL, 7, '/inventory/assembly', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103008, 'inventoryCheck', '库存盘点', 0, 103, '/103/', NULL, 8, '/inventory/check', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103009, 'inventoryAdjust', '库存调整', 0, 103, '/103/', NULL, 9, '/inventory/adjust', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103010, 'InventoryTransfer', '库存转移', 0, 103, '/103/', NULL, 10, '/inventory/transfer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103011, 'inventorysearch', '库存查询', 0, 103, '/103/', NULL, 11, '/inventory/inventorysearch', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103012, 'itemCostPrice', '商品成本价', 0, 103, '/103/', NULL, 12, '/inventory/itemcostprice', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001, 'mg-purc-purcMdata', '采购基础数据', 0, 104, '/104/', NULL, 1, '/purc/mdata', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104002, 'mg-purc-purcSuppliers', '供应商管理', 0, 104, '/104/', NULL, 2, '/purc/suppliers', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104003, 'mg-purc-purcApply', '采购申请', 0, 104, '/104/', NULL, 3, '/purc/apply', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104004, 'mg-purc-purcContract', '采购合同', 0, 104, '/104/', NULL, 4, '/purc/contract', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104005, 'mg-purc-purcReturn', '采购退货', 0, 104, '/104/', NULL, 5, '/purc/return', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006, 'mg-purc-purcOrder', '采购订单', 0, 104, '/104/', NULL, 6, '/purc/purcorder', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104007, 'mg-purc-purcPrice', '采购价格', 0, 104, '/104/', NULL, 7, '/purc/price', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008, 'mg-purc-purcSettle', '采购结算', 0, 104, '/104/', NULL, 8, '/purc/settle', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (105001, 'logisticstracking', '物流追踪', 0, 105, '/105/', NULL, 1, '/logistics/tracking', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (105002, 'expressreconciliation', '快递对账', 0, 105, '/105/', NULL, 2, '/logistics/reconciliation', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106001, 'support-itemCenter-tag', '标签管理', 0, 106, '/106/', NULL, 1, '/itemCenter/tag', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106002, 'support-itemCenter-category', '商品品类', 0, 106, '/106/', NULL, 2, '/itemCenter/category', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106003, 'support-itemCenter-brand', '品牌管理', 0, 106, '/106/', NULL, 3, '/itemCenter/brand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106004, 'support-itemCenter-itemMgmt', '商品管理', 0, 106, '/106/', NULL, 4, '/itemCenter/item', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106005, 'support-itemCenter-productStructure', '产品结构管理', 0, 106, '/106/', NULL, 5, '/itemCenter/productStructure', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106006, 'support-itemCenter-businessDirectory', '商品经营目录', 0, 106, '/106/', NULL, 6, '/itemCenter/businessDirectory', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107001, 'support-priceCenter-itemMasterPrice', '商品主档价格', 0, 107, '/107/', NULL, 1, '/priceCenter/itemMasterPrice', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107002, 'support-priceCenter-categoryGross', '品类毛利', 0, 107, '/107/', NULL, 2, '/priceCenter/categoryGross', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107003, 'support-priceCenter-priceAudit', '价格审核', 0, 107, '/107/', NULL, 3, '/priceCenter/priceAudit', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108001, 'support-orgCenter-address', '地址簿', 0, 108, '/108/', NULL, 1, '/orgCenter/addr', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108002, 'support-orgCenter-orgData', '组织主数据', 0, 108, '/108/', NULL, 2, '/orgCenter/orgData', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108003, 'support-orgCenter-ouData', '公司主数据', 0, 108, '/108/', NULL, 3, '/orgCenter/ouData', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108004, 'support-orgCenter-orgTree', '组织树管理', 0, 108, '/108/', NULL, 4, '/orgCenter/orgTree', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108005, 'support-orgCenter-empData', '员工管理', 0, 108, '/108/', NULL, 5, '/orgCenter/empData', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108006, 'support-orgCenter-store', '门店管理', 0, 108, '/108/', NULL, 6, '/orgCenter/store', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109001, 'numbering', '发号器设置', 0, 109, '/109/', NULL, 1, '/sys/numbering', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109002, 'administration', '用户角色权限', 0, 109, '/109/', NULL, 2, '/sys/administration', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109003, 'metadata', '数据字典', 0, 109, '/109/', NULL, 3, '/sys/metadata', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109004, 'manage', '系统管理', 0, 109, '/109/', NULL, 4, '/sys/manage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109005, 'template', '模板管理', 0, 109, '/109/', NULL, 5, '/sys/template', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109006, 'message', '消息模板', 0, 109, '/109/', NULL, 6, '/sys/message', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109007, 'pic', '图片库管理', 0, 109, '/109/', NULL, 7, '/sys/pic', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (110001, 'processManage', '流程管理', 0, 110, '/110/', NULL, 1, '/workflow/processManage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001, 'purcSettlement', '采购结算管理', 0, 112, '/112/', NULL, 1, '/purcSettlement', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002, 'saleSettlement', '销售结算管理', 0, 112, '/112/', NULL, 2, '/saleSettlement', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112003, 'financeSettlementCapital', '资金管理', 0, 112, '/112/', NULL, 3, '/capital', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112004, 'finance', '财务工作台', 0, 112, '/112/', NULL, 4, '/finance', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112005, 'financeSettlementWithdraw', '提现管理', 0, 112, '/112/', NULL, 5, '/withdraw', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113001, 'customerManagementManage', '客户管理', 0, 113, '/113/', NULL, 1, '/salesSupportCenter/customerManagement', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113002, 'prospectiveCustomer', '潜在客户', 0, 113, '/113/', NULL, 2, '/salesSupportCenter/prospectiveCustomer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113003, 'priceManage', '价格管理', 0, 113, '/113/', NULL, 3, '/salesSupportCenter/priceManage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113004, 'bidManagement', '销售报价管理', 0, 113, '/113/', NULL, 4, '/salesSupportCenter/bidManagement', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114001, 'salesBasicConfiguration', '销售基础配置', 0, 114, '/114/', NULL, 1, '/shell/salesBasicConfiguration', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002, 'salesCollectionManagement', '销售收款管理', 0, 114, '/114/', NULL, 2, '/shell/salesCollectionManagement', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003, 'b2b-projectSale', '项目销售管理', 0, 114, '/114/', NULL, 3, '/shell/projectSale', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102001001, 'oms-saleOrderManage-saleOrderManage-list', '销售订单列表', 0, 102001, '/102/102001/', NULL, 1, '/order/saleOrderManage/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102001002, 'oms-saleOrderManage-orderQueryRegularOrder-create', '常规订单新建', 0, 102001, '/102/102001/', NULL, 2, '/order/saleOrderManage/orderQuery/regularOrder/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102001003, 'oms-saleOrderManage-orderQueryRegularOrder-edit', '常规订单编辑', 0, 102001, '/102/102001/', NULL, 3, '/order/saleOrderManage/orderQuery/regularOrder/edit/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102001004, 'oms-saleOrderManage-orderQueryRegularOrder-view', '常规订单详情', 0, 102001, '/102/102001/', NULL, 4, '/order/saleOrderManage/orderQuery/regularOrder/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102001005, 'oms-saleOrderManage-orderQueryTradeOrder-create', '贸易订单新建', 0, 102001, '/102/102001/', NULL, 5, '/order/saleOrderManage/orderQuery/tradeOrder/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102001009, 'oms-saleOrderManage-orderQueryContractOrder-create', '合同订单新建', 0, 102001, '/102/102001/', NULL, 9, '/order/saleOrderManage/orderQuery/contractOrder/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102001010, 'oms-saleOrderManage-orderHoldIndex', '销售订单暂挂查询', 0, 102001, '/102/102001/', NULL, 10, '/order/saleOrderManage/orderHold/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102002001, 'oms-dispatchBill-distributionInfo', '订单发货', 0, 102002, '/102/102002/', NULL, 1, '/order/dispatchBill/DistributionInfo/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102002002, 'oms-dispatchBill-list', '发货单列表', 0, 102002, '/102/102002/', NULL, 2, '/order/dispatchBill/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102002003, 'oms-dispatchBill-create', '发货单新增', 0, 102002, '/102/102002/', NULL, 3, '/order/dispatchBill/add/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102002004, 'oms-dispatchBill-edit', '发货单编辑', 0, 102002, '/102/102002/', NULL, 4, '/order/dispatchBill/edit/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102002005, 'oms-dispatchBill-view', '发货单详情', 0, 102002, '/102/102002/', NULL, 5, '/order/dispatchBill/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102003001, 'oms-groupOrderManage-list', '集团内订单列表', 0, 102003, '/102/102003/', NULL, 1, '/order/groupOrderManage/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102003002, 'oms-groupOrderManage-orderQueryGroupOrder-edit', '集团内销售单编辑', 0, 102003, '/102/102003/', NULL, 2, '/order/groupOrderManage/orderQuery/groupOrder/edit/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102003003, 'oms-groupOrderManage-orderQueryGroupOrder-view', '集团内销售单详情', 0, 102003, '/102/102003/', NULL, 3, '/order/groupOrderManage/orderQuery/groupOrder/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004001, 'oms-salesReturnManage-list', '退货订单列表', 0, 102004, '/102/102004/', NULL, 1, '/order/salesReturnManage/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004002, 'oms-salesReturnManage-JC-create', '即场退货新增', 0, 102004, '/102/102004/', NULL, 2, '/order/salesReturnManage/JC/add/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004003, 'oms-salesReturnManage-JC-edit', '即场退货编辑', 0, 102004, '/102/102004/', NULL, 3, '/order/salesReturnManage/JC/edit/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004004, 'oms-salesReturnManage-JC-view', '即场退货详情', 0, 102004, '/102/102004/', NULL, 4, '/order/salesReturnManage/JC/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004005, 'oms-salesReturnManage-KC-create', '客仓退货新增', 0, 102004, '/102/102004/', NULL, 5, '/order/salesReturnManage/KC/add/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004006, 'oms-salesReturnManage-KC-edit', '客仓退货编辑', 0, 102004, '/102/102004/', NULL, 6, '/order/salesReturnManage/KC/edit/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004007, 'oms-salesReturnManage-KC-view', '客仓退货详情', 0, 102004, '/102/102004/', NULL, 7, '/order/salesReturnManage/KC/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004008, 'oms-salesReturnManage-salseReturnReceive-list', '退货订单收货', 0, 102004, '/102/102004/', NULL, 8, '/order/salesReturnManage/salseReturnReceive/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004009, 'oms-salesReturnManage-salesReturnStorage-list', '退货收货单列表', 0, 102004, '/102/102004/', NULL, 9, '/order/salesReturnManage/salesReturnStorage/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004010, 'oms-salesReturnManage-salesReturnStorage-create', '退货收货单新增', 0, 102004, '/102/102004/', NULL, 10, '/order/salesReturnManage/salesReturnStorage/add/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004011, 'oms-salesReturnManage-salesReturnStorage-edit', '退货收货单编辑', 0, 102004, '/102/102004/', NULL, 11, '/order/salesReturnManage/salesReturnStorage/edit/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102004012, 'oms-salesReturnManage-salesReturnStorage-view', '退货收货单详情', 0, 102004, '/102/102004/', NULL, 12, '/order/salesReturnManage/salesReturnStorage/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102005001, 'oms-orderConfig-sceneIndex', '订单场景配置', 0, 102005, '/102/102005/', NULL, 1, '/order/orderConfig/scene/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102005002, 'oms-orderConfig-lineType', '订单行类型配置', 0, 102005, '/102/102005/', NULL, 2, '/order/orderConfig/lineType/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103001001, 'seqlist', '序列号列表', 0, 103001, '/103/103001/', NULL, 1, '/inventory/seqmanage/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103001002, 'md-inv-seqedit-edit', '序列号修改', 0, 103001, '/103/103001/', NULL, 2, '/inventory/seqmanage/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103001003, 'md-inv-seqedit-view', '序列号详情', 0, 103001, '/103/103001/', NULL, 3, '/inventory/seqmanage/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103002001, 'wharehousesSettingIndex', '仓库设置列表', 0, 103002, '/103/103002/', NULL, 1, '/inventory/wharehousessetting/wharehousessetting/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103002002, 'md-inv-wharehousesSettingEdit-create', '仓库设置新增', 0, 103002, '/103/103002/', NULL, 2, '/inventory/wharehousesSetting/wharehousessetting/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103002003, 'md-inv-wharehousesSettingEdit-edit', '仓库设置编辑', 0, 103002, '/103/103002/', NULL, 3, '/inventory/wharehousesSetting/wharehousessetting/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103002004, 'md-inv-wharehousesSettingEdit-view', '仓库设置详情', 0, 103002, '/103/103002/', NULL, 4, '/inventory/wharehousesSetting/wharehousessetting/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103003001, 'purchaseReturnIndex', '采购收货登记', 0, 103003, '/103/103003/', NULL, 1, '/inventory/purchaseReturn/purchaseReturn', NULL, NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-05 13:50:32.536712', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103003002, 'md-inv-purchaseReturnEdit-create', '采购收货登记新增', 0, 103003, '/103/103003/', NULL, 2, '/inventory/purchaseReturn/purchaseReturn/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103003003, 'md-inv-purchaseReturnEdit-edit', '采购收货登记编辑', 0, 103003, '/103/103003/', NULL, 3, '/inventory/purchaseReturn/purchaseReturn/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103003004, 'md-inv-purchaseReturnView-view', '采购收货登记详情', 0, 103003, '/103/103003/', NULL, 4, '/inventory/purchaseReturn/purchaseReturn/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103004001, 'suppDeliveryInfoIndex', '供应商发货信息', 0, 103004, '/103/103004/', NULL, 1, '/inventory/suppdeliveryinfo/list', NULL, NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-05 13:50:49.555817', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103004002, 'md-inv-suppDeliveryInfoEdit-create', '供应商发货信息新增', 0, 103004, '/103/103004/', NULL, 2, '/inventory/suppdeliveryinfo/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103004003, 'md-inv-suppDeliveryInfoEdit-edit', '供应商发货信息编辑', 0, 103004, '/103/103004/', NULL, 3, '/inventory/suppdeliveryinfo/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103004004, 'md-inv-suppDeliveryInfoView-view', '供应商发货信息详情', 0, 103004, '/103/103004/', NULL, 4, '/inventory/suppdeliveryinfo/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103005001, 'inventoryBatchManageIndex', '库存批次管理列表', 0, 103005, '/103/103005/', NULL, 1, '/inventory/inventoryBatchManage/inventorybatchmanage/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103005002, 'md-inv-inventoryBatchManageEdit-edit', '库存批次编辑', 0, 103005, '/103/103005/', NULL, 2, '/inventory/inventorybatchmanage/inventorybatchmanage/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103005003, 'md-inv-inventoryBatchManageView-view', '库存批次管理明细', 0, 103005, '/103/103005/', NULL, 3, '/inventory/inventorybatchmanage/inventorybatchmanage/index/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103006001, 'itemInventoryIndex', '商品库存参数列表', 0, 103006, '/103/103006/', NULL, 1, '/inventory/iteminventory/iteminventory/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103006002, 'md-inv-itemInventoryEdit-create', '商品库存参数新增', 0, 103006, '/103/103006/', NULL, 2, '/inventory/iteminventory/iteminventory/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103006003, 'md-inv-itemInventoryEdit-edit', '商品库存参数编辑', 0, 103006, '/103/103006/', NULL, 3, '/inventory/iteminventory/iteminventory/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103006004, 'md-inv-itemInventoryAddByBrand-create', '商品库存按品牌新增', 0, 103006, '/103/103006/', NULL, 4, '/inventory/iteminventory/iteminventoryaddbybrand', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103007001, 'inventoryAssemblyIndex', '库存组装', 0, 103007, '/103/103007/', NULL, 1, '/inventory/assembly/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103007002, 'md-inv-inventoryAssemblyEdit-create', '库存组装新增', 0, 103007, '/103/103007/', NULL, 2, '/inventory/assembly/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103007003, 'md-inv-inventoryAssemblyEdit-edit', '库存组装编辑', 0, 103007, '/103/103007/', NULL, 3, '/inventory/assembly/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103007004, 'md-inv-inventoryAssemblyView-view', '库存组装详情', 0, 103007, '/103/103007/', NULL, 4, '/inventory/assembly/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103008001, 'inventoryCheckIndex', '库存盘点', 0, 103008, '/103/103008/', NULL, 1, '/inventory/check/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103008002, 'md-inv-inventoryCreateIndex-create', '库存盘点创建', 0, 103008, '/103/103008/', NULL, 2, '/inventory/check/create/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103008003, 'md-inv-inventoryCheckIndexEdit-edit', '库存盘点编辑', 0, 103008, '/103/103008/', NULL, 3, '/inventory/check/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103008004, 'md-inv-inventoryCheckIndexView-view', '库存盘点详情', 0, 103008, '/103/103008/', NULL, 4, '/inventory/check/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103009001, 'inventoryAdjustIndex', '库存调整', 0, 103009, '/103/103009/', NULL, 1, '/inventory/adjust/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103009002, 'md-inv-inventoryAdjustEdit-create', '库存调整新增', 0, 103009, '/103/103009/', NULL, 2, '/inventory/adjust/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103009003, 'md-inv-inventoryAdjustEdit-edit', '库存调整编辑', 0, 103009, '/103/103009/', NULL, 3, '/inventory/adjust/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103009004, 'md-inv-inventoryAdjustView-view', '库存调整详情', 0, 103009, '/103/103009/', NULL, 4, '/inventory/adjust/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103010001, 'InventoryTransferIndex', '库存转移', 0, 103010, '/103/103010/', NULL, 1, '/inventory/transfer/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103010002, 'md-inv-InventoryTransferEdit-create', '库存转移新增', 0, 103010, '/103/103010/', NULL, 2, '/inventory/transfer/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103010003, 'md-inv-InventoryTransferEdit-edit', '库存转移编辑', 0, 103010, '/103/103010/', NULL, 3, '/inventory/transfer/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103010004, 'md-inv-InventoryTransferView-view', '库存转移详情', 0, 103010, '/103/103010/', NULL, 4, '/inventory/transfer/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103011001, 'inventorySearchStockava', '库存余额查询', 0, 103011, '/103/103011/', NULL, 1, '/inventory/inventorysearch/stockava', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103011002, 'inventorySearchIo', '库存移动记录查询', 0, 103011, '/103/103011/', NULL, 2, '/inventory/inventorysearch/io', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103011003, 'inventorySearchBatch', '批次库存查询', 0, 103011, '/103/103011/', NULL, 3, '/inventory/inventorysearch/batch', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103012001, 'itemCostPriceIndex', '商品成本价', 0, 103012, '/103/103012/', NULL, 1, '/inventory/itemcostprice/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103012002, 'md-inv-itemCostPriceEdit-create', '商品成本价新增', 0, 103012, '/103/103012/', NULL, 2, '/inventory/itemcostprice/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (103012003, 'md-inv-itemCostPriceEdit-edit', '商品成本价编辑', 0, 103012, '/103/103012/', NULL, 3, '/inventory/itemcostprice/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001001, 'mg-purc-purcMdataMoq', '采购最小起订量', 0, 104001, '/104/104001/', NULL, 1, '/purc/mdata/moq', NULL, NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-11 11:42:11.902361', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001002, 'mg-purc-purcMdataMoqEditCreate', '采购最小起订量新增', 0, 104001, '/104/104001/', NULL, 2, '/purc/mdata/moq/create/:type', NULL, NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-11 11:42:16.851955', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001003, 'mg-purc-purcMdataMoqEditEdit', '采购最小起订量编辑', 0, 104001, '/104/104001/', NULL, 3, '/purc/mdata/moq/edit/:type', NULL, NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-11 11:42:21.114110', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001004, 'mg-purc-purcMdataAap', '采购最低允收期', 0, 104001, '/104/104001/', NULL, 4, '/purc/mdata/aap', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001005, 'mg-purc-purcMdataAapEditCreate', '采购最低允收期新增', 0, 104001, '/104/104001/', NULL, 5, '/purc/mdata/aap/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001006, 'mg-purc-purcMdataAapEdit', '采购最低允收期编辑', 0, 104001, '/104/104001/', NULL, 6, '/purc/mdata/aap/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001007, 'mg-purc-purcMdataAccessories', '配件铺底额度维护', 0, 104001, '/104/104001/', NULL, 7, '/purc/mdata/accessories', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001008, 'mg-purc-purcMdataAccessoriesCreate', '配件铺底额度维护新增', 0, 104001, '/104/104001/', NULL, 8, '/purc/mdata/accessories/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001009, 'mg-purc-purcMdataAccessoriesEdit', '配件铺底额度维护编辑', 0, 104001, '/104/104001/', NULL, 9, '/purc/mdata/accessories/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001010, 'mg-purc-purcMdataPurchasedParts', '外购配件比例维护', 0, 104001, '/104/104001/', NULL, 10, '/purc/mdata/purchasedParts', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001011, 'mg-purc-purcMdataPurchasedPartsCreate', '外购配件比例新建', 0, 104001, '/104/104001/', NULL, 11, '/purc/mdata/purchasedParts/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104001012, 'mg-purc-purcMdataPurchasedPartsEdit', '外购配件比例编辑', 0, 104001, '/104/104001/', NULL, 12, '/purc/mdata/purchasedParts/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104002001, 'mg-purc-purcSuppliersList', '供应商查询', 0, 104002, '/104/104002/', NULL, 1, '/purc/suppliers/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104002002, 'mg-purc-purcSuppliersApply', '供应商申请查询', 0, 104002, '/104/104002/', NULL, 2, '/purc/suppliers/apply', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104002003, 'mg-purc-purcSuppliersApplyEdit', '供应商申请编辑', 0, 104002, '/104/104002/', NULL, 3, '/purc/suppliers/apply/edit/:name/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104002004, 'mg-purc-purcSuppliersApplyCreate', '供应商申请新建', 0, 104002, '/104/104002/', NULL, 4, '/purc/suppliers/apply/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104002005, 'mg-purc-purcSuppliersApplyView', '供应商申请详情', 0, 104002, '/104/104002/', NULL, 5, '/purc/suppliers/apply/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104003001, 'mg-purc-purcApplyIndex', '采购申请', 0, 104003, '/104/104003/', NULL, 1, '/purc/apply/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104003002, 'mg-purc-purcApplyIndexCreate', '采购申请新增', 0, 104003, '/104/104003/', NULL, 2, '/purc/apply/index/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104003003, 'mg-purc-purcApplyIndexEdit', '采购申请编辑', 0, 104003, '/104/104003/', NULL, 3, '/purc/apply/index/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104003004, 'mg-purc-purcApplyIndexView', '采购申请详情', 0, 104003, '/104/104003/', NULL, 4, '/purc/apply/index/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104004001, 'mg-purc-purcContractIndex', '采购合同', 0, 104004, '/104/104004/', NULL, 1, '/purc/contract/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104004002, 'mg-purc-purcContractIndexCreate', '采购合同新增', 0, 104004, '/104/104004/', NULL, 2, '/purc/contract/index/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104004003, 'mg-purc-purcContractIndexEdit', '采购合同编辑', 0, 104004, '/104/104004/', NULL, 3, '/purc/contract/index/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104004004, 'mg-purc-purcContractChangeEdit', '采购合同变更', 0, 104004, '/104/104004/', NULL, 4, '/purc/contract/changeEdit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104004005, 'mg-purc-purcContractIndexView', '采购合同详情', 0, 104004, '/104/104004/', NULL, 5, '/purc/contract/index/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104005001, 'mg-purc-purcReturnIndex', '采购退货', 0, 104005, '/104/104005/', NULL, 1, '/purc/return/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104005002, 'mg-purc-purcReturnIndexCreate', '采购退货新增', 0, 104005, '/104/104005/', NULL, 2, '/purc/return/index/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104005003, 'mg-purc-purcReturnIndexEdit', '采购退货编辑', 0, 104005, '/104/104005/', NULL, 3, '/purc/return/index/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104005004, 'mg-purc-purcReturnIndexView', '采购退货详情', 0, 104005, '/104/104005/', NULL, 4, '/purc/return/index/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104005005, 'mg-purc-purcReturnRma', '采购退货RMA', 0, 104005, '/104/104005/', NULL, 5, '/purc/return/rma', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104005006, 'mg-purc-purcReturnRmaCreate', '采购退货RMA新增', 0, 104005, '/104/104005/', NULL, 6, '/purc/return/rma/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104005007, 'mg-purc-purcReturnRmaEdit', '采购退货RMA编辑', 0, 104005, '/104/104005/', NULL, 7, '/purc/return/rma/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006001, 'mg-purc-purcOrderIndex', '采购订单', 0, 104006, '/104/104006/', NULL, 1, '/purc/purcorder/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006002, 'mg-purc-purcOrderCreate', '采购订单新增', 0, 104006, '/104/104006/', NULL, 2, '/purc/purcorder/create/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006003, 'mg-purc-purcOrderEdit', '采购订单编辑', 0, 104006, '/104/104006/', NULL, 3, '/purc/purcorder/edit/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006004, 'mg-purc-purcOrderView', '采购订单详情', 0, 104006, '/104/104006/', NULL, 4, '/purc/purcorder/index/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006005, 'mg-purc-purcOrderSubstitute', '一件代发(退)', 0, 104006, '/104/104006/', NULL, 5, '/purc/purcorder/substitute', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006006, 'mg-purc-purcOrderSceneIndex', '采购场景', 0, 104006, '/104/104006/', NULL, 6, '/purc/scene', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006007, 'mg-purc-purcOrderSceneCreate', '采购场景新增', 0, 104006, '/104/104006/', NULL, 7, '/purc/scene/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006008, 'mg-purc-purcOrderSceneEdit', '采购场景编辑', 0, 104006, '/104/104006/', NULL, 8, '/purc/scene/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006009, 'mg-purc-purcOrderLogistics', '物流状态管理', 0, 104006, '/104/104006/', NULL, 9, '/purc/purcorder/logistics', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006010, 'mg-purc-purcOrderLogisticsCreate', '物流状态管理新增', 0, 104006, '/104/104006/', NULL, 10, '/purc/purcorder/logistics/:type/:contrNo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104006011, 'mg-purc-purcOrderLogisticsEdit', '物流状态管理编辑', 0, 104006, '/104/104006/', NULL, 11, '/purc/purcorder/logistics/edit/:type/:contrNo', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104007001, 'mg-purc-purcPriceIndex', '采购价格', 0, 104007, '/104/104007/', NULL, 1, '/purc/price/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104007002, 'mg-purc-purcPriceApply', '采购价格申请单', 0, 104007, '/104/104007/', NULL, 2, '/purc/price/apply', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104007003, 'mg-purc-purcPriceApplyEdit', '采购价格申请单编辑', 0, 104007, '/104/104007/', NULL, 3, '/purc/price/apply/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008001, 'mg-purc-purcSettleBill', '对账单管理', 0, 104008, '/104/104008/', NULL, 1, '/purc/settle/bill', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008002, 'mg-purc-purcSettleBillView', '对账单详情', 0, 104008, '/104/104008/', NULL, 2, '/purc/settle/bill/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008003, 'mg-purc-purcSettleBillCreate', '对账单新增', 0, 104008, '/104/104008/', NULL, 3, '/purc/settle/bill/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008004, 'mg-purc-purcSettleBillEdit', '对账单编辑', 0, 104008, '/104/104008/', NULL, 4, '/purc/settle/bill/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008005, 'mg-purc-purcSettleFormalInvoice', '正式发票管理', 0, 104008, '/104/104008/', NULL, 5, '/purc/settle/formalinvoice', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008006, 'mg-purc-purcSettleFormalInvoiceEdit', '正式发票详情', 0, 104008, '/104/104008/', NULL, 6, '/purc/settle/formalinvoice/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008007, 'mg-purc-purcSettleFormView', '形式发票详情', 0, 104008, '/104/104008/', NULL, 7, '/purc/settle/formadmin/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008008, 'mg-purc-purcSettleFormAdmin', '形式发票管理', 0, 104008, '/104/104008/', NULL, 8, '/purc/settle/formadmin', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008009, 'mg-purc-purcSettleFormCreate', '形式发票新建', 0, 104008, '/104/104008/', NULL, 9, '/purc/settle/formadmin/create/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008010, 'mg-purc-purcSettleFormEdit', '形式发票修改', 0, 104008, '/104/104008/', NULL, 10, '/purc/settle/formadmin/edit/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008011, 'mg-purc-purcSettleAdPaymentApply', '预付款申请', 0, 104008, '/104/104008/', NULL, 11, '/purc/settle/AdPaymentApply', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008012, 'mg-purc-purcSettleAdPaymentApplyCreate', '预付款申请新建', 0, 104008, '/104/104008/', NULL, 12, '/purc/settle/AdPaymentApply/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008013, 'mg-purc-purcSettleAdPaymentApplyEdit', '预付款申请编辑', 0, 104008, '/104/104008/', NULL, 13, '/purc/settle/AdPaymentApply/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (104008014, 'mg-purc-purcSettleAdPaymentApplyView', '预付款申请详情', 0, 104008, '/104/104008/', NULL, 14, '/purc/settle/AdPaymentApply/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (105001001, 'expresscompanymaintenance', '快递公司维护', 0, 105001, '/105/105001/', NULL, 1, '/logistics/tracking/maintenance', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (105001002, 'expressinformationinquiry', '快递明细信息查询', 0, 105001, '/105/105001/', NULL, 2, '/logistics/tracking/informationinquiry', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (105001003, 'md-log-expressinformationdetail-view', '快递明细信息详情', 0, 105001, '/105/105001/', NULL, 3, '/logistics/tracking/informationinquiry/detail/:lno/:ono/:phone', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (105002001, 'expressreconciliation', '快递对账', 0, 105002, '/105/105002/', NULL, 1, '/logistics/reconciliation', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106001001, 'support-itemCenter-tag-list', '标签管理', 0, 106001, '/106/106001/', NULL, 1, '/itemCenter/tag/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106002001, 'support-itemCenter-category-list', '品类管理', 0, 106002, '/106/106002/', NULL, 1, '/itemCenter/category/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106002002, 'support-itemCenter-attribute', '属性管理', 0, 106002, '/106/106002/', NULL, 2, '/itemCenter/category/attribute', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106003001, 'support-itemCenter-brand-list', '品牌管理', 0, 106003, '/106/106003/', NULL, 1, '/itemCenter/brand/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106004001, 'support-itemCenter-item-list', '商品列表', 0, 106004, '/106/106004/', NULL, 1, '/itemCenter/item/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106004004, 'support-itemCenter-item-change', '变更商品', 0, 106004, '/106/106004/', NULL, 4, '/itemCenter/item/change/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106004005, 'support-itemCenter-item-view', '商品详情', 0, 106004, '/106/106004/', NULL, 5, '/itemCenter/item/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106005001, 'support-itemCenter-productStructure-list', '产品结构列表', 0, 106005, '/106/106005/', NULL, 1, '/itemCenter/productStructure/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106005002, 'support-itemCenter-productStructure-create', '产品结构新增', 0, 106005, '/106/106005/', NULL, 2, '/itemCenter/productStructure/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106005003, 'support-itemCenter-productStructure-edit', '产品结构编辑', 0, 106005, '/106/106005/', NULL, 3, '/itemCenter/productStructure/edit/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106005004, 'support-itemCenter-businessDirectory-view', '商品经营属性详情', 0, 106005, '/106/106005/', NULL, 4, '/itemCenter/businessDirectory/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106005005, 'support-itemCenter-productStructure-view', '产品结构详情', 0, 106005, '/106/106005/', NULL, 5, '/itemCenter/productStructure/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106006001, 'support-itemCenter-businessDirectory-publish', '经营目录管理', 0, 106006, '/106/106006/', NULL, 1, '/itemCenter/businessDirectory/index', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (106006002, 'support-itemCenter-businessDirectory-edit', '编辑商品经营属性', 0, 106006, '/106/106006/', NULL, 2, '/itemCenter/businessDirectory/edit/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107001001, 'support-priceCenter-itemMasterPrice-list', '商品主档价格查询', 0, 107001, '/107/107001/', NULL, 1, '/priceCenter/itemMasterPrice/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107001002, 'support-priceCenter-itemMasterPrice-create', '主档售价变更', 0, 107001, '/107/107001/', NULL, 2, '/priceCenter/itemMasterPrice/masterPriceChange/create/:type/:ids', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107001003, 'support-priceCenter-itemMasterPrice-view', '主档售价变更详情', 0, 107001, '/107/107001/', NULL, 3, '/priceCenter/itemMasterPrice/masterPriceChange/view/:type/:ids', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107001004, 'support-priceCenter-itemMasterPrice-edit', '编辑主档售价变更', 0, 107001, '/107/107001/', NULL, 4, '/priceCenter/itemMasterPrice/masterPriceChange/edit/:type/:ids', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107002001, 'support-priceCenter-categoryGross-create', '品类毛利变更', 0, 107002, '/107/107002/', NULL, 1, '/priceCenter/categoryGross/categoryChange/create/:type/:ids', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107002002, 'support-priceCenter-categoryGross-view', '品类毛利变更详情', 0, 107002, '/107/107002/', NULL, 2, '/priceCenter/categoryGross/categoryChange/view/:type/:ids', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107002003, 'support-priceCenter-categoryGross-edit', '编辑品类毛利变更', 0, 107002, '/107/107002/', NULL, 3, '/priceCenter/categoryGross/categoryChange/edit/:type/:ids', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107002004, 'support-priceCenter-categoryGross-list', '品类毛利查询', 0, 107002, '/107/107002/', NULL, 4, '/priceCenter/cateGoryGross/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (107003001, 'support-priceCenter-priceAudit-list', '价格审核查询', 0, 107003, '/107/107003/', NULL, 1, '/priceCenter/priceAudit/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108001001, 'support-orgCenter-address-list', '地址列表', 0, 108001, '/108/108001/', NULL, 1, '/orgCenter/addr/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108001002, 'support-orgCenter-address-view', '地址详情', 0, 108001, '/108/108001/', NULL, 2, '/orgCenter/addr/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108002001, 'support-orgCenter-orgData-list', '组织列表', 0, 108002, '/108/108002/', NULL, 1, '/orgCenter/orgData/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108002002, 'support-orgCenter-orgData-create', '新增组织', 0, 108002, '/108/108002/', NULL, 2, '/orgCenter/orgData/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108002003, 'support-orgCenter-orgData-view', '组织详情', 0, 108002, '/108/108002/', NULL, 3, '/orgCenter/orgData/detail/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108002004, 'support-orgCenter-orgData-edit', '编辑组织', 0, 108002, '/108/108002/', NULL, 4, '/orgCenter/orgData/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108003001, 'support-orgCenter-ouData-list', '公司列表', 0, 108003, '/108/108003/', NULL, 1, '/orgCenter/ouData/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108003002, 'support-orgCenter-ouData-create', '新建公司', 0, 108003, '/108/108003/', NULL, 2, '/orgCenter/ouData/add/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108003003, 'support-orgCenter-ouData-edit', '编辑公司', 0, 108003, '/108/108003/', NULL, 3, '/orgCenter/ouData/edit/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108003004, 'support-orgCenter-ouData-view', '公司详情', 0, 108003, '/108/108003/', NULL, 4, '/orgCenter/ouData/detail/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108004001, 'support-orgCenter-orgTree-list', '组织树列表', 0, 108004, '/108/108004/', NULL, 1, '/orgCenter/orgTree/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108004002, 'support-orgCenter-orgTree-create', '组织树新增', 0, 108004, '/108/108004/', NULL, 2, '/orgCenter/orgTree/add', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108004003, 'support-orgCenter-orgTree-permission-edit', '组织树权限编辑', 0, 108004, '/108/108004/', NULL, 3, '/orgCenter/orgTree/permission/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108004004, 'support-orgCenter-orgTree-edit', '组织树编辑', 0, 108004, '/108/108004/', NULL, 4, '/orgCenter/orgTree/edit/:id/:version', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108004005, 'support-orgCenter-orgTree-newVersion-create', '创建组织树新版本', 0, 108004, '/108/108004/', NULL, 5, '/orgCenter/orgTree/newVersion/:id/:version', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108004006, 'support-orgCenter-orgTree-resume-view', '组织树履历', 0, 108004, '/108/108004/', NULL, 6, '/orgCenter/orgTree/resume/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108005001, 'support-orgCenter-empData-list', '员工列表', 0, 108005, '/108/108005/', NULL, 1, '/orgCenter/empData/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108005002, 'support-orgCenter-empData-create', '员工新增', 0, 108005, '/108/108005/', NULL, 2, '/orgCenter/empData/create/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108005003, 'support-orgCenter-empData-view', '员工详情', 0, 108005, '/108/108005/', NULL, 3, '/orgCenter/empData/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108005004, 'support-orgCenter-empData-edit', '员工编辑', 0, 108005, '/108/108005/', NULL, 4, '/orgCenter/empData/edit/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108006001, 'support-orgCenter-store-list', '门店列表', 0, 108006, '/108/108006/', NULL, 1, '/orgCenter/store/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108006002, 'support-orgCenter-store-create', '门店新增', 0, 108006, '/108/108006/', NULL, 2, '/orgCenter/store/create/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108006003, 'support-orgCenter-store-view', '门店详情', 0, 108006, '/108/108006/', NULL, 3, '/orgCenter/store/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (108006004, 'support-orgCenter-store-edit', '门店编辑', 0, 108006, '/108/108006/', NULL, 4, '/orgCenter/store/edit/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109001001, 'rules', '规则设置', 0, 109001, '/109/109001/', NULL, 1, '/sys/numbering/rules', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109001002, 'nextnum', '下一编号', 0, 109001, '/109/109001/', NULL, 2, '/sys/numbering/nextnum', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109002001, 'users', '用户列表', 0, 109002, '/109/109002/', NULL, 1, '/sys/administration/users', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109002003, 'permissions', '权限列表', 0, 109002, '/109/109002/', NULL, 5, '/sys/administration/permissions', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109002004, 'workflowRole', '流程角色列表', 0, 109002, '/109/109002/', NULL, 3, '/sys/administration/workflowrole', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109002005, 'dataRole', '数据角色列表', 0, 109002, '/109/109002/', NULL, 4, '/sys/administration/datarole', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109003001, 'udc', '分类码管理', 0, 109003, '/109/109003/', NULL, 1, '/sys/metadata/udc', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109003002, 'setting', '系统设置', 0, 109003, '/109/109003/', NULL, 2, '/sys/metadata/setting', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109004001, 'oauth2', 'OAuth2管理', 0, 109004, '/109/109004/', NULL, 1, '/sys/manage/oauth2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109005001, 'template_category', '模板分类', 0, 109005, '/109/109005/', NULL, 1, '/sys/template/rules', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109005002, 'template', '模板管理', 0, 109005, '/109/109005/', NULL, 2, '/sys/template/manage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109006001, 'messageTemplateList', '消息模板列表', 0, 109006, '/109/109006/', NULL, 1, '/sys/message/templateList', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109006002, 'messageTopicList', '消息主题列表', 0, 109006, '/109/109006/', NULL, 2, '/sys/message/topicList', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109007001, 'picTag', '图片标签管理', 0, 109007, '/109/109007/', NULL, 1, '/sys/pic/tag', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109007002, 'picManage', '图片管理', 0, 109007, '/109/109007/', NULL, 2, '/sys/pic/manage', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (110001001, 'processCategory', '流程类别', 0, 110001, '/110/110001/', NULL, 1, '/workflow/processManage/processCategory', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (110001002, 'processDefinition', '流程定义', 0, 110001, '/110/110001/', NULL, 2, '/workflow/processManage/processDefinition', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (110001003, 'processInstance', '流程实例', 0, 110001, '/110/110001/', NULL, 3, '/workflow/processManage/processInstance', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (110001004, 'myProcess', '我的流程', 0, 110001, '/110/110001/', NULL, 4, '/workflow/processManage/myProcess', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (110001005, 'resetTaskhandler', '重置任务处理人', 0, 110001, '/110/110001/', NULL, 5, '/workflow/processManage/resetTaskhandler', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (111001001, 'messageTemplateList', '消息模板列表', 0, 111001, '/111/111001/', NULL, 1, '/message/messageTemplate/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (111002001, 'messageTopicList', '消息主题列表', 0, 111002, '/111/111002/', NULL, 1, '/message/messageTopic/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001001, 'purcSettlementsDefinition', '采购结算单定义', 0, 112001, '/112/112001/', NULL, 1, '/purcSettlement/Buyer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001002, 'sourcingScenario', '采购场景', 0, 112001, '/112/112001/', NULL, 2, '/purcSettlement/Buyer/detail/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001003, 'purcSettlements', '采购结算单', 0, 112001, '/112/112001/', NULL, 3, '/purcSettlement/statement', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001004, 'purcSettlementView', '采购结算单审核明细查看', 0, 112001, '/112/112001/', NULL, 4, '/purcSettlement/statement/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001005, 'purcSettlementImprest', '付款单类型定义', 0, 112001, '/112/112001/', NULL, 5, '/purcSettlement/imprest', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001006, 'procurementSettlementType', '采购结算类型', 0, 112001, '/112/112001/', NULL, 6, '/purcSettlement/procurementSettlementType/detail/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001007, 'LookfirmPurchase', '查看公司', 0, 112001, '/112/112001/', NULL, 7, '/purcSettlement/imprest/LookfirmPurchase/detail/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001008, 'paymentOrder', '付款单', 0, 112001, '/112/112001/', NULL, 8, '/purcSettlement/payment', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001009, 'LookfirmPayment', '查看公司', 0, 112001, '/112/112001/', NULL, 9, '/purcSettlement/imprest/detail/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001010, 'paymentOrderLook', '付款单审核明细查看', 0, 112001, '/112/112001/', NULL, 10, '/purcSettlement/payment/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001011, 'purcSettlementImprestVerify', '核销管理', 0, 112001, '/112/112001/', NULL, 11, '/purcSettlement/imprestVerify', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112001012, 'purcSettlementImprestView', '付款核销明细', 0, 112001, '/112/112001/', NULL, 12, '/purcSettlement/imprestVerify/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002001, 'saleSettlementDefinition', '销售结算单类型定义', 0, 112002, '/112/112002/', NULL, 1, '/saleSettlement/definition', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002002, 'saleSettlementDefinitionCompanyView', '查看公司', 0, 112002, '/112/112002/', NULL, 2, '/saleSettlement/companyView/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002003, 'saleSettlements', '销售结算单', 0, 112002, '/112/112002/', NULL, 3, '/saleSettlement/statement', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002004, 'saleSettlementEdit', '销售结算单审核查看', 0, 112002, '/112/112002/', NULL, 4, '/saleSettlement/sale/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002005, 'saleSettlementViewDetail', '销售结算单明细查看', 0, 112002, '/112/112002/', NULL, 5, '/saleSettlement/saleDetail/:id/:num', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002006, 'saleSettlementReceiptSet', '收款单类型定义', 0, 112002, '/112/112002/', NULL, 6, '/saleSettlement/receiptSet', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002007, 'saleSettlementReceipt', '收款结算单', 0, 112002, '/112/112002/', NULL, 7, '/saleSettlement/receipt', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002008, 'saleSettlementReceiptView', '收款结算单审核查看', 0, 112002, '/112/112002/', NULL, 8, '/saleSettlement/receipt/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002009, 'saleSettlementReceiptViewDetail', '收款结算单明细查看', 0, 112002, '/112/112002/', NULL, 9, '/saleSettlement/receipt/viewDetail/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002010, 'saleSettlementReceiptVerify', '收款核销管理', 0, 112002, '/112/112002/', NULL, 10, '/saleSettlement/receiptVerify', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112002011, 'saleSettlementReceiptVerifyView', '收款核销明细', 0, 112002, '/112/112002/', NULL, 11, '/saleSettlement/receiptVerify/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112003001, 'financeSettlementCapitalPayment', '待支付信息确认', 0, 112003, '/112/112003/', NULL, 1, '/capital/payment', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112003002, 'financeSettlementCapitalFlowing', '流水管理', 0, 112003, '/112/112003/', NULL, 2, '/capital/flowing', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112004001, 'financeReceiptBankCheck', '账单核对', 0, 112004, '/112/112004/', NULL, 1, '/finance/receipt/BankCheck', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112004002, 'financeReceiptCharge', '手续费确认', 0, 112004, '/112/112004/', NULL, 2, '/finance/receipt/charge', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112005001, 'financeSettlementWithdrawApplication', '提现付款单', 0, 112005, '/112/112005/', NULL, 1, '/withdraw/application', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112005002, 'financeSettlementWithdrawApplicationCheck', '提现付款单明细', 0, 112005, '/112/112005/', NULL, 2, '/withdraw/application/check/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112005003, 'financeSettlementWithdrawApplicationHandle', '提现付款单新增', 0, 112005, '/112/112005/', NULL, 3, '/withdraw/application/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (112005004, 'financeSettlementWithdrawApplicationHandleEdit', '提现付款单修改', 0, 112005, '/112/112005/', NULL, 4, '/withdraw/application/edit/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113001001, 'customerManagementList', '客户信息查询', 0, 113001, '/113/113001/', NULL, 1, '/salesSupportCenter/customerManagement/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113001003, 'b2b-salesSupportCenter-customerManagement-create', '添加客户', 0, 113001, '/113/113001/', NULL, 3, '/salesSupportCenter/customerManagement/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113001004, 'b2b-salesSupportCenter-customerManagement-view', '客户详情', 0, 113001, '/113/113001/', NULL, 4, '/salesSupportCenter/customerManagement/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113001005, 'b2b-salesSupportCenter-customerManagement-edit', '编辑客户', 0, 113001, '/113/113001/', NULL, 5, '/salesSupportCenter/customerManagement/modify/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113002001, 'prospectiveCustomerList', '潜在客户查询', 0, 113002, '/113/113002/', NULL, 1, '/salesSupportCenter/prospectiveCustomer/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113002002, 'b2b-salesSupportCenter-prospectiveCustomer-create', '添加潜在客户', 0, 113002, '/113/113002/', NULL, 2, '/salesSupportCenter/prospectiveCustomer/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113002003, 'b2b-salesSupportCenter-prospectiveCustomer-view', '潜在客户详情', 0, 113002, '/113/113002/', NULL, 3, '/salesSupportCenter/prospectiveCustomer/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113002004, 'b2b-salesSupportCenter-prospectiveCustomer-edit', '编辑潜在客户', 0, 113002, '/113/113002/', NULL, 4, '/salesSupportCenter/prospectiveCustomer/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113003001, 'priceManageList', '价格信息查询', 0, 113003, '/113/113003/', NULL, 1, '/salesSupportCenter/priceManage/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113003002, 'b2b-salesSupportCenter-customerPrice-edit', 'b端客户价格编辑', 0, 113003, '/113/113003/', NULL, 2, '/salesSupportCenter/priceManage/customerPrice', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113003003, 'b2b-salesSupportCenter-customerGroupPrice-edit', '客户等级销售价格编辑', 0, 113003, '/113/113003/', NULL, 3, '/salesSupportCenter/priceManage/customerGroupPrice', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113003004, 'b2b-salesSupportCenter-externalBasePrice-edit', 'b端基础价编辑', 0, 113003, '/113/113003/', NULL, 4, '/salesSupportCenter/priceManage/externalBasePrice', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113003005, 'b2b-salesSupportCenter-internalSetPrice-edit', 'b端内部结算价编辑', 0, 113003, '/113/113003/', NULL, 5, '/salesSupportCenter/priceManage/internalSetPrice', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113003006, 'priceApprovalList', '价格审核查询', 0, 113003, '/113/113003/', NULL, 6, '/salesSupportCenter/priceManage/priceApproval', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113003007, 'b2b-salesSupportCenter-priceApproval-view', '价格审核详情', 0, 113003, '/113/113003/', NULL, 7, '/salesSupportCenter/priceManage/priceApproval/view/:id/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113003008, 'b2b-salesSupportCenter-priceApproval-edit', '价格审核编辑', 0, 113003, '/113/113003/', NULL, 8, '/salesSupportCenter/priceManage/priceApproval/edit/:id/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113004001, 'bidManagementList', '销售报价查询', 0, 113004, '/113/113004/', NULL, 1, '/salesSupportCenter/bidManagement/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113004002, 'b2b-salesSupportCenter-bidManagement-create', '添加销售报价', 0, 113004, '/113/113004/', NULL, 2, '/salesSupportCenter/bidManagement/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113004003, 'b2b-salesSupportCenter-bidManagement-view', '销售报价详情', 0, 113004, '/113/113004/', NULL, 3, '/salesSupportCenter/bidManagement/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (113004004, 'b2b-salesSupportCenter-bidManagement-edit', '编辑销售报价', 0, 113004, '/113/113004/', NULL, 4, '/salesSupportCenter/bidManagement/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114001001, 'configByDocType', '按单据类型的审批配置', 0, 114001, '/114/114001/', NULL, 1, '/shell/salesBasicConfiguration/configByDocType', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002001, 'checkForMgList', '对账单查询', 0, 114002, '/114/114002/', NULL, 1, '/shell/salesCollectionManagement/checkForMg/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002002, 'b2b-b2bSell-checkForMg-creat', '对账单新增', 0, 114002, '/114/114002/', NULL, 2, '/shell/salesCollectionManagement/checkForMg/creat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002003, 'b2b-b2bSell-checkForMg-view', '对账单查看', 0, 114002, '/114/114002/', NULL, 3, '/shell/salesCollectionManagement/checkForMg/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002004, 'b2b-b2bSell-checkForMg-edit', '对账单编辑', 0, 114002, '/114/114002/', NULL, 4, '/shell/salesCollectionManagement/checkForMg/edit/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002005, 'creditMgList', '收款单查询', 0, 114002, '/114/114002/', NULL, 5, '/shell/salesCollectionManagement/creditMg/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002006, 'b2b-b2bSell-creditMg-creat', '收款单新增', 0, 114002, '/114/114002/', NULL, 6, '/shell/salesCollectionManagement/creditMg/creat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002007, 'b2b-b2bSell-creditMg-edit', '收款单编辑', 0, 114002, '/114/114002/', NULL, 7, '/shell/salesCollectionManagement/creditMg/edit/:id/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002008, 'b2b-b2bSell-creditMg-view', '收款单查看', 0, 114002, '/114/114002/', NULL, 8, '/shell/salesCollectionManagement/creditMg/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002009, 'makeOutAnInvoiceMgList', '开票申请查询', 0, 114002, '/114/114002/', NULL, 9, '/shell/salesCollectionManagement/makeOutAnInvoiceMg/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002010, 'b2b-b2bSell-makeOutAnInvoiceMg-creat', '开票申请新增', 0, 114002, '/114/114002/', NULL, 10, '/shell/salesCollectionManagement/makeOutAnInvoiceMg/creat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002011, 'b2b-b2bSell-makeOutAnInvoiceMg-edit', '开票申请编辑', 0, 114002, '/114/114002/', NULL, 11, '/shell/salesCollectionManagement/makeOutAnInvoiceMg/edit/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002012, 'b2b-b2bSell-makeOutAnInvoiceMg-view', '开票申请查看', 0, 114002, '/114/114002/', NULL, 12, '/shell/salesCollectionManagement/makeOutAnInvoiceMg/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002013, 'refundMgList', '退款申请查询', 0, 114002, '/114/114002/', NULL, 13, '/shell/salesCollectionManagement/refundMg/list', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002014, 'b2b-b2bSell-refundMg-creat', '退款单新增', 0, 114002, '/114/114002/', NULL, 14, '/shell/salesCollectionManagement/refundMg/creat', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002015, 'b2b-b2bSell-refundMg-view', '退款单查看', 0, 114002, '/114/114002/', NULL, 15, '/shell/salesCollectionManagement/refundMg/view/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114002016, 'b2b-b2bSell-refundMg-edit', '退款单编辑', 0, 114002, '/114/114002/', NULL, 16, '/shell/salesCollectionManagement/refundMg/edit/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003001, 'b2b-projectSale-project', '项目信息查询', 0, 114003, '/114/114003/', NULL, 1, '/shell/projectSale/project', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003002, 'b2b-projectSale-project-create', '项目信息录入', 0, 114003, '/114/114003/', NULL, 2, '/shell/projectSale/project/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003003, 'b2b-projectSale-project-view', '项目信息详情', 0, 114003, '/114/114003/', NULL, 3, '/shell/projectSale/project/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003004, 'b2b-projectSale-project-edit', '项目信息编辑', 0, 114003, '/114/114003/', NULL, 4, '/shell/projectSale/project/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003005, 'b2b-projectSale-contract', '项目合同查询', 0, 114003, '/114/114003/', NULL, 5, '/shell/projectSale/contract', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003006, 'b2b-projectSale-checkQuery', '项目验收查询', 0, 114003, '/114/114003/', NULL, 6, '/shell/projectSale/checkQuery', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003007, 'b2b-projectSale-checkQuery-create', '新建项目验收', 0, 114003, '/114/114003/', NULL, 7, '/shell/projectSale/checkQuery/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003008, 'b2b-projectSale-checkQuery-view', '项目验收详情', 0, 114003, '/114/114003/', NULL, 8, '/shell/projectSale/checkQuery/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003009, 'b2b-projectSale-checkQuery-edit', '编辑项目验收', 0, 114003, '/114/114003/', NULL, 9, '/shell/projectSale/checkQuery/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003010, 'b2b-projectSale-contract-create', '新建合同', 0, 114003, '/114/114003/', NULL, 10, '/shell/projectSale/contract/create', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003011, 'b2b-projectSale-contract-view', '合同详情', 0, 114003, '/114/114003/', NULL, 11, '/shell/projectSale/contract/view/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003012, 'b2b-projectSale-contract-edit', '编辑合同', 0, 114003, '/114/114003/', NULL, 12, '/shell/projectSale/contract/:type/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (114003013, 'b2b-projectSale-collection', '项目收款计划', 0, 114003, '/114/114003/', NULL, 13, '/shell/projectSale/collection', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (102001010001, 'oms-saleOrderManage-orderHoldedit', '销售暂挂编辑', 0, 102001010, '/102/102001/102001010/', NULL, 1, '/order/saleOrderManage/orderHold/edit/:id', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109002001001, 'create', '新增用户', 1, 109002001, '/109/109002/109002001', NULL, 1, '/', 'POST', NULL, NULL, 0, '2021-11-03 17:46:16.000000', 356948235909079040, '2022-02-15 18:19:54.332218', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109002001002, 'system-user-edit', '编辑用户', 1, 109002001, '/109/109002/109002001', NULL, 2, '/', NULL, NULL, NULL, 0, '2021-11-03 17:46:16.000000', 356948235909079040, '2022-01-14 11:21:16.996989', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109002005001, 'system-dataRoleDetail-add', '数据角色新增', 0, 109002005, '/109/109002/109002005', NULL, 1, '/sys/administration/dataroledetail/new', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109002005002, 'system-dataRoleDetail-edit', '数据角色编辑', 0, 109002005, '/109/109002/109002005', NULL, 2, '/sys/administration/dataroledetail/edit/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (388038636187480395, 'approle', '应用角色列表', 0, 109002, '/109/109002/', NULL, 2, '/sys/administration/approle', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446068248775909376, 'oms-order-db-create-bill', '生成发货单', 1, 102002001, '/102/102002/102002001/', NULL, 0, '/order/salDo/checkCreateDetail', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446068398676140032, 'oms-order-db-query', '查询', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446068520742969344, 'oms-order-db-cancel', '取消', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/cancelBatch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446068647771660288, 'oms-order-db-list-confirm', '确认', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/confirmBatch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446068785911062528, 'oms-order-db-cancel-confirm', '撤销确认', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/cancelConfirmBatch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446068867083427840, 'oms-order-db-shipments', '发货', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/shipBatch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446068942799003648, 'oms-order-db-signIn', '签收', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/sign', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446069019907088384, 'oms-order-db-export', '导出', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/order/salDo/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446069120641687552, 'oms-order-db-print', '打印', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/print/', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446069205047861248, 'oms-order-db-view', '详情', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/findIdOne/', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446069349923315712, 'oms-order-db-add-logistics', '添加物流号', 1, 102002005, '/102/102002/102002005/', NULL, 0, '/order/salLogislog/createOne', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446069459017162752, 'oms-order-db-del-logistics', '删除', 1, 102002005, '/102/102002/102002005/', NULL, 0, '/order/salLogislog/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446069587639689216, 'oms-order-db-save', '保存', 1, 102002003, '/102/102002/102002003/', NULL, 0, '/order/salDo/saveOne', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446069685526355968, 'oms-order-db-confirm', '确认', 1, 102002003, '/102/102002/102002003/', NULL, 0, '/order/salDo/confirmOne', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446069915286134784, 'oms-order-sr-query', '查询', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/order/salSoReturn/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446070182480076800, 'oms-order-sr-view', '详情', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/order/salSoReturn/rWOrderDetail/', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446070305037639680, 'oms-order-sr-jc-save', '保存', 1, 102004002, '/102/102004/102004002/', NULL, 0, '/order/salSoReturn/rWOrderSave', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446070654020509696, 'oms-order-sr-jc-confirm', '确认', 1, 102004002, '/102/102004/102004002/', NULL, 0, '/order/salSoReturn/rWOrderSubmit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446076439722676224, 'oms-order-salelist-submit', '提交', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/order/salSo/submitList', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446076871488524288, 'oms-order-salelist-query', '查询', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/order/salSo/query', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446077211382337536, 'oms-order-salelist-cancel', '取消', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/order/salSo/calcelSalSo', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446077348628353024, 'oms-order-salelist-close', '关闭', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/order/salSo/closeSalSo', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446077486469959680, 'oms-order-salelist-audit-pending', '暂挂', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/order/salSoHold/artificialHold', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446077591545663488, 'oms-order-salelist-export', '导出', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/order/salSo/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446077798400348160, 'oms-order-sale-save', '保存', 1, 102001002, '/102/102001/102001002/', NULL, 0, '/order/salSo/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446077875810422784, 'oms-order-sale-submit', '提交', 1, 102001002, '/102/102001/102001002/', NULL, 0, '/order/salSo/submit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446078570638823424, 'oms-order-sale-del-item', '删除商品', 1, 102001003, '/102/102001/102001003/', NULL, 0, '/order/salSo/deleteSalsod ', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446078720958484480, 'oms-order-sale-del-alloc', '删除配货信息', 1, 102001003, '/102/102001/102001003/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446078957890523136, 'oms-order-sale-hand-alloc', '手工配货', 1, 102001003, '/102/102001/102001003/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446079140594405376, 'oms-order-sale-auto-alloc', '自动配货', 1, 102001003, '/102/102001/102001003/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446272936657506304, 'oms-order-salelist-edit', '编辑', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446273317814882304, 'oms-order-hold-query', '查询', 1, 102001010, '/102/102001/102001010/', NULL, 0, '/order/salSoHold/select', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446273485960335360, 'oms-order-salelist-regular-create', '常规订单创建', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446273674070675456, 'oms-order-hold-release-line', '选中行释放', 1, 102001010, '/102/102001/102001010/', NULL, 0, '/order/salSoHold/releaseLine', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446273932443996160, 'oms-order-hold-release-all', '释放选中订单的所有暂挂', 1, 102001010, '/102/102001/102001010/', NULL, 0, '/order/salSoHold/release', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446273952949948416, 'oms-order-salelist-view', '销售订单号链接', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/order/salSo/orderDetail/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446274744985538560, 'oms-order-hold-edit', '编辑', 1, 102001010, '/102/102001/102001010/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446275963229523968, 'oms-order-grolist-query', '查询', 1, 102003001, '/102/102003/102003001/', NULL, 0, '/order/salSo/query', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446276042027913216, 'oms-order-grolist-edit', '编辑', 1, 102003001, '/102/102003/102003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446276060986167296, 'oms-order-re-query', '查询', 1, 102004008, '/102/102004/102004008/', NULL, 0, '/order/salSoReturn/searchReturn', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446276696188342272, 'oms-order-rs-query', '查询', 1, 102004009, '/102/102004/102004009/', NULL, 0, '/order/salRDo/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446276861511028736, 'oms-order-rs-edit', '编辑', 1, 102004009, '/102/102004/102004009/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446277049814306816, 'oms-order-rs-cancel', '取消', 1, 102004009, '/102/102004/102004009/', NULL, 0, '/order/salRDo/cancelBatch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446277346905247744, 'oms-order-rs-signIn', '签收', 1, 102004009, '/102/102004/102004009/', NULL, 0, '/order/salRDo/sign', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446277622831730688, 'oms-order-rs-save', '保存', 1, 102004010, '/102/102004/102004010/', NULL, 0, '/order/salRDo/saveSalDO', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446278387751145472, '采购MOQ', '/', 1, 104001001, '/104/104001/104001001/', NULL, 0, '/', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446278584942153728, 'oms-order-rs-add-logistics', '添加物流信息', 1, 102004011, '/102/102004/102004011/', NULL, 0, '/order/salLogislog/createOne', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446278849997000704, 'oms-order-rs-del-logistics', '删除物流信息', 1, 102004011, '/102/102004/102004011/', NULL, 0, '/order/salLogislog/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446279151106084864, 'oms-order-scene-query', '查询', 1, 102005001, '/102/102005/102005001/', NULL, 0, '/order/salScene/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446279279967686656, 'oms-order-scene-add', '新增', 1, 102005001, '/102/102005/102005001/', NULL, 0, '/order/salScene/createOne', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446279394593820672, 'oms-order-scene-edit', '编辑', 1, 102005001, '/102/102005/102005001/', NULL, 0, '/order/salScene/update', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446279529256144896, 'oms-order-scene-del', '删除', 1, 102005001, '/102/102005/102005001/', NULL, 0, '/order/salScene/updateDeleteFlag/batch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446279693509283840, 'sup-org-addr-query', '查询', 1, 108001001, '/108/108001/108001001/', NULL, 0, '/org/addr/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446279696059420672, 'mg-pur-moq-query', '查询', 1, 104001001, '/104/104001/104001001/', NULL, 0, '/pur/purMoq/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446279843375960064, 'oms-order-linetype-query', '查询', 1, 102005002, '/102/102005/102005002/', NULL, 0, '/order/salLinetype/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446279946354511872, 'oms-order-linetype-add', '新增', 1, 102005002, '/102/102005/102005002/', NULL, 0, '/order/salLinetype/createOne', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280047839891456, 'oms-order-linetype-edit', '编辑', 1, 102005002, '/102/102005/102005002/', NULL, 0, '/order/salLinetype/update', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280102034493440, 'sup-price-item-query', '查询', 1, 107001001, '/107/107001/107001001/', NULL, 0, '/pri/priMainPrice/itemList', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280124633403392, 'sup-item-tag-query', '查询', 1, 106001001, '/106/106001/106001001/', NULL, 0, '/itm/tag/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280125098971136, 'mg-pur-moq-del', '删除', 1, 104001001, '/104/104001/104001001/', NULL, 0, '/pur/purMoq/deleteBatch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280143830732800, 'oms-order-linetype-del', '删除', 1, 102005002, '/102/102005/102005002/', NULL, 0, '/order/salLinetype/updateDeleteFlag/batch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280292275539968, 'mg-pur-moq-export', '导出', 1, 104001001, '/104/104001/104001001/', NULL, 0, '/pur/purMoq/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280300664147968, 'sup-item-tag-create', '新增', 1, 106001001, '/106/106001/106001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280425549549568, 'sup-item-tag-edit', '编辑', 1, 106001001, '/106/106001/106001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280458294480896, 'mg-inv-seq-query', '查询', 1, 103001001, '/103/103001/103001001/', NULL, 0, '/Inv/Serial/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280484882173952, 'sup-org-list-query', '查询', 1, 108002001, '/108/108002/108002001/', NULL, 0, '/org/orgBu/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280509771173888, 'oms-order-grolist-submit', '提交', 1, 102003001, '/102/102003/102003001/', NULL, 0, '/order/salSo/submitList', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280518663098368, 'oms-order-re-return-storage', '生成退货收库单', 1, 102004008, '/102/102004/102004008/', NULL, 0, '/order/salRDo/checkReturnInfo', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280582940807168, 'oms-order-grolist-cancel', '取消', 1, 102003001, '/102/102003/102003001/', NULL, 0, '/order/salSo/calcelSalSo', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280764570947584, '录入收款单', '新增收款(del)', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280907814817792, 'sup-item-tag-start', '启用', 1, 106001001, '/106/106001/106001001/', NULL, 0, '/itm/tag/switch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280951636905984, 'b2b-credit-add', '新增收款', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280959819993088, 'sup-item-tag-disabled', '禁用', 1, 106001001, '/106/106001/106001001/', NULL, 0, '/itm/tag/switch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446280993085018112, 'sup-org-list-create', '新增', 1, 108002001, '/108/108002/108002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281117823619072, 'sup-item-tag-del', '删除', 1, 106001001, '/106/106001/106001001/', NULL, 0, '/itm/tag/remove/{id}', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281126065426432, 'sup-org-list-edit', '编辑', 1, 108002001, '/108/108002/108002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281241496866816, 'sup-org-list-confirm', '确认', 1, 108002001, '/108/108002/108002001/', NULL, 0, '/org/orgBu/updateOrgBuStatus', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281246840410112, 'b2b-credit-query', '查询', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/sal/receipt/query', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281369070817280, 'mg-inv-seq-edit', '修改', 1, 103001001, '/103/103001/103001001/', NULL, 0, '/', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281504353898496, 'oms-order-grolist-close', '关闭', 1, 102003001, '/102/102003/102003001/', NULL, 0, '/order/salSo/closeSalSo', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281536603901952, 'mg-inv-seq-export', '导出', 1, 103001001, '/103/103001/103001001/', NULL, 0, '/Inv/Serial/invSerialToexportW', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281544900235264, 'sup-org-list-stop', '停用', 1, 108002001, '/108/108002/108002001/', NULL, 0, '/org/orgBu/updateOrgBuStatus', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281738328952832, 'b2b-credit-submit', '提交', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/sal/receipt/batchSubmit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281791349149696, 'mg-inv-invb-query', '查询', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/invLot/searchCombine', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281874262151168, 'oms-order-db-edit', '编辑', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281919199924224, 'mg-inv-invb-edit', '修改', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446281931371794432, 'sup-org-ou-query', '查询', 1, 108003001, '/108/108003/108003001/', NULL, 0, '/org/orgOu/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282012477050880, 'sup-item-cate-query', '查询', 1, 106002001, '/106/106002/106002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282049667944448, 'mg-inv-invb-battra', '批次追踪', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282049961545728, 'b2b-credit-edit', '编辑', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282106987302912, 'sup-item-cate-cate-import', '品类导入', 1, 106002001, '/106/106002/106002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282144203362304, 'sup-org-ou-build', '新建', 1, 108003001, '/108/108003/108003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282176080072704, 'sup-item-cate-add-cate', '新增品类', 1, 106002001, '/106/106002/106002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282218987802624, 'sup-item-cate-add-child-cate', '新增子品类', 1, 106002001, '/106/106002/106002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282229100269568, 'sup-org-ou-edit', '编辑', 1, 108003001, '/108/108003/108003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282246208835584, 'mg-inv-invb-export', '导出', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/invLot/downloadCombine', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282275053064192, 'sup-item-cate-edit', '编辑', 1, 106002001, '/106/106002/106002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282365733916672, 'sup-item-cate-del', '删除', 1, 106002001, '/106/106002/106002001/', NULL, 0, '/itm/itmItemCate/del/{id}', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282421602045952, 'sup-org-ou-confirm', '确认', 1, 108003001, '/108/108003/108003001/', NULL, 0, '/org/orgOu/confirmOrgOu', 'PUT', NULL, NULL, NULL, NULL, 356948235909079040, '2022-04-08 17:32:30.407963', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282464887263232, 'sup-org-ou-stop', '停用', 1, 108003001, '/108/108003/108003001/', NULL, 0, '/org/orgOu/updateOrgBuStatus', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282473301037056, 'sup-item-cate-start', '启用', 1, 106002001, '/106/106002/106002001/', NULL, 0, '/itm/itmItemCate/switch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282545224962048, 'sup-item-cate-disabled', '禁用', 1, 106002001, '/106/106002/106002001/', NULL, 0, '/itm/itmItemCate/switch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282616658153472, 'oms-order-grolist-audit-pending', '暂挂', 1, 102003001, '/102/102003/102003001/', NULL, 0, '/order/salSoHold/artificialHold', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282796417634304, 'oms-order-grolist-export', '导出', 1, 102003001, '/102/102003/102003001/', NULL, 0, '/order/salSo/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282875727728640, 'sup-org-tree-query', '查询', 1, 108004001, '/108/108004/108004001/', NULL, 0, '/org/orgBuTree/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282903296888832, 'oms-order-sr-edit', '编辑', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282935370731520, 'sup-price-cate-query', '查询', 1, 107002004, '/107/107002/107002004/', NULL, 0, '/pri/priMainPrice/cateList', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446282955620831232, 'sup-org-tree-create', '新增', 1, 108004001, '/108/108004/108004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283007340793856, 'sup-org-tree-edit', '编辑', 1, 108004001, '/108/108004/108004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283096654303232, 'oms-order-gro-save', '保存', 1, 102003002, '/102/102003/102003002/', NULL, 0, '/order/salSo/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283134071689216, 'sup-item-attr-query', '查询', 1, 106002002, '/106/106002/106002002/', NULL, 0, '/itm/itmCateProp/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283141936009216, 'sup-price-cate-cateAlter', '品类毛利变更', 1, 107002004, '/107/107002/107002004/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283165231173632, 'mg-inv-purc-query', '查询', 1, 103003001, '/103/103003/103003001/', NULL, 0, '/pur/purGr/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283197451816960, 'sup-item-attr-create', '新增', 1, 106002002, '/106/106002/106002002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283215520878592, 'oms-order-gro-submit', '提交', 1, 102003002, '/102/102003/102003002/', NULL, 0, '/order/salSo/submit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283233933873152, 'sup-org-tree-confirm', '确认', 1, 108004001, '/108/108004/108004001/', NULL, 0, '/org/orgBuTree/updateStatus', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283239730401280, 'sup-item-attr-edit', '编辑', 1, 106002002, '/106/106002/106002002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283267932901376, 'mg-inv-purc-add', '新增', 1, 103003001, '/103/103003/103003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283277906956288, 'sup-org-tree-stop', '停用', 1, 108004001, '/108/108004/108004001/', NULL, 0, '/org/orgBuTree/updateStatus', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283327961780224, 'sup-item-attr-del', '删除', 1, 106002002, '/106/106002/106002002/', NULL, 0, '/itm/itmCateProp/{id}', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283346236362752, 'mg-inv-purc-edit', '修改', 1, 103003001, '/103/103003/103003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283378981294080, 'sup-price-audit-edit', '编辑', 1, 107003001, '/107/107003/107003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283483964723200, 'mg-inv-purc-cancel', '取消', 1, 103003001, '/103/103003/103003001/', NULL, 0, '/pur/purGr/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283563111239680, 'oms-order-sr-jc-add', '新增即场退货', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283609403772928, 'oms-order-gro-hand-alloc', '手工配货', 1, 102003002, '/102/102003/102003002/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283661891293184, 'mg-inv-purc-reccon', '确认收货', 1, 103003001, '/103/103003/103003001/', NULL, 0, '/pur/purGr/confirm/+', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283723413344256, 'sup-price-audit-cancelled', '作废申请单', 1, 107003001, '/107/107003/107003001/', NULL, 0, '/pri/priMainPriceAlter/priMainPriceAlterDelete/{id}', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283756237967360, 'oms-order-gro-auto-alloc', '自动配货', 1, 102003002, '/102/102003/102003002/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283756338630656, 'oms-order-sr-kc-add', '新增客仓退货', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283810554204160, 'mg-inv-purc-export', '导出', 1, 103003001, '/103/103003/103003001/', NULL, 0, '/pur/purGr/download', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283887565819904, 'oms-order-gro-add-purorder', '生成采购订单', 1, 102003002, '/102/102003/102003002/', NULL, 0, '/order/salSoAlloc/createPurPo', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446283923271929856, 'mg-inv-purc-printing', '打印', 1, 103003001, '/103/103003/103003001/', NULL, 0, '/pur/purGr/findIdOne/+', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446284322712276992, 'oms-order-gro-del-alloc', '删除配货', 1, 102003002, '/102/102003/102003002/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446284639977820160, 'sup-item-brand-query', '查询', 1, 106003001, '/106/106003/106003001/', NULL, 0, '/itm/brand/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446284763604930560, 'sup-item-brand-import', '导入', 1, 106003001, '/106/106003/106003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446284808949551104, 'sup-item-brand-create', '新增', 1, 106003001, '/106/106003/106003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446284846350159872, 'sup-item-brand-edit', '编辑', 1, 106003001, '/106/106003/106003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446284926197125120, 'sup-item-brand-start', '启用', 1, 106003001, '/106/106003/106003001/', NULL, 0, '/itm/brand/switch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446284960170987520, 'sup-item-brand-disabled', '禁用', 1, 106003001, '/106/106003/106003001/', NULL, 0, '/itm/brand/switch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446284999488393216, 'sup-price-item-export', '导出', 1, 107001001, '/107/107001/107001001/', NULL, 0, '/pri/priMainPriceExcel/itemPriceExport', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446285036037558272, 'sup-item-brand-del', '删除', 1, 106003001, '/106/106003/106003001/', NULL, 0, '/itm/brand/{id}', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446285198180962304, 'mg-inv-sup-query', '查询', 1, 103004001, '/103/103004/103004001/', NULL, 0, '/pur/purSs/search', 'POST', NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-26 15:17:47.870694', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446285311074848768, 'mg-inv-sup-add', '新增', 1, 103004001, '/103/103004/103004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446285342020423680, 'sup-org-addTree-add-node', '新增节点', 1, 108004002, '/108/108004/108004002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446285430495072256, 'mg-inv-sup-edit', '修改', 1, 103004001, '/103/103004/103004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446285545444167680, 'mg-inv-sup-cancel', '取消', 1, 103004001, '/103/103004/103004001/', NULL, 0, '/pur/purSs/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446285641946714112, 'mg-inv-sup-export', '导出', 1, 103004001, '/103/103004/103004001/', NULL, 0, '/pur/purSs/download', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446285914270289920, 'sup-org-addTree-del-node', '删除选中节点', 1, 108004002, '/108/108004/108004002/', NULL, 0, '/org/orgBuTree/deleteTreeDetail/{key}&{id}', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286024836337664, 'sup-item-list-query', '查询', 1, 106004001, '/106/106004/106004001/', NULL, 0, '/itm/item/spu/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286047745626112, 'sup-org-emp-query', '查询', 1, 108005001, '/108/108005/108005001/', NULL, 0, '/org/emp/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286108672086016, 'mg-pur-aap-query', '查询', 1, 104001004, '/104/104001/104001004/', NULL, 0, '/pur/purApp/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286124669161472, 'sup-org-emp-create', '新增', 1, 108005001, '/108/108005/108005001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286181741056000, 'sup-org-emp-edit', '编辑', 1, 108005001, '/108/108005/108005001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286275693465600, 'sup-item-emp-start', '启用', 1, 108005001, '/108/108005/108005001/', NULL, 0, '/org/emp/switchEmpSts', 'POST', NULL, NULL, NULL, NULL, 356948235909079040, '2021-11-01 09:51:54.675316', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286322648698880, 'mg-pur-aap-del', '删除', 1, 104001004, '/104/104001/104001004/', NULL, 0, '/pur/purApp/deleteBatch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286426625495040, 'mg-pur-aap-export', '导出', 1, 104001004, '/104/104001/104001004/', NULL, 0, '/pur/purApp/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286865664266240, 'sup-org-store-query', '查询', 1, 108006001, '/108/108006/108006001/', NULL, 0, '/org/orgStore/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286918382473216, 'oms-order-grolist-related-order', '相关发货单', 1, 102003001, '/102/102003/102003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446286996451053568, 'sup-org-store-create', '新增', 1, 108006001, '/108/108006/108006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287012020310016, 'mg-inv-invba-query', '查询', 1, 103005001, '/103/103005/103005001/', NULL, 0, '/invLot/searchCombine', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287014583029760, 'oms-order-grolist-pending-query', '暂挂查询', 1, 102003001, '/102/102003/102003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287039488806912, 'oms-order-salelist-related-order', '相关发货订单', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287073852739584, 'sup-org-store-edit', '编辑', 1, 108006001, '/108/108006/108006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287082925019136, 'mg-inv-invba-edit', '修改', 1, 103005001, '/103/103005/103005001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287117112791040, 'oms-order-salelist-pending-query', '暂挂查询', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287157789151232, 'sup-org-store-start', '启用', 1, 108006001, '/108/108006/108006001/', NULL, 0, '/org/orgStore/update', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287192723509248, 'mg-inv-invba-battra', '批次追踪', 1, 103005001, '/103/103005/103005001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287215838318592, 'sup-org-store-disabled', '禁用', 1, 108006001, '/108/108006/108006001/', NULL, 0, '/org/orgStore/update', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287607875719168, 'mg-inv-invba-export', '导出', 1, 103005001, '/103/103005/103005001/', NULL, 0, '/invLot/downloadCombine', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287797349715968, 'mg-inv-item-query', '查询', 1, 103006001, '/103/103006/103006001/', NULL, 0, '/pln/plnItemProp/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287871232380928, 'mg-inv-item-add', '新增', 1, 103006001, '/103/103006/103006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446287938542571520, 'mg-inv-iten-edit', '修改', 1, 103006001, '/103/103006/103006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446288499455234048, 'mg-inv-ass-query', '查询', 1, 103007001, '/103/103007/103007001/', NULL, 0, '/inv/invasmd/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446288608649744384, 'mg-inv-ass-add', '新增', 1, 103007001, '/103/103007/103007001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446288645089857536, 'sup-item-bom-query', '查询', 1, 106005001, '/106/106005/106005001/', NULL, 0, '/itm/bom/paging', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446288674366099456, 'mg-inv-ass-edit', '修改', 1, 103007001, '/103/103007/103007001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446288912795504640, 'mg-inv-ass-asscon', '组装确认', 1, 103007001, '/103/103007/103007001/', NULL, 0, '/inv/invasmd/confirm/', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446288973650661376, 'mg-inv-ass-audit', '审核', 1, 103007001, '/103/103007/103007001/', NULL, 0, '/inv/invasmd/check/', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289058534985728, 'mg-inv-ass-cancel', '取消', 1, 103007001, '/103/103007/103007001/', NULL, 0, '/inv/invasm/cancel', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289135261388800, 'mg-inv-ass-import', '导入', 1, 103007001, '/103/103007/103007001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289187732131840, 'mg-pur-acc-query', '查询', 1, 104001007, '/104/104001/104001007/', NULL, 0, '/pur/purPartsAmount/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289222121230336, 'mg-inv-ass-export', '导出', 1, 103007001, '/103/103007/103007001/', NULL, 0, '/inv/invasmd/downloadAsmAll', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289269739163648, 'b2b-credit-del', '删除', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/sal/receipt/batchDelete', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289363955814400, 'mg-inv-check-query', '查询', 1, 103008001, '/103/103008/103008001/', NULL, 0, '/invCk/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289429093355520, 'b2b-credit-rs', '红冲', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289503898767360, 'mg-inv-check-add', '新增', 1, 103008001, '/103/103008/103008001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289565764751360, 'mg-inv-check-audit', '审核', 1, 103008001, '/103/103008/103008001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289635545387008, 'mg-inv-check-edit', '修改', 1, 103008001, '/103/103008/103008001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289638238130176, 'b2b-credit-transfer', '押金转收款', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289753468243968, 'sup-item-bom-create', '新增', 1, 106005001, '/106/106005/106005001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289766885822464, 'b2b-credit-rv-order', '关联订单', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289798661869568, 'sup-item-bom-edit', '编辑', 1, 106005001, '/106/106005/106005001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289865519075328, 'b2b-credit-rv-return', '退押金', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289882782830592, 'sup-item-bom-del', '删除', 1, 106005001, '/106/106005/106005001/', NULL, 0, '/itm/bom/delete/{id}', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446289906967187456, 'mg-inv-check-cancel', '取消', 1, 103008001, '/103/103008/103008001/', NULL, 0, '/invCk/cancelInvCk/', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290026311913472, 'mg-inv-check-export', '导出', 1, 103008001, '/103/103008/103008001/', NULL, 0, '/invCk/exportInvCkList', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290056263438336, 'sup-item-bus-query', '查询', 1, 106006001, '/106/106006/106006001/', NULL, 0, '/itm/itmItemBusiness/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290156767350784, 'sup-item-bus-get-business', '获取经营目录', 1, 106006001, '/106/106006/106006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290202095194112, 'b2b-credit-audit-pass', '审批', 1, 114002008, '/114/114002/114002008/', NULL, 0, '/sal/receipt/check', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290225096757248, 'sup-item-bus-config-business', '配置经营目录', 1, 106006001, '/106/106006/106006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290267576668160, 'sup-item-bus-edit-business', '编辑经营目录', 1, 106006001, '/106/106006/106006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290336203870208, 'b2b-credit-audit-reject', '拒绝', 1, 114002008, '/114/114002/114002008/', NULL, 0, '/sal/receipt/check', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290578278125568, 'b2b-credit-detail-save', '保存', 1, 114002007, '/114/114002/114002007/', NULL, 0, '/sal/receipt/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290726110564352, 'b2b-credit-detail-submit', '提交', 1, 114002007, '/114/114002/114002007/', NULL, 0, '/sal/receipt/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290834306830336, 'b2b-credit-detail-order', '选择b端销售单', 1, 114002007, '/114/114002/114002007/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446290921254752256, 'b2b-credit-detail-check', '选择客户对账单', 1, 114002007, '/114/114002/114002007/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446291011453259776, 'b2b-credit-detail-del', '删除', 1, 114002007, '/114/114002/114002007/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446292875271933952, 'b2b-ma-add', '开票申请', 1, 114002009, '/114/114002/114002009/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446292990858563584, 'b2b-ma-query', '查询', 1, 114002009, '/114/114002/114002009/', NULL, 0, '/sal/inv/query', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446292994100760576, 'mg-inv-adj-query', '查询', 1, 103009001, '/103/103009/103009001/', NULL, 0, '/invajd/searchwithajid', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446293261932236800, 'b2b-ma-edit', '编辑', 1, 114002009, '/114/114002/114002009/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446293506191724544, 'b2b-ma-submit', '提交', 1, 114002009, '/114/114002/114002009/', NULL, 0, '/sal/inv/batchSubmit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446293795015692288, 'b2b-ma-audit-pass', '审批', 1, 114002012, '/114/114002/114002012/', NULL, 0, '/sal/inv/check', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446293988104671232, 'b2b-ma-audit-reject', '拒绝', 1, 114002012, '/114/114002/114002012/', NULL, 0, '/sal/inv/check', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446294221639323648, 'b2b-ma-detail-save', '保存', 1, 114002011, '/114/114002/114002011/', NULL, 0, '/sal/inv/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446294453806632960, 'b2b-ma-detail-submit', '提交', 1, 114002011, '/114/114002/114002011/', NULL, 0, '/sal/inv/submit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446294718442049536, 'b2b-ma-detail-order', '选择b端销售单', 1, 114002011, '/114/114002/114002011/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446294890689531904, 'b2b-ma-detail-check', '选择客户对账单', 1, 114002011, '/114/114002/114002011/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446294968443539456, 'b2b-ma-detail-reverseInvoice', '红冲申请', 1, 114002011, '/114/114002/114002011/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295040841420800, 'b2b-ma-detail-del', '删除', 1, 114002011, '/114/114002/114002011/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295412234457088, 'b2b-refund-add', '新增退款', 1, 114002013, '/114/114002/114002013/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295471432863744, 'b2b-refund-query', '查询', 1, 114002013, '/114/114002/114002013/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295541628735488, 'b2b-refund-edit', '编辑', 1, 114002013, '/114/114002/114002013/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295543990128640, 'mg-inv-adj-add', '新增', 1, 103009001, '/103/103009/103009001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295610742476800, 'mg-inv-adj-edit', '修改', 1, 103009001, '/103/103009/103009001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295614362161152, 'b2b-refund-del', '删除', 1, 114002013, '/114/114002/114002013/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295682519601152, 'mg-inv-adj-audit', '审核', 1, 103009001, '/103/103009/103009001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295774177726464, 'mg-inv-adj-cancel', '取消', 1, 103009001, '/103/103009/103009001/', NULL, 0, '/invaj/deleteBatch', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295889114238976, 'mg-pur-purpart-query', '查询', 1, 104001010, '/104/104001/104001010/', NULL, 0, '/pur/purPartsRatio/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295918080102400, 'mg-inv-adj-adjcon', '调整确认', 1, 103009001, '/103/103009/103009001/', NULL, 0, '/invaj/confirmInvAj', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446295981456035840, 'mg-pur-purpart-del', '删除', 1, 104001010, '/104/104001/104001010/', NULL, 0, '/pur/purPartsRatio/deleteBatch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446296028612595712, 'mg-inv-adj-export', '导出', 1, 103009001, '/103/103009/103009001/', NULL, 0, '/invajd/downloadWithAj', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446296177489416192, 'mg-inv-adj-printadjs', '打印调整单', 1, 103009001, '/103/103009/103009001/', NULL, 0, '/invaj/findOneInvAj/+', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446296453650780160, 'mg-inv-tra-query', '查询', 1, 103010001, '/103/103010/103010001/', NULL, 0, '/inv/invtrnd/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446296525599870976, 'mg-inv-tra-add', '新增', 1, 103010001, '/103/103010/103010001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446296583921668096, 'mg-inv-tra-edit', '修改', 1, 103010001, '/103/103010/103010001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446296670697623552, 'b2b-refund-audit-pass', '批准', 1, 114002015, '/114/114002/114002015/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446296695695675392, 'mg-inv-tra-tracon', '移库确认', 1, 103010001, '/103/103010/103010001/', NULL, 0, '/inv/invtrnd/confirm/+', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446296729841504256, 'b2b-refund-audit-reject', '拒绝', 1, 114002015, '/114/114002/114002015/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446296813723389952, 'mg-inv-tra-reccon', '收货确认', 1, 103010001, '/103/103010/103010001/', NULL, 0, '/inv/invtrnd/receiveConfirm/+', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446296898708377600, 'mg-inv-tra-audit', '审核', 1, 103010001, '/103/103010/103010001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297052043743232, 'mg-inv-tra-cancel', '取消', 1, 103010001, '/103/103010/103010001/', NULL, 0, '/inv/invtrn/cancel', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297139411095552, 'b2b-refund-detail-re-order', '选择退货订单', 1, 114002016, '/114/114002/114002016/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297150114959360, 'mg-inv-tra-export', '导出', 1, 103010001, '/103/103010/103010001/', NULL, 0, '/inv/invtrnd/downloadTrnAll', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297226379988992, 'b2b-refund-detail-submit', '提交', 1, 114002016, '/114/114002/114002016/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297283816787968, 'b2b-refund-detail-save', '保存', 1, 114002016, '/114/114002/114002016/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297290796109824, 'mg-inv-tra-printing', '打印', 1, 103010001, '/103/103010/103010001/', NULL, 0, '/inv/invtrn/detail/+', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297393418145792, 'b2b-checkfor-add', '创建对账单', 1, 114002001, '/114/114002/114002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297455644839936, 'mg-inv-sto-query', '查询', 1, 103011001, '/103/103011/103011001/', NULL, 0, '/inv/invStk/searchD', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297490927325184, 'b2b-checkfor-query', '查询', 1, 114002001, '/114/114002/114002001/', NULL, 0, '/sal/soa/query', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297506601439232, 'mg-pur-sup-query', '查询', 1, 104002001, '/104/104002/104002001/', NULL, 0, '/pur/purSupp/suppSearch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297569583108096, 'mg-inv-sto-export', '导出', 1, 103011001, '/103/103011/103011001/', NULL, 0, '/inv/invStk/searchD/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297607763857408, 'b2b-checkfor-edit', '编辑', 1, 114002001, '/114/114002/114002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297626030051328, 'mg-pur-sup-export', '导出', 1, 104002001, '/104/104002/104002001/', NULL, 0, '/pur/purSupp/exportSuppSearch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297666383450112, 'b2b-checkfor-cancellation', '作废', 1, 114002001, '/114/114002/114002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297812391366656, 'mg-pur-suprq-query', '查询', 1, 104002002, '/104/104002/104002002/', NULL, 0, '/pur/purSuppApply/suppApplySearch', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297838890979328, 'b2b-checkfor-detail-sm-order', '选择发货单', 1, 114002004, '/114/114002/114002004/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297853692678144, 'oms-order-grolist-view', '销售订单号链接', 1, 102003001, '/102/102003/102003001/', NULL, 0, '/order/salSo/orderDetail/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446297928795885568, 'b2b-checkfor-detail-save', '保存', 1, 114002004, '/114/114002/114002004/', NULL, 0, '/sal/soa/save', 'POST', NULL, NULL, NULL, NULL, 458664476239691776, '2021-08-23 19:44:46.907521', 0, NULL, NULL, 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446298033657679872, 'b2b-checkfor-detail-submit', '确认', 1, 114002004, '/114/114002/114002004/', NULL, 0, '/yst-sale/sal/soa/affirm/{id}', 'GET', NULL, NULL, NULL, NULL, 458664476239691776, '2021-08-23 19:45:07.610039', 0, NULL, NULL, 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446298115689877504, 'b2b-checkfor-detail-export', '打印对账单', 1, 114002004, '/114/114002/114002004/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446298130042785792, 'mg-inv-io-query', '查询', 1, 103011002, '/103/103011/103011002/', NULL, 0, '/inv/invIo/stkAcct', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446298250826158080, 'mg-inv-io-export', '导出', 1, 103011002, '/103/103011/103011002/', NULL, 0, '/inv/invIo/stkAcct/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446298457437573120, 'mg-inv-bat-export', '导出', 1, 103011003, '/103/103011/103011003/', NULL, 0, '/inv/invStk/searchInvLot/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446299016513130496, 'b2b-sales-basic-config-save', '保存', 1, 114001001, '/114/114001/114001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446299085769478144, 'b2b-sales-basic-config-add', '新增', 1, 114001001, '/114/114001/114001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446299151058014208, 'b2b-sales-basic-config-edit', '删除', 1, 114001001, '/114/114001/114001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446299407787167744, 'b2b-project-add', '项目信息录入', 1, 114003001, '/114/114003/114003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446300187961266176, 'mg-pur-suprq-cancelled', '作废申请单', 1, 104002002, '/104/104002/104002002/', NULL, 0, '/pur/purSuppApply/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446301228768567296, 'mg-pur-apply-query', '查询', 1, 104003001, '/104/104003/104003001/', NULL, 0, '/pur/purPr/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446301481878036480, 'mg-pur-apply-conver', '转正采购单', 1, 104003001, '/104/104003/104003001/', NULL, 0, '/pur/purPr/transferPurPo', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446301615374344192, 'mg-pur-apply-cancel', '取消', 1, 104003001, '/104/104003/104003001/', NULL, 0, '/pur/purPr/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446301752884600832, 'mg-pur-apply-export', '导出', 1, 104003001, '/104/104003/104003001/', NULL, 0, '/pur/purPr/downloadPr', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324024282324992, 'b2b-project-edit', '编辑', 1, 114003001, '/114/114003/114003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324186631249920, 'b2b-project-del', '删除', 1, 114003001, '/114/114003/114003001/', NULL, 0, '/sale/proj/del', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324329178865664, 'b2b-proj-detail-save', '保存', 1, 114003003, '/114/114003/114003003/', NULL, 0, '/proj/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324410514808832, 'b2b-proj-detail-submit', '提交', 1, 114003003, '/114/114003/114003003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324477497843712, 'b2b-proj-detail-audit-pass', '批准', 1, 114003003, '/114/114003/114003003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324535576371200, 'b2b-proj-detail-audit-reject', '拒绝', 1, 114003003, '/114/114003/114003003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324637594427392, 'b2b-contract-add', '新建合同', 1, 114003005, '/114/114003/114003005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324706771083264, 'b2b-contract-edit', '编辑', 1, 114003005, '/114/114003/114003005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324816850591744, 'b2b-contract-del', '删除', 1, 114003005, '/114/114003/114003005/', NULL, 0, '/proj/contract/del', 'POST', NULL, NULL, NULL, NULL, 356948235909079040, '2021-07-25 14:23:02.000000', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324907057487872, 'b2b-contract-copy', '复制合同', 1, 114003005, '/114/114003/114003005/', NULL, 0, '/proj/contract/copy/{id}', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446324963659620352, 'sup-price-item-master-priceAlter', '主挡售价变更', 1, 107001001, '/107/107001/107001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446325334645809152, 'b2b-accept-add', '新增', 1, 114003006, '/114/114003/114003006/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446325421522427904, 'b2b-accept-edit', '编辑', 1, 114003006, '/114/114003/114003006/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446325508331937792, 'b2b-accept-del', '删除', 1, 114003006, '/114/114003/114003006/', NULL, 0, '/acceptance/delete/{id}', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446325592641642496, 'b2b-accept-submit', '提交', 1, 114003006, '/114/114003/114003006/', NULL, 0, '/acceptance/submitOne/{id}', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446326047492939776, 'b2b-contr-detail-save', '保存', 1, 114003011, '/114/114003/114003011/', NULL, 0, '/proj/contract/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446326136168914944, 'b2b-contr-detail-submit', '提交', 1, 114003011, '/114/114003/114003011/', NULL, 0, '/proj/contract/submit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446326211477643264, 'b2b-contr-detail-audit-pass', '批准', 1, 114003011, '/114/114003/114003011/', NULL, 0, '/proj/contract/appr', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446326295627964416, 'b2b-contr-detail-audit-reject', '拒绝', 1, 114003011, '/114/114003/114003011/', NULL, 0, '/proj/contract/appr', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446326611853320192, 'b2b-accept-detail-save', '保存', 1, 114003008, '/114/114003/114003008/', NULL, 0, '/acceptance/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446326693021491200, 'b2b-accept-detail-submit', '提交', 1, 114003008, '/114/114003/114003008/', NULL, 0, '/acceptance/submit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446326772398694400, 'b2b-accept-detail-pass', '批准', 1, 114003008, '/114/114003/114003008/', NULL, 0, '/acceptance/appr/{id}/{apprStatus}', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446326853403287552, 'b2b-accept-detail-reject', '拒绝', 1, 114003008, '/114/114003/114003008/', NULL, 0, '/acceptance/appr/{id}/{apprStatus}', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446327308791455744, 'b2b-price-base-add', '增加对外基础价', 1, 113003001, '/113/113003/113003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446327678322221056, 'b2b-price-query', '查询', 1, 113003001, '/113/113003/113003001/', NULL, 0, '/yst-sale/pri/sale/price/query', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446327753261850624, 'b2b-price-cust-add', '增加按客户的价格', 1, 113003001, '/113/113003/113003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446327867955093504, 'b2b-price-cust-group-add', '增加按客户等级的价格', 1, 113003001, '/113/113003/113003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446327949605609472, 'b2b-price-lnt-add', '增加内部结算的价格', 1, 113003001, '/113/113003/113003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446328096888594432, 'b2b-price-base-edit-save', '保存', 1, 113003004, '/113/113003/113003004/', NULL, 0, '/pri/sale/alter/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446328190325104640, 'b2b-price-base-edit-submit', '提交', 1, 113003004, '/113/113003/113003004/', NULL, 0, '/pri/sale/alter/submit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446328254665728000, 'b2b-price-base-edit-add', '新增', 1, 113003004, '/113/113003/113003004/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446328343396229120, 'b2b-price-base-edit-del', '删除', 1, 113003004, '/113/113003/113003004/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446328409200664576, 'b2b-price-base-edit-export', '导入价格', 1, 113003004, '/113/113003/113003004/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446328674528141312, 'b2b-price-cust-group-edit-save', '保存(del)', 1, 113003002, '/113/113003/113003002/', NULL, 0, '/pri/sale/alter/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446328764768591872, 'b2b-price-cust-group-edit-submit', '提交(del)', 1, 113003002, '/113/113003/113003002/', NULL, 0, '/pri/sale/alter/submit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446328832582098944, 'b2b-price-cust-group-edit-add', '新增(del)', 1, 113003002, '/113/113003/113003002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446328906921943040, 'b2b-price-cust-group-edit-del', '删除(del)', 1, 113003002, '/113/113003/113003002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446328965264711680, 'b2b-price-cust-group-edit-export', '导入价格(del)', 1, 113003002, '/113/113003/113003002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446329092926742528, 'b2b-price-lnt-edit-save', '提交', 1, 113003005, '/113/113003/113003005/', NULL, 0, '/pri/sale/alter/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446329175982350336, 'b2b-price-lnt-edit-submit', '提交', 1, 113003005, '/113/113003/113003005/', NULL, 0, '/pri/sale/alter/submit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446329238360039424, 'b2b-price-lnt-edit-add', '新增', 1, 113003005, '/113/113003/113003005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446329302440615936, 'b2b-price-lnt-edit-del', '删除', 1, 113003005, '/113/113003/113003005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446329356417114112, 'b2b-price-lnt-edit-export', '导入价格', 1, 113003005, '/113/113003/113003005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446329518006870016, 'b2b-projectSale-depositQuery', '支付押金查询', 0, 114003, '/114/114003/', NULL, 14, '/shell/projectSale/depositQuery', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446329521580417024, 'b2b-price-cust-edit-save', '保存', 1, 113003002, '/113/113003/113003002/', NULL, 0, '/pri/sale/alter/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446330112155197440, 'mg-pur-cont-query', '查询', 1, 104004001, '/104/104004/104004001/', NULL, 0, '/pur/purPc/q', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446330128911441920, 'b2b-price-cust-edit-submit', '提交', 1, 113003002, '/113/113003/113003002/', NULL, 0, '/pri/sale/alter/submit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446330208645160960, 'b2b-price-cust-edit-add', '新增', 1, 113003002, '/113/113003/113003002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446330242371559424, 'mg-pur-cont-del', '删除', 1, 104004001, '/104/104004/104004001/', NULL, 0, '/pur/purPc/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446330373523251200, 'b2b-price-cust-edit-del', '删除', 1, 113003002, '/113/113003/113003002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446330374919954432, 'mg-pur-cont-export', '导出', 1, 104004001, '/104/104004/104004001/', NULL, 0, '/pur/purPc/downloadPc', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446330451667329024, 'b2b-price-cust-edit-export', '导入价格', 1, 113003002, '/113/113003/113003002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446331185587523584, 'b2b-price-audit-pass', '审核通过', 1, 113003007, '/113/113003/113003007/', NULL, 0, '/pri/sale/alter/approve', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446331284287885312, 'b2b-price-audit-reject', '审核拒绝', 1, 113003007, '/113/113003/113003007/', NULL, 0, '/pri/sale/alter/approve', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446332276962201600, 'b2b-proCust-edit', '编辑', 1, 113002001, '/113/113002/113002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446332342024245248, 'b2b-proCust-add', '添加', 1, 113002001, '/113/113002/113002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446332409707728896, 'b2b-proCust-change', '转正式客户', 1, 113002001, '/113/113002/113002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446332503723053056, 'b2b-proCust-assign', '批量分配业务员', 1, 113002001, '/113/113002/113002001/', NULL, 0, '/crm/scust/empAssign', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446332593888006144, 'b2b-proCust-search', '查询', 1, 113002001, '/113/113002/113002001/', NULL, 0, '/crm/scust/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446332709189423104, 'b2b-proCust-detail-save', '保存', 1, 113002003, '/113/113002/113002003/', NULL, 0, '/crm/scust/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446332731964493824, 'sup-price-mView-audit', '审核', 1, 107001003, '/107/107001/107001003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446332876340826112, 'sup-price-cView-audit', '审核', 1, 107002002, '/107/107002/107002002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446337692823687168, 'mg-pur-re-query', '查询', 1, 104005001, '/104/104005/104005001/', NULL, 0, '/pur/purRns/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446337821416853504, 'mg-pur-re-return-over', '退货完成', 1, 104005001, '/104/104005/104005001/', NULL, 0, '/pur/purRns/recpComplete', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446337929726365696, 'mg-pur-re-cancel', '取消', 1, 104005001, '/104/104005/104005001/', NULL, 0, '/pur/purRns/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446338044146978816, 'mg-pur-re-audit', '审核', 1, 104005001, '/104/104005/104005001/', NULL, 0, '/pur/purRns/approveBatch', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446339523821932544, 'mg-pur-rma-query', '查询', 1, 104005005, '/104/104005/104005005/', NULL, 0, '/pur/rma/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446339621821845504, 'mg-pur-rma-cancel', '取消', 1, 104005005, '/104/104005/104005005/', NULL, 0, '/pur/rma/deleteInBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446339860398051328, 'mg-pur-rma-audit-pass', '审批通过', 1, 104005005, '/104/104005/104005005/', NULL, 0, '/pur/rma/approveBatch', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446339984201322496, 'mg-pur-rma-export', '导出', 1, 104005005, '/104/104005/104005005/', NULL, 0, '/pur/rma/downloadRma', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446342388065996800, 'mg-pur-order-query', '查询', 1, 104006001, '/104/104006/104006001/', NULL, 0, '/pur/purPo/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446342515472175104, 'mg-pur-order-cancel', '取消', 1, 104006001, '/104/104006/104006001/', NULL, 0, '/pur/purPo/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446342681314955264, 'mg-pur-order-export', '导出', 1, 104006001, '/104/104006/104006001/', NULL, 0, '/pur/purPo/downloadAllData', 'POST', NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-12 20:12:01.114620', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446342863398080512, 'mg-pur-sub-query', '查询', 1, 104006005, '/104/104006/104006005/', NULL, 0, '/pur/dropShipLog/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446342971564986368, 'mg-pur-sub-export', '导出', 1, 104006005, '/104/104006/104006005/', NULL, 0, '/pur/purMoq/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446346498202853376, 'mg-pur-scene-query', '查询', 1, 104006006, '/104/104006/104006006/', NULL, 0, '/pur/purscene/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446346589147947008, 'mg-pur-scene-del', '删除', 1, 104006006, '/104/104006/104006006/', NULL, 0, '/pur/purscene/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446371546275962880, 'mg-lts-mainten-query', '查询', 1, 105001001, '/105/105001/105001001/', NULL, 0, '/tms/ou/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446371657873809408, 'mg-lts-mainten-add', '新增', 1, 105001001, '/105/105001/105001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446371724944924672, 'mg-lts-mainten-edit', '修改', 1, 105001001, '/105/105001/105001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446371797376360448, 'mg-lts-mainten-stop', '停用', 1, 105001001, '/105/105001/105001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446371967803514880, 'mg-lts-mainten-start', '启用', 1, 105001001, '/105/105001/105001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446372169801195520, 'mg-lts-info-query', '查询', 1, 105001002, '/105/105001/105001002/', NULL, 0, '/tms/logisticsInfo/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446372284439912448, '/tms/logisticsInfo/export', '导出', 1, 105001002, '/105/105001/105001002/', NULL, 0, 'mg-lts-info-export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446372676049494016, 'mg-lts-recon-query', '查询', 1, 105002001, '/105/105002/105002001/', NULL, 0, '/tms/accountCheck/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446372738108416000, 'mg-lts-recon-import', '导入', 1, 105002001, '/105/105002/105002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446372843733573632, 'mg-lts-recon-del', '删除', 1, 105002001, '/105/105002/105002001/', NULL, 0, '/tms/accountCheck/updateDeleteFlagBatch', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446372965573910528, 'mg-lts-recon-audit', '审核', 1, 105002001, '/105/105002/105002001/', NULL, 0, '/tms/accountCheck/audit', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446373101590994944, 'mg-lts-recon-close-account', '结算', 1, 105002001, '/105/105002/105002001/', NULL, 0, '/tms/accountCheck/balance', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446373298631008256, 'mg-lts-recon-expoprt', '导出', 1, 105002001, '/105/105002/105002001/', NULL, 0, '/tms/accountCheck/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446374744202076160, 'b2b-depositpay-add', '新增', 1, 446329518006870016, '/114/114003/446329518006870016/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446374827022802944, 'b2b-depositpay-edit', '编辑', 1, 446329518006870016, '/114/114003/446329518006870016/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446374886611279872, 'b2b-depositpay-reapply', '退押金申请', 1, 446329518006870016, '/114/114003/446329518006870016/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446374894215553024, 'mg-pur-logis-query', '查询', 1, 104006009, '/104/104006/104006009/', NULL, 0, '/tms/tmsDocTrace/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375007780528128, 'mg-pur-logis-del', '删除', 1, 104006009, '/104/104006/104006009/', NULL, 0, '/tms/tmsDocTrace/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375067754881024, 'b2b-cust-add', '新增', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375108380909568, 'mg-pur-logis-export', '导出', 1, 104006009, '/104/104006/104006009/', NULL, 0, '/tms/tmsDocTrace/download', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375140060487680, 'b2b-cust-edit', '编辑', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375209987923968, 'b2b-cust-addr', '地址批量上传', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375212533866496, 'mg-pur-logis-add', '新增', 1, 104006009, '/104/104006/104006009/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375271015047168, 'mg-pur-logis-edit', '编辑', 1, 104006009, '/104/104006/104006009/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375287045677056, 'b2b-cust-info', '客户批量上传', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375412442783744, 'b2b-cust-assign', '批量分配业务员', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/crm/cust/empAssign', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375733432868864, 'b2b-cust-company', '拓展客户所属公司', 1, 113001002, '/113/113001/113001002/', NULL, 0, '/crm/custOu/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375735609712640, 'mg-lts-info-export', '导出', 1, 105001002, '/105/105001/105001002/', NULL, 0, '/tms/logisticsInfo/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446375834033250304, 'b2b-cust-search', '查询', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/crm/cust/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376144625655808, 'b2b-bid-print', '打印报价单', 1, 113004001, '/113/113004/113004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376221058457600, 'b2b-bid-add', '创建报价单', 1, 113004001, '/113/113004/113004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376284950290432, 'b2b-bid-edit', '编辑', 1, 113004001, '/113/113004/113004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376349936836608, 'fin-pur-wp-query', '查询', 1, 112005001, '/112/112005/112005001/', NULL, 0, '/fin/wdmApply/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376350792474624, 'b2b-bid-change', '生成销售单', 1, 113004001, '/113/113004/113004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376415611248640, 'b2b-bid-switch', '生成销售合同', 1, 113004001, '/113/113004/113004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376492878716928, 'fin-pur-sf-query', '查询', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/fin/purSettleDef/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376500239720448, 'b2b-bid-search', '查询', 1, 113004001, '/113/113004/113004001/', NULL, 0, '/sal/quotation/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376554799226880, 'fin-pur-wp-add', '添加', 1, 112005001, '/112/112005/112005001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376643177406464, 'b2b-bid--detail-save', '保存', 1, 113004003, '/113/113004/113004003/', NULL, 0, '/sal/quotation/createSalQuotation', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376730888691712, 'b2b-bid--detail-submit', '提交', 1, 113004003, '/113/113004/113004003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376832692838400, 'b2b-bid-detail-pass', '批准', 1, 113004003, '/113/113004/113004003/', NULL, 0, '/sal/quotation/approve/{id}/{status}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446376950275956736, 'b2b-bid-detail-reject', '拒绝', 1, 113004003, '/113/113004/113004003/', NULL, 0, '/sal/quotation/approve/{id}/{status}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446377106429894656, 'b2b-bid-detail-del', '删除', 1, 113004003, '/113/113004/113004003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446377134133272576, 'mg-pur-price-query', '查询', 1, 104007001, '/104/104007/104007001/', NULL, 0, '/pur/purPurcPrice/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446377231919276032, 'mg-pur-price-export', '导出', 1, 104007001, '/104/104007/104007001/', NULL, 0, '/pur/purPurcPrice/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446377353734447104, 'fin-pur-wp-edit', '修改', 1, 112005001, '/112/112005/112005001/', NULL, 0, '/fin/wdmApply/query/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446377674523205632, 'fin-pur-wp-audit-pass', '审核通过', 1, 112005001, '/112/112005/112005001/', NULL, 0, '/fin/wdmApply/approved', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446377826264735744, 'fin-pur-wp-audit-reject', '审核拒绝', 1, 112005001, '/112/112005/112005001/', NULL, 0, '/fin/wdmApply/reject', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446377915246895104, 'fin-pur-sf-add', '新增', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446377981525286912, 'fin-pur-wp-re', '批量复核', 1, 112005001, '/112/112005/112005001/', NULL, 0, '/fin/wdmApply/review', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446378058914390016, 'fin-pur-sf-del', '删除', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/fin/purSettleDef/delete/{id}', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446378101226528768, 'fin-pur-wp-id-todetail', '单号跳转详情', 1, 112005001, '/112/112005/112005001/', NULL, 0, '/fin/wdmApply/query/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446378268193382400, 'fin-pur-sf-edit', '编辑', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/fin/purSettleDef/query/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446378418856976384, 'fin-pur-wp-reAudit-pass', '复核通过', 1, 112005002, '/112/112005/112005002/', NULL, 0, '/fin/wdmApply/review', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446378576919322624, 'fin-pur-sf-successEdit', '保存', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/fin/purSettleDef/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446379136137486336, 'mg-pur-bill-query', '查询', 1, 104008001, '/104/104008/104008001/', NULL, 0, '/pur/accountCheck/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446379277967876096, 'mg-pur-bill-cancelled', '作废', 1, 104008001, '/104/104008/104008001/', NULL, 0, '/pur/accountCheck/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446379426811142144, 'fin-pur-sf-choose-add', '分配公司', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/fin/purSettleDef/scene/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446379494016475136, 'fin-pur-wp-audit-passs', '审核通过', 1, 112005002, '/112/112005/112005002/', NULL, 0, '/fin/wdmApply/approved', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446379790272749568, 'fin-pur-sf-choose-company', '保存', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/fin/purSettleDef/addEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446379960867676160, 'fin-pur-wp-audit-rejectt', '审核拒绝', 1, 112005002, '/112/112005/112005002/', NULL, 0, '/fin/wdmApply/reject', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380068552237056, 'mg-pur-bill-audit', '审核', 1, 104008001, '/104/104008/104008001/', NULL, 0, '/pur/accountCheck/approveBatch', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380186080829440, 'fin-pur-tf-add', '新增', 1, 112005003, '/112/112005/112005003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380201721389056, 'mg-pur-bill-add', '新增', 1, 104008001, '/104/104008/104008001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380237054205952, 'fin-pur-sf-cancel-query', '取消分配', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/fin/purSettleDef/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380264774361088, 'mg-pur-bill-edit', '编辑', 1, 104008001, '/104/104008/104008001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380291445940224, 'fin-pur-tf-del', '删除', 1, 112005003, '/112/112005/112005003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380349499301888, 'mg-pur-bill-make-invoice', '开票', 1, 104008001, '/104/104008/104008001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380389710094336, 'b2b-price-cg-edit-save', '保存', 1, 113003003, '/113/113003/113003003/', NULL, 0, '/pri/sale/alter/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380389986918400, 'fin-pur-sf-cancel-company', '保存', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/fin/purSettleDef/cancelEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380477979222016, 'b2b-price-cg-edit-submit', '提交', 1, 113003003, '/113/113003/113003003/', NULL, 0, '/pri/sale/alter/submit', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380490864123904, 'fin-pur-sf-start', '启用', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/fin/purSettleDef/enable', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380497788919808, 'mg-pur-bill-export', '导出', 1, 104008001, '/104/104008/104008001/', NULL, 0, '/yst-pur/pur/accountCheck/downloadAllData', 'POST', NULL, NULL, NULL, NULL, 356948235909079040, '2021-10-11 13:17:29.982763', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380552440700928, 'b2b-price-cg-edit-add', '新增', 1, 113003003, '/113/113003/113003003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380590118133760, 'fin-pur-sf-stop', '停用', 1, 112001001, '/112/112001/112001001/', NULL, 0, '/fin/purSettleDef/stop', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380623790006272, 'b2b-price-cg-edit-del', '删除', 1, 113003003, '/113/113003/113003003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380688273235968, 'b2b-price-cg-edit-export', '导入价格', 1, 113003003, '/113/113003/113003003/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446380886751895552, 'fin-pur-tf-downtemp', '模板下载', 1, 112005003, '/112/112005/112005003/', NULL, 0, '/yst-fin/fin/wdmApply/template', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381046441631744, 'fin-pur-tf-import', '导入', 1, 112005003, '/112/112005/112005003/', NULL, 0, '/yst-fin/fin/wdmApply/import', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381189446426624, 'fin-pur-tf-save', '保存', 1, 112005003, '/112/112005/112005003/', NULL, 0, '/fin/wdmApply/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381316844216320, 'fin-pur-set-query', '查询', 1, 112001003, '/112/112001/112001003/', NULL, 0, '/fin/purSettle/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381404337397760, 'fin-pur-set-audit-pass', '审核通过', 1, 112001003, '/112/112001/112001003/', NULL, 0, '/fin/purSettle/approved', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381479805509632, 'fin-pur-set-audit-reject', '审核拒绝', 1, 112001003, '/112/112001/112001003/', NULL, 0, '/fin/purSettle/rejected', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381591671791616, 'mg-pur-forinv-query', '查询', 1, 104008005, '/104/104008/104008005/', NULL, 0, '/pur/invItem/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381640313135104, 'fin-pur-set-audit-query', '生成付款单', 1, 112001003, '/112/112001/112001003/', NULL, 0, '/fin/purSettle/canPay/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381758621868032, 'fin-pur-set-canPay', ' 保存', 1, 112001003, '/112/112001/112001003/', NULL, 0, '/fin/purSettle/createPre', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381826531844096, 'mg-pur-forinv-detial', '形式发票详情', 1, 104008005, '/104/104008/104008005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381838233952256, 'fin-pur-set-export', '导出', 1, 112001003, '/112/112001/112001003/', NULL, 0, '/fin/purSettle/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446381988931100672, 'fin-pur-tf-add', '新增', 1, 112005004, '/112/112005/112005004/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-20 16:24:29.449166', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446382132149805056, 'fin-pur-tf-del', '删除', 1, 112005004, '/112/112005/112005004/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-20 16:24:47.188872', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446382222671273984, 'fin-pur-set-view', '采购结算单号跳转详情', 1, 112001003, '/112/112001/112001003/', NULL, 0, '/fin/purSettle/query/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446382286370168832, 'fin-pur-tf-downtemp', '模板下载', 1, 112005004, '/112/112005/112005004/', NULL, 0, '/yst-fin/fin/wdmApply/template', 'POST', NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-20 16:24:56.706740', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446382400539123712, 'fin-pur-tf-import', '导入', 1, 112005004, '/112/112005/112005004/', NULL, 0, '/yst-fin/fin/wdmApply/import', 'POST', NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-20 16:25:05.486569', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446382533058158592, 'fin-pur-tf-save', '保存', 1, 112005004, '/112/112005/112005004/', NULL, 0, '/fin/wdmApply/save', 'POST', NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-20 16:25:17.933995', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446382959908282368, 'fin-pur-re-re-query', '查询收款单', 1, 112004001, '/112/112004/112004001/', NULL, 0, '/sal/receiveSettle/listDtl', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446383085380886528, 'fin-pur-re-fl-query', '查询银行流水', 1, 112004001, '/112/112004/112004001/', NULL, 0, '/fin/billFlow/queryByBlowNos', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446383598491066368, 'fin-pur-re-vt-confirm', '自动对账', 1, 112004001, '/112/112004/112004001/', NULL, 0, '/sal/receiveSettle/checkAutomatic', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446383733941919744, 'mg-pur-form-query', '查询', 1, 104008008, '/104/104008/104008008/', NULL, 0, '/pur/inv/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446383744675143680, 'fin-pur-re-choose-confirm', '手动对账', 1, 112004001, '/112/112004/112004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-31 16:03:36.533387', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446383859980754944, 'mg-pur-form-audit', '审批', 1, 104008008, '/104/104008/104008008/', NULL, 0, '/pur/inv/approveBatch', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446383959197016064, 'mg-pur-form-edit', '编辑', 1, 104008008, '/104/104008/104008008/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446384069477851136, 'fin-pur-re-cancel-confirm', '撤销对账', 1, 112004001, '/112/112004/112004001/', NULL, 0, '/sal/receiveSettle/bolt', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446384231168270336, 'fin-pur-sxf-query', '查询', 1, 112004002, '/112/112004/112004002/', NULL, 0, '/fin/workCharges/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446384373506170880, 'fin-pur-sxf-downtemp', '模板下载', 1, 112004002, '/112/112004/112004002/', NULL, 0, '/fin/workCharges/downloadTemplate', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446384509611335680, 'fin-pur-sxf-import', '导入', 1, 112004002, '/112/112004/112004002/', NULL, 0, '/fin/workCharges/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446384633888563200, 'fin-pur-sxf-del', '删除', 1, 112004002, '/112/112004/112004002/', NULL, 0, '/fin/workCharges/delete', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446384749714268160, 'fin-pur-sxf-confirm', '确认', 1, 112004002, '/112/112004/112004002/', NULL, 0, '/fin/workCharges/pass', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446386429876953088, 'mg-pur-apa-query', '查询', 1, 104008011, '/104/104008/104008011/', NULL, 0, '/pur/purPa/search', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446386510311120896, 'mg-pur-apa-cancel', '取消', 1, 104008011, '/104/104008/104008011/', NULL, 0, '/pur/purPa/deleteBatch', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446386638971396096, 'mg-pur-apa-audit-pass', '审核', 1, 104008011, '/104/104008/104008011/', NULL, 0, '/pur/purPa/approveBatch', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446386900901486592, 'mg-pur-apa-edit', '编辑', 1, 104008011, '/104/104008/104008011/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446386952864718848, 'mg-pur-apa-add', '新增', 1, 104008011, '/104/104008/104008011/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446387215193268224, 'fin-pur-df-query', '查询', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/fin/salSettleDef/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446387406696800256, 'fin-pur-cf-scene', '采购场景', 1, 112001002, '/112/112001/112001002/', NULL, 0, '/fin/purSettleDef/query/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446387616340697088, 'fin-pur-cf-successQuery', '查询', 1, 112001002, '/112/112001/112001002/', NULL, 0, '/fin/purSettleDef/listScene', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446387699908009984, 'fin-pur-cf-sceneSave', '保存', 1, 112001002, '/112/112001/112001002/', NULL, 0, '/fin/purSettleDef/addScene', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446387784414846976, 'fin-pur-df-add', '添加', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446387806845984768, 'fin-pur-cf-corp', '查看公司', 1, 112001007, '/112/112001/112001007/', NULL, 0, '/fin/purSettleDef/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446387996969590784, 'fin-pur-df-edit', '修改', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/fin/salSettleDef/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446388106864549888, 'fin-pur-df-save', '保存', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/fin/salSettleDef/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446388196979171328, 'fin-pur-df-del', '删除', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/fin/salSettleDef/delete', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446388433277870080, 'fin-pur-df-cancel-company', '取消分配', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/fin/salSettleDef/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446388533689507840, 'fin-pur-df-choose-company-sure', '分配公司确定', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/fin/salSettleDef/addEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446388626333294592, 'fin-pur-df-cancel-company-sure', '取消分配确定', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/fin/salSettleDef/cancelEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446388798975041536, 'fin-pur-df-start', '启用', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/fin/salSettleDef/enable', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446388883481878528, 'fin-pur-df-stop', '停用', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/fin/salSettleDef/disable', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446388961068113920, 'fin-pur-df-corp', '查看公司', 1, 112002001, '/112/112002/112002001/', NULL, 0, '/fin/salSettleDef/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389024502767616, 'fin-pur-setI-audit-pass', '审核通过', 1, 112001004, '/112/112001/112001004/', NULL, 0, '/fin/purSettle/approved', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389138868854784, 'mg-pur-order-add', '新增', 1, 104006001, '/104/104006/104006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389147681087488, 'fin-pur-setI-audit-reject', '审核拒绝', 1, 112001004, '/112/112001/112001004/', NULL, 0, '/fin/purSettle/rejected', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389196737667072, 'mg-pur-order-edit', '编辑', 1, 104006001, '/104/104006/104006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389276257476608, 'mg-pur-order-order-over', '订单完成', 1, 104006001, '/104/104006/104006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389364165894144, 'mg-pur-order-view-pur', '查看采购申请', 1, 104006001, '/104/104006/104006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389378539773952, 'fin-pur-pf-query', '查询', 1, 112001005, '/112/112001/112001005/', NULL, 0, '/fin/purPreDef/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389560274771968, 'fin-pur-df-corp-query', '销售结算单类型定义查看公司', 1, 112002002, '/112/112002/112002002/', NULL, 0, '/fin/salSettleDef/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389566952103936, 'fin-pur-pf-add', '新增', 1, 112001005, '/112/112001/112001005/', NULL, 0, '/', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389676612182016, 'fin-pur-pf-succesEdit', '保存', 1, 112001005, '/112/112001/112001005/', NULL, 0, '/fin/purPreDef/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389689799073792, 'mg-pur-order-view-receipt', '查看收货登记', 1, 104006001, '/104/104006/104006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389755565760512, 'fin-pur-inc-corp-query', '收款单类型定义查看公司', 1, 112002002, '/112/112002/112002002/', NULL, 0, '/sal/salReceiveDefine/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389762754797568, 'mg-pur-order-printing', '打印', 1, 104006001, '/104/104006/104006001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389763186810880, 'fin-pur-pf-del', '删除', 1, 112001005, '/112/112001/112001005/', NULL, 0, '/fin/purPreDef/delete/{id}', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389863699111936, 'fin-pur-pf-edit', '编辑', 1, 112001005, '/112/112001/112001005/', NULL, 0, '/fin/purPreDef/query/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389893969403904, 'fin-pur-sl-query', '查询', 1, 112002003, '/112/112002/112002003/', NULL, 0, '/fin/salSettle/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389982628601856, 'mg-pur-scene-add', '新增', 1, 104006006, '/104/104006/104006006/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446389993047252992, 'fin-pur-sl-audit-pass', '审核通过', 1, 112002003, '/112/112002/112002003/', NULL, 0, '/fin/salSettle/approved', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390012089393152, 'mg-pur-scene-edit', '编辑', 1, 104006006, '/104/104006/104006006/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390074936844288, 'fin-pur-sl-audit-reject', '审核拒绝', 1, 112002003, '/112/112002/112002003/', NULL, 0, '/fin/salSettle/rejected', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390161666662400, 'fin-pur-sl-export', '导出', 1, 112002003, '/112/112002/112002003/', NULL, 0, '/fin/salSettle/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390175012937728, 'mg-pur-re-add', '新增', 1, 104005001, '/104/104005/104005001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390234412670976, 'fin-pur-sl-id-todetail', '单号跳转详情', 1, 112002003, '/112/112002/112002003/', NULL, 0, '/fin/salSettle/query/{id}', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390247100440576, 'mg-pur-re-edit', '编辑', 1, 104005001, '/104/104005/104005001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390354944385024, 'fin-pur-pf-choose-company', '确定', 1, 112001005, '/112/112001/112001005/', NULL, 0, '/fin/purPreDef/addEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390371788709888, 'mg-pur-rma-add', '新增', 1, 104005005, '/104/104005/104005005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390423915520000, 'mg-pur-rma-edit', '编辑', 1, 104005005, '/104/104005/104005005/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390454177423360, 'fin-pur-sl-audit-detail-pass', '审核通过', 1, 112002004, '/112/112002/112002004/', NULL, 0, '/fin/salSettle/approved', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390462851244032, 'fin-pur-pf-cancel-query', '取消分配', 1, 112001005, '/112/112001/112001005/', NULL, 0, '/fin/purPreDef/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390531826573312, 'fin-pur-sl-audit-detail-reject', '审核拒绝', 1, 112002004, '/112/112002/112002004/', NULL, 0, '/fin/salSettle/rejected', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390538537459712, 'fin-pur-pf-cancel-company', '确定', 1, 112001005, '/112/112001/112001005/', NULL, 0, '/fin/purPreDef/cancelEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390626861113344, 'fin-pur-sl-detail-export', '导出', 1, 112002004, '/112/112002/112002004/', NULL, 0, '/fin/salSettle/exportDtl', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390650013671424, 'fin-pur-pf-start', '启用', 1, 112001005, '/112/112001/112001005/', NULL, 0, '/fin/purPreDef/enable', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390667562639360, 'mg-pur-cont-edit', '编辑', 1, 104004001, '/104/104004/104004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390706485780480, 'fin-pur-sl-detail-detail', '查看明细', 1, 112002004, '/112/112002/112002004/', NULL, 0, '/order/salRecvconf/select', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390712429109248, 'fin-pur-pf-stop', '停用', 1, 112001005, '/112/112001/112001005/', NULL, 0, '/fin/purPreDef/stop', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390737267777536, 'mg-pur-cont-change', '变更', 1, 104004001, '/104/104004/104004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390791844061184, 'mg-pur-cont-change-log', '变更记录', 1, 104004001, '/104/104004/104004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390834344943616, 'fin-pur-sl-detail-query', '查询', 1, 112002005, '/112/112002/112002005/', NULL, 0, '/order/salRecvconf/select', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390892939370496, 'mg-pur-cont-stop', '合同终止', 1, 104004001, '/104/104004/104004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446390929622753280, 'fin-pur-sl-detail-export2', '导出', 1, 112002005, '/112/112002/112002005/', NULL, 0, '/order/salRecvconf/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446391045079359488, 'fin-pur-pf-scene', '采购结算类型', 1, 112001006, '/112/112001/112001006/', NULL, 0, '/fin/purPreDefType/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446391063764983808, 'fin-pur-inc-query', '查询', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/sal/salReceiveDefine/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446391143137992704, 'fin-pur-inc-add', '添加', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446391183277481984, 'fin-pur-pf-sceneQuery', '查询', 1, 112001006, '/112/112001/112001006/', NULL, 0, '/fin/purPreDefType/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446391233995005952, 'fin-pur-inc-edit', '修改', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/sal/salReceiveDefine/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446391281386446848, 'fin-pur-pf-sceneSave', '保存', 1, 112001006, '/112/112001/112001006/', NULL, 0, '/fin/purPreDefType/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446391331835535360, 'fin-pur-inc-save', '保存', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/sal/salReceiveDefine/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446391412072570880, 'fin-pur-pf-corp', '查看公司', 1, 112001009, '/112/112001/112001009/', NULL, 0, '/fin/purPreDef/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446391606927351808, 'fin-pur-pay-query', '查询', 1, 112001008, '/112/112001/112001008/', NULL, 0, '/fin/purPreSettle/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446391849060327424, 'fin-pur-inc-del', '删除', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/sal/salReceiveDefine/delete', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392028077416448, 'mg-pur-cont-audit', '审核', 1, 104004001, '/104/104004/104004001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392127721496576, 'fin-pur-pay-audit-pass', '审核通过', 1, 112001008, '/112/112001/112001008/', NULL, 0, '/fin/purPreSettle/approved', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392186148151296, 'fin-pur-pay-audit-reject', '审核拒绝', 1, 112001008, '/112/112001/112001008/', NULL, 0, '/fin/purPreSettle/rejected', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392326367928320, 'fin-pur-pay-view', '付款单号跳转详情', 1, 112001010, '/112/112001/112001010/', NULL, 0, '/fin/purPreSettle/query/{id}', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392338682404864, 'mg-pur-apply-add', '新增', 1, 104003001, '/104/104003/104003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392409654222848, 'mg-pur-apply-edit', '编辑', 1, 104003001, '/104/104003/104003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392488511332352, 'mg-pur-apply-view', '查看采购单', 1, 104003001, '/104/104003/104003001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392545423843328, 'fin-pur-payI-audit-pass', '审核通过', 1, 112001010, '/112/112001/112001010/', NULL, 0, '/fin/purPreSettle/approved', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392555280457728, 'fin-pur-inc-cancel-company', '取消分配', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/sal/salReceiveDefine/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392608669753344, 'fin-pur-payI-audit-reject', '审核拒绝', 1, 112001010, '/112/112001/112001010/', NULL, 0, '/fin/purPreSettle/rejected', 'PUT', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392650407272448, 'fin-pur-inc-choose-company-sure', '分配公司确认', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/sal/salReceiveDefine/addEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392750575640576, 'fin-pur-inc-cancel-company-sure', '取消分配确认', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/sal/salReceiveDefine/cancelEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392829919289344, 'fin-pur-inc-start', '启用', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/sal/salReceiveDefine/enable', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392905144131584, 'fin-pur-inc-stop', '停用', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/sal/salReceiveDefine/disable', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392937146671104, 'mg-pur-moq-add', '新增', 1, 104001001, '/104/104001/104001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392964413841408, 'fin-pur-ver-query', '查询', 1, 112001011, '/112/112001/112001011/', NULL, 0, '/fin/purPreVerify/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446392999482417152, 'mg-pur-moq-edit', '编辑', 1, 104001001, '/104/104001/104001001/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446393012224712704, 'fin-pur-inc-corp', '查看公司', 1, 112002006, '/112/112002/112002006/', NULL, 0, '/sal/salReceiveDefine/listEntity', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446393584151674880, 'mg-pur-aap-add', '新增', 1, 104001004, '/104/104001/104001004/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446393667965526016, 'mg-pur-aap-edit', '编辑', 1, 104001004, '/104/104001/104001004/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446393759443296256, 'mg-pur-acc-add', '新增', 1, 104001007, '/104/104001/104001007/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446393812807426048, 'mg-pur-acc-audit', '审核', 1, 104001007, '/104/104001/104001007/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446393869170483200, 'mg-pur-acc-edit', '编辑', 1, 104001007, '/104/104001/104001007/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446393936514228224, 'fin-pur-ver-detail-query', '核销编号跳转详情', 1, 112001012, '/112/112001/112001012/', NULL, 0, '/fin/purPreVerify/dtl', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446393970911715328, 'mg-pur-purpart-add', '新增', 1, 104001010, '/104/104001/104001010/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394028986048512, 'mg-pur-purpart-edit', '编辑', 1, 104001010, '/104/104001/104001010/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394108128370688, 'fin-pur-isd-query', '查询', 1, 112002007, '/112/112002/112002007/', NULL, 0, '/sal/receiveSettle/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394150297903104, 'fin-pur-cp-query', '查询', 1, 112003001, '/112/112003/112003001/', NULL, 0, '/fin/awaitPay/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394248981487616, 'fin-pur-cp-pay', '支付', 1, 112003001, '/112/112003/112003001/', NULL, 0, '/', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394352266223616, 'fin-pur-isd-audit-pass', '审核通过', 1, 112002007, '/112/112002/112002007/', NULL, 0, '/sal/receiveSettle/approved', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394424362115072, 'fin-pur-isd-audit-reject', '审核拒绝', 1, 112002007, '/112/112002/112002007/', NULL, 0, '/sal/receiveSettle/rejected', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394461125189632, 'fin-pur-fl-query', '查询', 1, 112003002, '/112/112003/112003002/', NULL, 0, '/fin/billFlow/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394491491950592, 'fin-pur-isd-export', '导出', 1, 112002007, '/112/112002/112002007/', NULL, 0, '/sal/receiveSettle/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394557153779712, 'fin-pur-isd-id-todetail', '单号跳转详情', 1, 112002007, '/112/112002/112002007/', NULL, 0, '/sal/receiveSettle/{id}', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394580574773248, 'fin-pur-fl-axExport', '中金数据导入', 1, 112003002, '/112/112003/112003002/', NULL, 0, '/', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394736598687744, 'fin-pur-isd-audit-detail-pass', '审核通过', 1, 112002008, '/112/112002/112002008/', NULL, 0, '/sal/receiveSettle/approved', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394736900677632, 'fin-pur-fl-offExport', '模板下载', 1, 112003002, '/112/112003/112003002/', NULL, 0, '/fin/billFlow/downloadTemplate', 'GET', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394805280415744, 'fin-pur-fl-scPush', '上传', 1, 112003002, '/112/112003/112003002/', NULL, 0, '/fin/billFlow/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446394909802471424, 'fin-pur-isd-audit-detail-reject', '审核拒绝', 1, 112002008, '/112/112002/112002008/', NULL, 0, '/sal/receiveSettle/rejected', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446395062030540800, 'fin-pur-fl-del', '删除', 1, 112003002, '/112/112003/112003002/', NULL, 0, '/fin/billFlow/delet', 'DELETE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446395129911156736, 'fin-pur-fl-export', '导出', 1, 112003002, '/112/112003/112003002/', NULL, 0, '/fin/billFlow/exportWorkFlow', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446395195686232064, 'fin-pur-fl-unknow', '转为不明到款', 1, 112003002, '/112/112003/112003002/', NULL, 0, '/fin/billFlow/setHookState', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446395297968529408, 'fin-pur-isd-audit-detail-export', '导出', 1, 112002008, '/112/112002/112002008/', NULL, 0, '/sal/receiveSettle/rejected', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446395376456540160, 'fin-pur-isd-audit-detail-detail', '查看明细', 1, 112002008, '/112/112002/112002008/', NULL, 0, '/order/salReceipt/select', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446395557398814720, 'fin-pur-isd-detail-query', '查询', 1, 112002009, '/112/112002/112002009/', NULL, 0, '/order/salReceipt/select', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446395596573614080, 'mg-purc-purcPriceApplyCreate', '采购价格申请单新增', 0, 104007, '/104/104007/', NULL, 4, '/purc/price/apply/create/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446395689871712256, 'fin-pur-isd-detail-export', '导出', 1, 112002009, '/112/112002/112002009/', NULL, 0, '/order/salReceipt/export', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446395833715367936, 'fin-pur-ic-query', '查询', 1, 112002010, '/112/112002/112002010/', NULL, 0, '/sal/salVerify/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446396142143512576, 'fin-pur-ic-confirm', '核销', 1, 112002010, '/112/112002/112002010/', NULL, 0, '/sal/salVerify/dtl', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446396245025595392, 'fin-pur-ic-look', '核销查看', 1, 112002010, '/112/112002/112002010/', NULL, 0, '/sal/salVerify/dtl', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446396543081226240, 'fin-pur-rv-amt', '修改本次核销金额', 1, 112002011, '/112/112002/112002011/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446396692520083456, 'fin-pur-rv-confirm', '核销确定', 1, 112002011, '/112/112002/112002011/', NULL, 0, '/sal/salVerify/verify', 'POST', NULL, NULL, NULL, NULL, 356948235909079040, '2021-08-31 16:44:57.613787', 0, NULL, NULL, 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446396794068377600, 'fin-pur-rv-export', '导出', 1, 112002011, '/112/112002/112002011/', NULL, 0, '/sal/salVerify/exportDtl', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446398068344070144, 'fin-pur-cp-paySuccess', '确认', 1, 112003001, '/112/112003/112003001/', NULL, 0, '/fin/awaitPay/save', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446398507693219840, 'fin-pur-fl-suExport', '确认', 1, 112003002, '/112/112003/112003002/', NULL, 0, '/fin/billFlow/downCPCNFlow', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446398855732371456, 'fin-pur-fl-offImport', '线下账单导入', 1, 112003002, '/112/112003/112003002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446415400814616576, 'mg-pur-pa-query', '查询', 1, 104007002, '/104/104007/104007002/', NULL, 0, '/pur/purPurcPriceApply/findPriceApplyList', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446415512144027648, 'mg-pur-pa-cancelled', '作废申请单', 1, 104007002, '/104/104007/104007002/', NULL, 0, '/pur/purPurcPriceApply/cancel', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446415807125233664, 'mg-pur-pa-add', '新增', 1, 104007002, '/104/104007/104007002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446415886980587520, 'mg-pur-pa-edit', '编辑', 1, 104007002, '/104/104007/104007002/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446417335189872640, 'mg-purc-purcPriceApplyView', '采购价格申请单详情', 0, 104007, '/104/104007/', NULL, 5, '/purc/price/apply/view/:type', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446420009985613824, 'mg-pur-supad-audit-pass', '审批通过', 1, 446417335189872640, '/104/104007/446417335189872640/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446420091103453184, 'mg-pur-supad-audit-reject', '审批拒绝', 1, 446417335189872640, '/104/104007/446417335189872640/', NULL, 0, '/', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (446625865729679360, 'sup-price-audit-query', '查询', 1, 107003001, '/107/107003/107003001/', NULL, 0, '/pri/priMainPriceAlter/list', 'POST', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450640229387132928, 'mg-pur-acc-export', '导出', 1, 104001007, '/104/104001/104001007/', NULL, 0, '/pur/purPartsAmount/export', 'POST', NULL, NULL, 356948235909079040, '2021-07-25 10:56:21.000000', 356948235909079040, '2021-07-25 10:56:21.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450640862336966656, 'sup-item-bom-import', '导入', 1, 106005001, '/106/106005/106005001/', NULL, 0, '/itm/bom/upload', 'POST', NULL, NULL, 356948235909079040, '2021-07-25 10:58:52.000000', 356948235909079040, '2021-07-25 10:58:52.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450640933321367552, 'sup-item-bom-export', '导出', 1, 106005001, '/106/106005/106005001/', NULL, 0, '/itm/bom/itemBomExport', 'POST', NULL, NULL, 356948235909079040, '2021-07-25 10:59:09.000000', 356948235909079040, '2021-07-25 10:59:09.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450641353498353664, 'oms-order-rs-export', '导出', 1, 102004009, '/102/102004/102004009/', NULL, 0, '/order/salRDo/export', 'POST', NULL, NULL, 356948235909079040, '2021-07-25 11:00:49.000000', 356948235909079040, '2021-07-25 11:00:49.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450641544968331264, 'mg-pur-purpart-export', '导出', 1, 104001010, '/104/104001/104001010/', NULL, 0, '/pur/purPartsRatio/export', 'POST', NULL, NULL, 356948235909079040, '2021-07-25 11:01:35.000000', 356948235909079040, '2021-07-25 11:01:35.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450643393616207872, 'mg-pur-sup-import', '导入', 1, 104002001, '/104/104002/104002001/', NULL, 0, '/pur/purSuppApply/importPurSupp', 'POST', NULL, NULL, 356948235909079040, '2021-07-25 11:08:55.000000', 356948235909079040, '2021-07-25 11:08:55.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450643553607933952, 'oms-order-sr-list-confirm', '提交', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/order/salSoReturn/submitOrder', 'POST', NULL, NULL, 398861656648798208, '2021-07-25 11:09:34.000000', 398861656648798208, '2021-07-25 11:09:34.000000', 0, NULL, 'ceshi3', 'ceshi3', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450643715013140480, 'oms-order-sr-cancel', '取消', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/order/salSoReturn/cancelOrder', 'POST', NULL, NULL, 398861656648798208, '2021-07-25 11:10:12.000000', 398861656648798208, '2021-07-25 11:10:12.000000', 0, NULL, 'ceshi3', 'ceshi3', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450643877055881216, 'oms-order-sr-appr-return', '批准退货', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/order/salSoReturn/allowReturnOrder', 'POST', NULL, NULL, 398861656648798208, '2021-07-25 11:10:51.000000', 398861656648798208, '2021-07-25 11:10:51.000000', 0, NULL, 'ceshi3', 'ceshi3', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450643982815256576, 'oms-order-sr-refused-return', '仓库驳回', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/order/salSoReturn/refuseReturnOrder', 'POST', NULL, NULL, 398861656648798208, '2021-07-25 11:11:16.000000', 356948235909079040, '2021-09-23 09:46:33.148188', 0, NULL, 'ceshi3', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450644135789912064, 'oms-order-sr-appr-refund', '批准退款', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/order/salSoReturn/allowReturnMoney', 'POST', NULL, NULL, 398861656648798208, '2021-07-25 11:11:52.000000', 398861656648798208, '2021-07-25 11:11:52.000000', 0, NULL, 'ceshi3', 'ceshi3', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450644208242319360, 'oms-order-sr-refused-refund', '财务驳回', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/order/salSoReturn/refuseReturnMoney', 'POST', NULL, NULL, 398861656648798208, '2021-07-25 11:12:10.000000', 356948235909079040, '2021-09-23 09:46:09.336637', 0, NULL, 'ceshi3', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450645505544740864, 'oms-order-sr-jc-del-detail', '明细删除', 1, 102004002, '/102/102004/102004002/', NULL, 0, '/', NULL, NULL, NULL, 398861656648798208, '2021-07-25 11:17:19.000000', 398861656648798208, '2021-07-25 11:17:19.000000', 0, NULL, 'ceshi3', 'ceshi3', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450650029512646656, 'mg-pur-supad-auditde-reject', '审批拒绝', 1, 104002005, '/104/104002/104002005/', NULL, 0, '/pur/purSuppApply/approveRejected', 'PUT', NULL, NULL, 356948235909079040, '2021-07-25 11:35:18.000000', 356948235909079040, '2021-07-25 11:35:18.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450650119321083904, 'mg-pur-supad-auditde-pass', '审批通过', 1, 104002005, '/104/104002/104002005/', NULL, 0, '/pur/purSuppApply/approve', 'PUT', NULL, NULL, 356948235909079040, '2021-07-25 11:35:39.000000', 356948235909079040, '2021-07-25 11:35:39.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450675135555231744, 'oms-saleOrderManageC', 'C端销售订单管理', 0, 102, '/102/', NULL, 0, '/order/saleOrderManageC', NULL, NULL, NULL, 399161351262470154, '2021-07-25 13:15:03.000000', 399161351262470154, '2021-07-25 13:15:03.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450675418087743488, 'oms-saleOrderManageC-orderQuery-list', 'C端销售订单列表', 0, 450675135555231744, '/102/450675135555231744/', NULL, 0, '/order/saleOrderManageC/list', NULL, NULL, NULL, 399161351262470154, '2021-07-25 13:16:11.000000', 399161351262470154, '2021-07-25 13:16:11.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450675719851139072, 'oms-saleOrderManageC-orderQuery-cTypeOrder-view', 'C端销售订单详情', 0, 450675135555231744, '/102/450675135555231744/', NULL, 0, '/order/saleOrderManageC/orderQuery/cTypeOrder/view/:id', NULL, NULL, NULL, 399161351262470154, '2021-07-25 13:17:23.000000', 399161351262470154, '2021-07-25 13:17:23.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450675992292155392, 'oms-order-ctlist-query', '查询', 1, 450675418087743488, '/102/450675135555231744/450675418087743488/', NULL, 0, '/order/salSo/query', 'POST', NULL, NULL, 399161351262470154, '2021-07-25 13:18:28.000000', 399161351262470154, '2021-07-25 13:18:28.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450676120482668544, 'oms-order-ctlist-audit-pending', '暂挂', 1, 450675418087743488, '/102/450675135555231744/450675418087743488/', NULL, 0, '/order/salSoHold/artificialHold', 'POST', NULL, NULL, 399161351262470154, '2021-07-25 13:18:58.000000', 399161351262470154, '2021-07-25 13:18:58.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450676285000048640, 'oms-order-ctlist-view', '销售订单号链接', 1, 450675418087743488, '/102/450675135555231744/450675418087743488/', NULL, 0, '/order/salSo/orderDetail/', 'GET', NULL, NULL, 399161351262470154, '2021-07-25 13:19:37.000000', 399161351262470154, '2021-07-25 13:19:37.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450676417389060096, 'oms-order-ctlist-export', '导出', 1, 450675418087743488, '/102/450675135555231744/450675418087743488/', NULL, 0, '/order/salSo/export', 'POST', NULL, NULL, 399161351262470154, '2021-07-25 13:20:09.000000', 399161351262470154, '2021-07-25 13:20:09.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450676517419016192, 'oms-order-ctlist-related-order', '相关发货单', 1, 450675418087743488, '/102/450675135555231744/450675418087743488/', NULL, 0, '/', NULL, NULL, NULL, 399161351262470154, '2021-07-25 13:20:33.000000', 399161351262470154, '2021-07-25 13:20:33.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450676575149416448, 'oms-order-ctlist-pending-query', '暂挂查询', 1, 450675418087743488, '/102/450675135555231744/450675418087743488/', NULL, 0, '/', NULL, NULL, NULL, 399161351262470154, '2021-07-25 13:20:46.000000', 399161351262470154, '2021-07-25 13:20:46.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450676774454353920, 'oms-order-ct-hand-alloc', '手工配货', 1, 450675719851139072, '/102/450675135555231744/450675719851139072/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, 399161351262470154, '2021-07-25 13:21:34.000000', 399161351262470154, '2021-07-25 13:21:34.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450676873083412480, 'oms-order-ct-auto-alloc', '自动配货', 1, 450675719851139072, '/102/450675135555231744/450675719851139072/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, 399161351262470154, '2021-07-25 13:21:58.000000', 399161351262470154, '2021-07-25 13:21:58.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450676978062647296, 'oms-order-ct-del-alloc', '删除配货', 1, 450675719851139072, '/102/450675135555231744/450675719851139072/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, 399161351262470154, '2021-07-25 13:22:23.000000', 399161351262470154, '2021-07-25 13:22:23.000000', 0, NULL, 'beibei', 'beibei', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450692665804013568, 'b2b-contract-close', '关闭合同', 1, 114003005, '/114/114003/114003005/', NULL, 0, '/proj/contract/close', 'POST', NULL, NULL, 356948235909079040, '2021-07-25 14:24:43.000000', 356948235909079040, '2021-07-25 14:24:58.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450706679049175040, 'saleSettlementViewDetail1', '销售结算单明细查看(菜单进入)', 0, 112002, '/112/112002/', NULL, 0, '/saleSettlement/saleDetail1/null/null', NULL, NULL, NULL, 356948235909079040, '2021-07-25 15:20:24.000000', 356948235909079040, '2021-07-25 15:20:24.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450707066049216512, 'saleSettlementReceiptViewDetail1', '收款结算单明细查看(菜单进入)', 0, 112002, '/112/112002/', NULL, 0, '/saleSettlement/receipt/viewDetail1/null/null', NULL, NULL, NULL, 356948235909079040, '2021-07-25 15:21:56.000000', 356948235909079040, '2021-07-25 15:22:16.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450707555461578752, 'fin-pur-wp-audit', '审核', 1, 112005001, '/112/112005/112005001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-07-25 15:23:53.000000', 356948235909079040, '2021-07-25 15:23:53.000000', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450744661621690368, 'b2b-projectSale-depositQuery-vie', '支付押金详情', 0, 0, '/', NULL, 0, 'page/b2bSell/projectSale/DepositQuery/Detail', NULL, NULL, NULL, 399161351262470170, '2021-07-25 17:51:20.000000', 399161351262470170, '2021-07-25 18:00:18.000000', 0, NULL, 'bsy1', 'bsy1', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450747228569292800, 'b2b-projectSale-depositQuery-view', '支付押金详情', 0, 114003, '/114/114003/', NULL, 0, '/b2bSell/projectSale/depositQuery/view/:type/:id', NULL, NULL, NULL, 399161351262470170, '2021-07-25 18:01:32.000000', 399161351262470170, '2021-07-25 18:01:32.000000', 0, NULL, 'bsy1', 'bsy1', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450748210028040192, 'b2b-depositpay-detail-save', '保存', 1, 450747228569292800, '/114/114003/450747228569292800/', NULL, 0, '/sal/payDeposit/save', 'POST', NULL, NULL, 399161351262470170, '2021-07-25 18:05:26.000000', 399161351262470170, '2021-07-25 18:05:26.000000', 0, NULL, 'bsy1', 'bsy1', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450748404371116032, 'b2b-depositpay-detail-submit', '提交', 1, 450747228569292800, '/114/114003/450747228569292800/', NULL, 0, '/sal/payDeposit/submit', 'POST', NULL, NULL, 399161351262470170, '2021-07-25 18:06:12.000000', 399161351262470170, '2021-07-25 18:06:12.000000', 0, NULL, 'bsy1', 'bsy1', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450748519982911488, 'b2b-depositpay-detail-pass', '审批', 1, 450747228569292800, '/114/114003/450747228569292800/', NULL, 0, '/sal/payDeposit/approve/{id}/{docStatus}', 'GET', NULL, NULL, 399161351262470170, '2021-07-25 18:06:39.000000', 399161351262470170, '2021-07-25 18:06:39.000000', 0, NULL, 'bsy1', 'bsy1', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (450748607685808128, 'b2b-depositpay-detail-reject', '拒绝', 1, 450747228569292800, '/114/114003/450747228569292800/', NULL, 0, '/sal/payDeposit/approve/{id}/{docStatus}', 'GET', NULL, NULL, 399161351262470170, '2021-07-25 18:07:00.000000', 399161351262470170, '2021-07-25 18:07:00.000000', 0, NULL, 'bsy1', 'bsy1', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454769134850924544, 'oms-order-gro-hand-alloc', '手工配货	', 1, 102003003, '/102/102003/102003003/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, 356948235909079040, '2021-08-05 20:23:08.759292', 356948235909079040, '2021-08-06 09:33:06.500960', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454965199189434368, 'oms-order-gro-auto-alloc', '自动配货	', 1, 102003003, '/102/102003/102003003/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 09:22:14.138147', 356948235909079040, '2021-08-06 09:22:14.138147', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454973690956341248, 'oms-order-gro-add-purorder', '生成采购订单	', 1, 102003003, '/102/102003/102003003/', NULL, 0, '/order/salSoAlloc/createPurPo', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 09:55:58.735635', 356948235909079040, '2021-08-06 09:55:58.735635', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454973813123833856, 'oms-order-gro-del-alloc', '删除配货', 1, 102003003, '/102/102003/102003003/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-08-06 09:56:27.862773', 356948235909079040, '2021-08-06 09:56:27.862773', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454974406001287168, 'oms-order-sale-save', '保存', 1, 102001003, '/102/102001/102001003/', NULL, 0, '/order/salSo/save', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 09:58:49.215499', 356948235909079040, '2021-08-06 09:58:49.215499', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454974485185552384, 'oms-order-sale-submit', '提交', 1, 102001003, '/102/102001/102001003/', NULL, 0, '/order/salSo/submit', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 09:59:08.094146', 356948235909079040, '2021-08-06 09:59:08.094146', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454978515253190656, 'oms-order-sale-hand-alloc', '手工配货', 1, 102001002, '/102/102001/102001002/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 10:15:08.937597', 356948235909079040, '2021-08-06 10:15:08.937597', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454978615295729664, 'oms-order-sale-auto-alloc', '自动配货', 1, 102001002, '/102/102001/102001002/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 10:15:32.789305', 356948235909079040, '2021-08-06 10:15:32.789305', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454978709407522816, 'oms-order-sale-del-alloc', '删除配货信息', 1, 102001002, '/102/102001/102001002/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-08-06 10:15:55.227342', 356948235909079040, '2021-08-06 10:15:55.227342', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454978797756342272, 'oms-order-sale-del-item', '删除商品', 1, 102001002, '/102/102001/102001002/', NULL, 0, '/order/salSo/deleteSalsod', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 10:16:16.291377', 356948235909079040, '2021-08-06 10:16:16.291377', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454978983459151872, 'oms-order-sale-hand-alloc', '手工配货', 1, 102001004, '/102/102001/102001004/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 10:17:00.566385', 356948235909079040, '2021-08-06 10:17:00.566385', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454979072822992896, 'oms-order-sale-auto-alloc', '自动配货', 1, 102001004, '/102/102001/102001004/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 10:17:21.872767', 356948235909079040, '2021-08-06 10:17:21.872767', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454979153605287936, 'oms-order-sale-del-alloc', '删除配货信息	', 1, 102001004, '/102/102001/102001004/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-08-06 10:17:41.132251', 356948235909079040, '2021-08-06 10:17:41.132251', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454983630139809792, 'oms-order-rs-save', '保存', 1, 102004011, '/102/102004/102004011/', NULL, 0, '/order/salRDo/saveSalDO', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 10:35:28.421882', 356948235909079040, '2021-08-06 10:35:28.421882', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454988669503791104, 'sup-org-addTree-add-node', '新增节点', 1, 108004004, '/108/108004/108004004/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-06 10:55:29.899081', 356948235909079040, '2021-08-06 10:55:29.899081', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454988851503030272, 'org/orgBuTree', '删除选中节点', 1, 108004004, '/108/108004/108004004/', NULL, 0, '/org/orgBuTree/deleteTreeDetail/{key}&{id}', 'DELETE', NULL, NULL, 356948235909079040, '2021-08-06 10:56:13.291747', 356948235909079040, '2021-08-06 10:56:13.291747', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (454989637964390400, 'sup-org-addTree-del-node', '删除选中节点', 1, 108004004, '/108/108004/108004004/', NULL, 0, '/org/orgBuTree/deleteTreeDetail/{key}&{id}', 'DELETE', NULL, NULL, 356948235909079040, '2021-08-06 10:59:20.798921', 356948235909079040, '2021-08-06 10:59:20.798921', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (455040286722744320, 'mg-inv-invb-add', '新增', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-06 14:20:36.403033', 356948235909079040, '2021-08-06 14:20:36.403033', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (455061885719011328, 'mg-inv-whare-query', '查询', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/inv/invWh/search', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 15:46:26.005060', 356948235909079040, '2021-08-06 15:46:26.005060', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (455062000244482048, 'mg-inv-whare-add', '新增', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-06 15:46:53.310773', 356948235909079040, '2021-08-06 15:46:53.310773', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (455062118519660544, 'mg-inv-whare-edit', '修改', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-06 15:47:21.509884', 356948235909079040, '2021-08-06 15:47:21.509884', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (455062269560741888, 'mg-inv-whare-export', '导出', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/inv/invWh/exportW', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 15:47:57.520020', 356948235909079040, '2021-08-06 15:47:57.520020', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (455062453300617216, 'mg-inv-whare-syncWh', '同步仓库至激荡云', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/test/purPoInfo/storageInfoSync', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 15:48:41.327915', 356948235909079040, '2021-08-06 15:48:41.327915', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (455062578471231488, 'mg-inv-whare-syncStock', '同步库存至激荡云', 1, 103002001, '/103/103002/103002001/', NULL, 0, '/test/purPoInfo/stockFullInfoSync', 'POST', NULL, NULL, 356948235909079040, '2021-08-06 15:49:11.170906', 356948235909079040, '2021-08-06 15:49:11.170906', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (455097087958835200, 'mg-pur-order-audet-pass', '审核通过', 1, 104006004, '/104/104006/104006004/', NULL, 0, '/pur/purPo/approveBatch', 'PUT', NULL, NULL, 356948235909079040, '2021-08-06 18:06:18.873552', 356948235909079040, '2021-08-06 18:06:18.873552', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (455097228241526784, 'mg-pur-order-audet-reject', '审核拒绝', 1, 104006004, '/104/104006/104006004/', NULL, 0, '/pur/purPo/refuseBatch', 'PUT', NULL, NULL, 356948235909079040, '2021-08-06 18:06:52.319668', 356948235909079040, '2021-08-06 18:06:52.319668', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457513730332635136, 'b2b-price-approval-edit-save', '保存', 1, 113003007, '/113/113003/113003007/', NULL, 0, '/pri/sale/alter/save', 'POST', NULL, NULL, 356948235909079040, '2021-08-13 10:09:11.314073', 356948235909079040, '2021-08-13 10:09:11.314073', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457513824943550464, 'b2b-price-approval-edit-submit', '提交', 1, 113003007, '/113/113003/113003007/', NULL, 0, '/pri/sale/alter/submit', 'POST', NULL, NULL, 356948235909079040, '2021-08-13 10:09:33.871588', 356948235909079040, '2021-08-13 10:09:33.871588', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457513901112111104, 'b2b-price-approval-edit-export', '导入价格', 1, 113003007, '/113/113003/113003007/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-13 10:09:52.031271', 356948235909079040, '2021-08-13 10:09:52.031271', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457513954887282688, 'b2b-price-approval-edit-del', '删除', 1, 113003007, '/113/113003/113003007/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-13 10:10:04.852071', 356948235909079040, '2021-08-13 10:10:04.852071', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457514026211422208, 'b2b-price-approval-edit-add', '新增', 1, 113003007, '/113/113003/113003007/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-13 10:10:21.857288', 356948235909079040, '2021-08-13 10:10:21.857288', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457514198161108992, 'b2b-price-approval-edit-save', '保存', 1, 113003008, '/113/113003/113003008/', NULL, 0, '/pri/sale/alter/save', 'POST', NULL, NULL, 356948235909079040, '2021-08-13 10:11:02.853323', 356948235909079040, '2021-08-13 10:11:02.853323', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457514284127563776, 'b2b-price-approval-edit-submit', '提交', 1, 113003008, '/113/113003/113003008/', NULL, 0, '/pri/sale/alter/submit', 'POST', NULL, NULL, 356948235909079040, '2021-08-13 10:11:23.349434', 356948235909079040, '2021-08-13 10:11:23.349434', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457514366705020928, 'b2b-price-approval-edit-export', '导入价格', 1, 113003008, '/113/113003/113003008/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-13 10:11:43.037663', 356948235909079040, '2021-08-13 10:11:43.037663', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457514450809204736, 'b2b-price-approval-edit-del', '删除', 1, 113003008, '/113/113003/113003008/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-13 10:12:03.089456', 356948235909079040, '2021-08-13 10:12:03.089456', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457514513274974208, 'b2b-price-approval-edit-add', '新增', 1, 113003008, '/113/113003/113003008/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-13 10:12:17.982702', 356948235909079040, '2021-08-13 10:12:17.982702', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457514589988794368, 'b2b-price-audit-reject', '审核拒绝', 1, 113003008, '/113/113003/113003008/', NULL, 0, '/pri/sale/alter/approve', 'POST', NULL, NULL, 356948235909079040, '2021-08-13 10:12:36.272930', 356948235909079040, '2021-08-13 10:12:36.272930', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457514690874388480, 'b2b-price-audit-pass', '审核通过', 1, 113003008, '/113/113003/113003008/', NULL, 0, '/pri/sale/alter/approve', 'POST', NULL, NULL, 356948235909079040, '2021-08-13 10:13:00.325443', 356948235909079040, '2021-08-13 10:13:00.325443', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457525764264767488, 'b2b-salesSupportCenter-customerManagement-customerManagementCustList', '拓展客户所属公司', 0, 113001, '/113/113001/', NULL, 0, '/salesSupportCenter/customerManagement/custList/:custCode/:custName/:ouId', NULL, NULL, NULL, 356948235909079040, '2021-08-13 10:57:00.427035', 356948235909079040, '2021-08-13 10:57:00.427035', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457620428640694272, 'b2b-cust-async', '同步mdm状态', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/crm/cust/custMdmSync', 'GET', NULL, NULL, 356948235909079040, '2021-08-13 17:13:10.173564', 356948235909079040, '2021-08-13 17:15:02.191356', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457620517329252352, 'b2b-cust-open', '启用', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/crm/cust/switch', 'POST', NULL, NULL, 356948235909079040, '2021-08-13 17:13:31.318331', 356948235909079040, '2021-08-13 17:13:31.318331', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457620610308583424, 'b2b-cust-stop', '停用', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/crm/cust/switch', 'POST', NULL, NULL, 356948235909079040, '2021-08-13 17:13:53.486363', 356948235909079040, '2021-08-13 17:13:53.486363', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (457620702499385344, 'b2b-cust-company', '拓展客户所属公司', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/crm/custOu/save', 'POST', NULL, NULL, 356948235909079040, '2021-08-13 17:14:15.466800', 356948235909079040, '2021-08-13 17:14:15.466800', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (459754089561587712, 'b2b-cust-detail-save', '保存', 1, 113001003, '/113/113001/113001003/', NULL, 0, '/crm/cust', 'POST', NULL, NULL, 356948235909079040, '2021-08-19 14:31:34.578706', 356948235909079040, '2021-08-19 14:31:34.578706', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (459754245757468672, 'b2b-cust-detail-save', '保存', 1, 113001005, '/113/113001/113001005/', NULL, 0, '/crm/cust', 'POST', NULL, NULL, 356948235909079040, '2021-08-19 14:32:11.818235', 356948235909079040, '2021-08-19 14:32:11.818235', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (459771406689370112, 'mg-pur-sup-mdm', 'MDM同步', 1, 104002001, '/104/104002/104002001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-19 15:40:23.303446', 356948235909079040, '2021-08-19 15:40:23.303446', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (459771529049800704, 'mg-pur-sup-rfc', '供应商变更申请', 1, 104002001, '/104/104002/104002001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-19 15:40:52.476901', 356948235909079040, '2021-08-19 15:40:52.476901', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (459772229616009216, 'mg-pur-suprq-edit', '修改', 1, 104002002, '/104/104002/104002002/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-19 15:43:39.504637', 356948235909079040, '2021-08-19 15:43:39.504637', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (459772325111922688, 'mg-pur-suprq-add', '新增', 1, 104002002, '/104/104002/104002002/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-19 15:44:02.272502', 356948235909079040, '2021-08-19 15:44:02.272502', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460040394619052032, 'b2b-checkfor-detail-save', '保存', 1, 114002002, '/114/114002/114002002/', NULL, 0, 'sal/soa/save', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 09:29:15.023620', 458611982234804224, '2021-08-20 09:29:15.023620', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460040461388177408, 'b2b-checkfor-detail-sm-order', '选择发货单', 1, 114002002, '/114/114002/114002002/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-08-20 09:29:30.942762', 458611982234804224, '2021-08-20 09:29:30.942762', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460040877261807616, 'b2b-credit-detail-order', '选择b端销售单', 1, 114002006, '/114/114002/114002006/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-08-20 09:31:10.094425', 458611982234804224, '2021-08-20 09:31:10.094425', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460040953421979648, 'b2b-credit-detail-check', '选择客户对账单', 1, 114002006, '/114/114002/114002006/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-08-20 09:31:28.252052', 458611982234804224, '2021-08-20 09:31:28.252052', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460041041481392128, 'b2b-credit-detail-save', '保存', 1, 114002006, '/114/114002/114002006/', NULL, 0, '/sal/receipt/save', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 09:31:49.247640', 458611982234804224, '2021-08-20 09:31:49.247640', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460041163040710656, 'b2b-credit-detail-submit', '提交', 1, 114002006, '/114/114002/114002006/', NULL, 0, '/sal/receipt/save', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 09:32:18.229753', 458611982234804224, '2021-08-20 09:32:18.229753', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460041721243852800, 'b2b-ma-detail-save', '保存', 1, 114002010, '/114/114002/114002010/', NULL, 0, '/sal/inv/save', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 09:34:31.315851', 458611982234804224, '2021-08-20 09:34:31.315851', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460041826999033856, 'b2b-ma-detail-submit', '提交', 1, 114002010, '/114/114002/114002010/', NULL, 0, '/sal/inv/submit', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 09:34:56.529039', 458611982234804224, '2021-08-20 09:34:56.529039', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460041922960515072, 'b2b-ma-detail-order', '选择b端销售单', 1, 114002010, '/114/114002/114002010/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-08-20 09:35:19.408782', 458611982234804224, '2021-08-20 09:35:19.408782', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460041967810207744, 'b2b-ma-detail-check', '选择客户对账单', 1, 114002010, '/114/114002/114002010/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-08-20 09:35:30.101501', 458611982234804224, '2021-08-20 09:35:30.101501', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460042076300075008, 'b2b-ma-detail-del', '删除', 1, 114002010, '/114/114002/114002010/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-08-20 09:35:55.967977', 458611982234804224, '2021-08-20 09:35:55.967977', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460042301681000448, 'b2b-refund-detail-re-order', '选择退货订单', 1, 114002014, '/114/114002/114002014/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-08-20 09:36:49.702089', 458611982234804224, '2021-08-20 09:36:49.702089', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460042367271526400, 'b2b-refund-detail-submit', '提交', 1, 114002014, '/114/114002/114002014/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-08-20 09:37:05.340341', 458611982234804224, '2021-08-20 09:37:05.340341', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460042436980858880, 'b2b-refund-detail-save', '保存', 1, 114002014, '/114/114002/114002014/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-08-20 09:37:21.960717', 458611982234804224, '2021-08-20 09:37:21.960717', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460051528558403584, 'b2b-proj-detail-save', '保存', 1, 114003002, '/114/114003/114003002/', NULL, 0, '/proj/save', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 10:13:29.561963', 458611982234804224, '2021-08-20 10:13:29.561963', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460051649438244864, 'b2b-proj-detail-save', '保存', 1, 114003004, '/114/114003/114003004/', NULL, 0, '/proj/save', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 10:13:58.381921', 458611982234804224, '2021-08-20 10:13:58.381921', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460051840996302848, 'b2b-accept-detail-save', '保存', 1, 114003007, '/114/114003/114003007/', NULL, 0, '/acceptance/save', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 10:14:44.052210', 458611982234804224, '2021-08-20 10:14:44.052210', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460051936156672000, 'b2b-accept-detail-submit', '提交', 1, 114003007, '/114/114003/114003007/', NULL, 0, '/acceptance/submit', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 10:15:06.740709', 458611982234804224, '2021-08-20 10:15:06.740709', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460052102897033216, 'b2b-accept-detail-save', '保存', 1, 114003009, '/114/114003/114003009/', NULL, 0, '/acceptance/save', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 10:15:46.494571', 458611982234804224, '2021-08-20 10:15:46.494571', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460052168714051584, 'b2b-accept-detail-submit', '提交', 1, 114003009, '/114/114003/114003009/', NULL, 0, '/acceptance/submit', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 10:16:02.186819', 458611982234804224, '2021-08-20 10:16:02.186819', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460052291422609408, 'b2b-contr-detail-save', '保存', 1, 114003010, '/114/114003/114003010/', NULL, 0, '/proj/contract/save', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 10:16:31.442513', 458611982234804224, '2021-08-20 10:16:31.442513', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460052387308593152, 'b2b-contr-detail-submit', '提交', 1, 114003010, '/114/114003/114003010/', NULL, 0, '/proj/contract/submit', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 10:16:54.303742', 458611982234804224, '2021-08-20 10:16:54.303742', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460052489389563904, 'b2b-contr-detail-save', '保存', 1, 114003012, '/114/114003/114003012/', NULL, 0, '/proj/contract/save', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 10:17:18.641326', 458611982234804224, '2021-08-20 10:17:18.641326', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460052572977848320, 'b2b-contr-detail-submit', '提交', 1, 114003012, '/114/114003/114003012/', NULL, 0, '/proj/contract/submit', 'POST', NULL, NULL, 458611982234804224, '2021-08-20 10:17:38.570088', 458611982234804224, '2021-08-20 10:17:38.570088', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460144480693682176, 'fin-pur-sl-detail-query', '查询', 1, 450706679049175040, '/112/112002/450706679049175040/', NULL, 0, '/order/salRecvconf/select', 'POST', NULL, NULL, 356948235909079040, '2021-08-20 16:22:51.077367', 356948235909079040, '2021-08-20 16:22:51.077367', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460144571961737216, 'fin-pur-sl-detail-export2', '导出', 1, 450706679049175040, '/112/112002/450706679049175040/', NULL, 0, '/order/salRecvconf/export', 'POST', NULL, NULL, 356948235909079040, '2021-08-20 16:23:12.837781', 356948235909079040, '2021-08-20 16:23:12.837781', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460144674533441536, 'fin-pur-isd-detail-query', '查询', 1, 450707066049216512, '/112/112002/450707066049216512/', NULL, 0, '/order/salReceipt/select', 'POST', NULL, NULL, 356948235909079040, '2021-08-20 16:23:37.291944', 356948235909079040, '2021-08-20 16:23:37.291944', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (460144787016286208, 'fin-pur-isd-detail-export', '导出', 1, 450707066049216512, '/112/112002/450707066049216512/', NULL, 0, '/order/salReceipt/export', 'POST', NULL, NULL, 356948235909079040, '2021-08-20 16:24:04.110165', 356948235909079040, '2021-08-20 16:24:04.110165', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (461278039982624768, 'b2b-proCust-detail-save', '保存', 1, 113002002, '/113/113002/113002002/', NULL, 0, '/crm/scust/save', 'POST', NULL, NULL, 458664476239691776, '2021-08-23 19:27:12.672721', 458664476239691776, '2021-08-23 19:27:29.978477', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (461278224729133056, 'b2b-proCust-detail-save', '保存', 1, 113002004, '/113/113002/113002004/', NULL, 0, '/crm/scust/save', 'POST', NULL, NULL, 458664476239691776, '2021-08-23 19:27:56.718938', 458664476239691776, '2021-08-23 19:27:56.718938', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (461280065017761792, 'b2b-bid--detail-save', '保存', 1, 113004002, '/113/113004/113004002/', NULL, 0, '/sal/quotation/createSalQuotation', 'POST', NULL, NULL, 458664476239691776, '2021-08-23 19:35:15.478079', 458664476239691776, '2021-08-23 19:35:15.478079', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (461280224770412544, 'b2b-bid--detail-submit', '提交', 1, 113004002, '/113/113004/113004002/', NULL, 0, '/', 'POST', NULL, NULL, 458664476239691776, '2021-08-23 19:35:53.566749', 458664476239691776, '2021-08-23 19:35:53.566749', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (461280297281540096, 'b2b-bid-detail-del', '删除', 1, 113004002, '/113/113004/113004002/', NULL, 0, '/', 'POST', NULL, NULL, 458664476239691776, '2021-08-23 19:36:10.854280', 458664476239691776, '2021-08-23 19:36:10.854280', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (461280672034213888, 'b2b-bid--detail-save', '保存', 1, 113004004, '/113/113004/113004004/', NULL, 0, '/sal/quotation/createSalQuotation', 'POST', NULL, NULL, 458664476239691776, '2021-08-23 19:37:40.202362', 458664476239691776, '2021-08-23 19:37:40.202362', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (461280746650882048, 'b2b-bid--detail-submit', '提交', 1, 113004004, '/113/113004/113004004/', NULL, 0, '/', NULL, NULL, NULL, 458664476239691776, '2021-08-23 19:37:57.992270', 458664476239691776, '2021-08-23 19:37:57.992270', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (461280820504186880, 'b2b-bid-detail-del', '删除', 1, 113004004, '/113/113004/113004004/', NULL, 0, '/', NULL, NULL, NULL, 458664476239691776, '2021-08-23 19:38:15.600226', 458664476239691776, '2021-08-23 19:38:15.600226', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (461282078686334976, 'b2b-checkfor-detail-submit', '确认', 1, 114002003, '/114/114002/114002003/', NULL, 0, '/yst-sale/sal/soa/affirm/{id}', 'GET', NULL, NULL, 458664476239691776, '2021-08-23 19:43:15.574219', 458664476239691776, '2021-08-23 19:43:15.574219', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (461282310358716416, 'b2b-checkfor-detail-export', '打印对账单', 1, 114002003, '/114/114002/114002003/', NULL, 0, '/', NULL, NULL, NULL, 458664476239691776, '2021-08-23 19:44:10.809424', 458664476239691776, '2021-08-23 19:44:10.809424', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (462281845092536320, 'b2b-contract-order', '生成合同订单', 1, 114003005, '/114/114003/114003005/', NULL, 0, '/proj/contract/toOrder/{id}', 'POST', NULL, NULL, 458611982234804224, '2021-08-26 13:55:58.460825', 458611982234804224, '2021-08-26 13:55:58.460825', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (462323288418963456, 'b2b-price-exports', '导出', 1, 113003001, '/113/113003/113003001/', NULL, 0, '/pri/sale/price/exportData', 'POST', NULL, NULL, 458664476239691776, '2021-08-26 16:40:39.319014', 458664476239691776, '2021-08-26 16:40:39.319014', 0, NULL, 'xuxf', 'xuxf', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (462353639010881536, 'support-orgCenter-orgTree-view', '组织树详情', 0, 108004, '/108/108004/', NULL, 0, '/orgCenter/orgTree/view/:id', NULL, NULL, NULL, 356948235909079040, '2021-08-26 18:41:15.464355', 356948235909079040, '2021-08-26 18:41:59.698984', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464126103046967296, 'fin-pur-re-force-confirm', '强制对账', 1, 112004001, '/112/112004/112004001/', NULL, 0, '/sal/receiveSettle/checkByHand', 'POST', NULL, NULL, 356948235909079040, '2021-08-31 16:04:23.821156', 356948235909079040, '2021-08-31 16:04:23.821156', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464126455569829888, 'financeReceiptBankCheckManual', '手动核对', 0, 112004, '/112/112004/', NULL, 0, '/finance/receipt/BankCheck/Manual/:receiveSettleNo', NULL, NULL, NULL, 356948235909079040, '2021-08-31 16:05:47.869935', 356948235909079040, '2021-08-31 16:05:47.869935', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464126613221134336, 'fin-pur-re-flow-quey', '查询', 1, 464126455569829888, '/112/112004/464126455569829888/', NULL, 0, '/fin/billFlow/queryByEntityId', 'POST', NULL, NULL, 356948235909079040, '2021-08-31 16:06:25.456177', 356948235909079040, '2021-08-31 16:06:25.456177', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464126730107998208, 'fin-pur-re-flow-confirm', '确认对账', 1, 464126455569829888, '/112/112004/464126455569829888/', NULL, 0, '/sal/receiveSettle/checkConfirm', 'POST', NULL, NULL, 356948235909079040, '2021-08-31 16:06:53.324709', 356948235909079040, '2021-08-31 16:06:53.324709', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464139046941741056, 'saleSettlementSaleVerify', '销售核销管理', 0, 112002, '/112/112002/', NULL, 0, '/saleSettlement/saleVerify', NULL, NULL, NULL, 356948235909079040, '2021-08-31 16:55:49.886822', 356948235909079040, '2021-08-31 16:55:49.886822', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464139540976226304, 'saleSettlementSaleVerifyView', '销售核销明细', 0, 112002, '/112/112002/', NULL, 0, '/saleSettlement/saleVerify/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-08-31 16:57:47.673446', 356948235909079040, '2021-08-31 16:57:47.673446', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464140041973256192, 'fin-pur-sac-query', '查询', 1, 464139046941741056, '/112/112002/464139046941741056/', NULL, 0, '/sal/verify/list', 'POST', NULL, NULL, 356948235909079040, '2021-08-31 16:59:47.120690', 356948235909079040, '2021-08-31 16:59:47.120690', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464140568169664512, 'fin-pur-sac-confirm', '核销', 1, 464139046941741056, '/112/112002/464139046941741056/', NULL, 0, '/sal/verify/dtl', 'POST', NULL, NULL, 356948235909079040, '2021-08-31 17:01:52.575555', 356948235909079040, '2021-08-31 17:01:52.575555', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464140970587967488, 'fin-pur-sac-look', '核销查看', 1, 464139046941741056, '/112/112002/464139046941741056/', NULL, 0, '/sal/verify/dtl', 'POST', NULL, NULL, 356948235909079040, '2021-08-31 17:03:28.519425', 356948235909079040, '2021-08-31 17:03:28.519425', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464141420074749952, 'fin-pur-sa-amt', '修改本次核销金额', 1, 464139540976226304, '/112/112002/464139540976226304/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-08-31 17:05:15.685434', 356948235909079040, '2021-08-31 17:05:15.685434', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464141739433250816, 'fin-pur-sa-confirm', '核销确定', 1, 464139540976226304, '/112/112002/464139540976226304/', NULL, 0, '/sal/salVerify/verify', 'POST', NULL, NULL, 356948235909079040, '2021-08-31 17:06:31.826555', 356948235909079040, '2021-08-31 17:06:31.826555', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (464142338199506944, 'fin-pur-sa-export', '导出', 1, 464139540976226304, '/112/112002/464139540976226304/', NULL, 0, '/sal/verify/exportDtl', 'POST', NULL, NULL, 356948235909079040, '2021-08-31 17:08:54.583103', 356948235909079040, '2021-08-31 17:08:54.583103', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466312417833971712, 'mg-purc-purcMdataReturnAddr', '采购退货地址维护', 0, 104001, '/104/104001/', NULL, 0, '/purc/mdata/returnAddr', NULL, NULL, NULL, 356948235909079040, '2021-09-06 16:52:01.886377', 356948235909079040, '2021-09-06 16:52:01.886377', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466312515120852992, 'mg-pur-returnAddr-add', '新增', 1, 466312417833971712, '/104/104001/466312417833971712/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-09-06 16:52:25.067372', 356948235909079040, '2021-09-06 16:52:25.067372', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466312572196941824, 'mg-pur-returnAddr-edit', '修改', 1, 466312417833971712, '/104/104001/466312417833971712/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-09-06 16:52:38.689290', 356948235909079040, '2021-09-06 16:52:38.689290', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466312704489484288, 'mg-pur-returnAddr-sync', '全部同步激荡云', 1, 466312417833971712, '/104/104001/466312417833971712/', NULL, 0, '/pur/returnAddress/sync', 'POST', NULL, NULL, 356948235909079040, '2021-09-06 16:53:10.230347', 356948235909079040, '2021-09-06 16:53:47.550384', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466312978755022848, 'mg-pur-returnAddr-import', '导入', 1, 466312417833971712, '/104/104001/466312417833971712/', NULL, 0, '/pur/returnAddress/import', 'POST', NULL, NULL, 356948235909079040, '2021-09-06 16:54:15.620351', 356948235909079040, '2021-09-06 16:54:15.620351', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466313084447289344, 'mg-pur-returnAddr-export', '导出', 1, 466312417833971712, '/104/104001/466312417833971712/', NULL, 0, '/pur/returnAddress/export', 'POST', NULL, NULL, 356948235909079040, '2021-09-06 16:54:40.819038', 356948235909079040, '2021-09-06 16:54:40.819038', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466313263703453696, 'mg-pur-returnAddr-search', '查询', 1, 466312417833971712, '/104/104001/466312417833971712/', NULL, 0, '/pur/returnAddress/search', 'POST', NULL, NULL, 356948235909079040, '2021-09-06 16:55:23.557863', 356948235909079040, '2021-09-06 16:55:23.557863', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466315354601746432, 'mg-pur-sup-syncReturnAddress', '同步供应商到激荡云', 1, 104002001, '/104/104002/104002001/', NULL, 0, '/pur/purSupp/sync/returnAddress', 'POST', NULL, NULL, 356948235909079040, '2021-09-06 17:03:42.066040', 356948235909079040, '2021-09-06 17:03:42.066040', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466349690222866432, 'b2b-projectSale-depositQuery-create', '新建支付押金', 0, 114003, '/114/114003/', NULL, 0, '/shell/projectSale/depositQuery/create', NULL, NULL, NULL, 293, '2021-09-06 19:20:08.316778', 293, '2021-09-06 19:20:08.316778', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466350321864077312, 'b2b-projectSale-depositQuery-edit', '编辑支付押金', 0, 114003, '/114/114003/', NULL, 0, '/shell/projectSale/depositQuery/:type/:id', NULL, NULL, NULL, 293, '2021-09-06 19:22:38.911555', 293, '2021-09-06 19:22:38.911555', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466351212763607040, 'b2b-projectSale-depositQuery-returnView', '退押金详情', 0, 114003, '/114/114003/', NULL, 0, '/shell/projectSale/depositQuery/Returnview/:type/:id', NULL, NULL, NULL, 293, '2021-09-06 19:26:11.318342', 293, '2021-09-06 19:26:11.318342', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466351469606006784, 'b2b-depositpay-detail-save', '保存', 1, 466349690222866432, '/114/114003/466349690222866432/', NULL, 0, '/sal/payDeposit/save', 'POST', NULL, NULL, 293, '2021-09-06 19:27:12.554118', 293, '2021-09-06 19:27:12.554118', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466351617685909504, 'b2b-depositpay-detail-submit', '提交', 1, 466349690222866432, '/114/114003/466349690222866432/', NULL, 0, '/sal/payDeposit/submit', 'POST', NULL, NULL, 293, '2021-09-06 19:27:47.859262', 293, '2021-09-06 19:27:47.859262', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466351761856720896, 'b2b-depositpay-detail-save', '保存', 1, 466350321864077312, '/114/114003/466350321864077312/', NULL, 0, '/sal/payDeposit/save', 'POST', NULL, NULL, 293, '2021-09-06 19:28:22.232865', 293, '2021-09-06 19:28:22.232865', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466351837488410624, 'b2b-depositpay-detail-submit', '提交', 1, 466350321864077312, '/114/114003/466350321864077312/', NULL, 0, '/sal/payDeposit/submit', 'POST', NULL, NULL, 293, '2021-09-06 19:28:40.264942', 293, '2021-09-06 19:28:40.264942', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466353881314029568, 'b2b-depositpay-detail-save', '保存', 1, 466351212763607040, '/114/114003/466351212763607040/', NULL, 0, '/sal/payDeposit/save', 'POST', NULL, NULL, 293, '2021-09-06 19:36:47.550345', 293, '2021-09-06 19:36:47.550345', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466353958472445952, 'b2b-depositpay-detail-submit', '提交', 1, 466351212763607040, '/114/114003/466351212763607040/', NULL, 0, '/sal/payDeposit/submit', 'POST', NULL, NULL, 293, '2021-09-06 19:37:05.946594', 293, '2021-09-06 19:37:05.946594', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466354031038099456, 'b2b-depositpay-detail-pass', '审批', 1, 466351212763607040, '/114/114003/466351212763607040/', NULL, 0, '/sal/payDeposit/approve/{id}/{docStatus}', 'GET', NULL, NULL, 293, '2021-09-06 19:37:23.247482', 293, '2021-09-06 19:37:53.285099', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466354125326053376, 'b2b-depositpay-detail-reject', '拒绝', 1, 466351212763607040, '/114/114003/466351212763607040/', NULL, 0, '/sal/payDeposit/approve/{id}/{docStatus}', 'GET', NULL, NULL, 293, '2021-09-06 19:37:45.727539', 293, '2021-09-06 19:37:45.727539', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466354417954254848, 'oms-saleOrderManage-orderQueryContractOrder-edit', '合同订单编辑', 0, 102001, '/102/102001/', NULL, 0, '/order/saleOrderManage/orderQuery/contractOrder/edit/:id', NULL, NULL, NULL, 293, '2021-09-06 19:38:55.495064', 356948235909079040, '2021-09-06 19:56:15.305697', 0, NULL, 'lurr', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466354582689738752, 'oms-saleOrderManage-orderQueryContractOrder-view', '合同订单详情', 0, 102001, '/102/102001/', NULL, 0, '/order/saleOrderManage/orderQuery/contractOrder/view/:id', NULL, NULL, NULL, 293, '2021-09-06 19:39:34.771326', 356948235909079040, '2021-09-06 19:56:38.037481', 0, NULL, 'lurr', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466355981280407552, 'oms-order-sale-hand-alloc', '手工配货', 1, 466354417954254848, '/102/102001/466354417954254848/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, 293, '2021-09-06 19:45:08.221048', 293, '2021-09-06 19:47:46.090019', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466356767741767680, 'oms-order-sale-auto-alloc', '自动配货', 1, 466354417954254848, '/102/102001/466354417954254848/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, 293, '2021-09-06 19:48:15.728251', 293, '2021-09-06 19:48:15.728251', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466356937640439808, 'oms-order-sale-del-alloc', '删除配货信息', 1, 466354417954254848, '/102/102001/466354417954254848/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, 293, '2021-09-06 19:48:56.235849', 293, '2021-09-06 19:48:56.235849', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466357103210590208, 'oms-order-sale-hand-alloc', '手工配货', 1, 466354582689738752, '/102/102001/466354582689738752/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, 293, '2021-09-06 19:49:35.710867', 293, '2021-09-06 19:49:35.710867', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466357183246299136, 'oms-order-sale-auto-alloc', '自动配货', 1, 466354582689738752, '/102/102001/466354582689738752/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, 293, '2021-09-06 19:49:54.792239', 293, '2021-09-06 19:49:54.792239', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466357264150228992, 'oms-order-sale-del-alloc', '删除配货信息', 1, 466354582689738752, '/102/102001/466354582689738752/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, 293, '2021-09-06 19:50:14.081958', 293, '2021-09-06 19:50:14.081958', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466357848525828096, 'oms-order-sale-save', '保存', 1, 466354417954254848, '/102/102001/466354417954254848/', NULL, 0, '/order/salSo/save', 'POST', NULL, NULL, 293, '2021-09-06 19:52:33.407902', 293, '2021-09-06 19:52:33.407902', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466357926162395136, 'oms-order-sale-submit', '提交', 1, 466354417954254848, '/102/102001/466354417954254848/', NULL, 0, '/order/salSo/submit', 'POST', NULL, NULL, 293, '2021-09-06 19:52:51.917205', 293, '2021-09-06 19:52:51.917205', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466358197282205696, 'oms-order-sale-del-item', '删除商品', 1, 466354417954254848, '/102/102001/466354417954254848/', NULL, 0, '/order/salSo/deleteSalsod', 'POST', NULL, NULL, 293, '2021-09-06 19:53:56.557434', 293, '2021-09-06 19:53:56.557434', 0, NULL, 'lurr', 'lurr', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466638955938902016, 'oms-order-sr-kc-save', '保存', 1, 102004005, '/102/102004/102004005/', NULL, 0, '/order/salSoReturn/rWOrderSave', 'POST', NULL, NULL, 356948235909079040, '2021-09-07 14:29:34.637084', 356948235909079040, '2021-09-07 14:29:34.637084', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466639281060376576, 'oms-order-sr-kc-confirm', '提交', 1, 102004005, '/102/102004/102004005/', NULL, 0, '/order/salSoReturn/rWOrderSubmit', 'POST', NULL, NULL, 356948235909079040, '2021-09-07 14:30:52.152121', 356948235909079040, '2021-09-07 14:30:52.152121', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466639393312534528, 'oms-order-sr-kc-del-item', '删除商品', 1, 102004005, '/102/102004/102004005/', NULL, 0, '/order/salSoReturn/deleteSalSoDs', 'POST', NULL, NULL, 356948235909079040, '2021-09-07 14:31:18.915902', 356948235909079040, '2021-09-07 14:31:18.915902', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466640292248350720, 'oms-order-sr-kc-save', '保存', 1, 102004006, '/102/102004/102004006/', NULL, 0, '/order/salSoReturn/rWOrderSave', 'POST', NULL, NULL, 458747224501436416, '2021-09-07 14:34:53.238734', 458747224501436416, '2021-09-07 14:34:53.238734', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466640377178812416, 'oms-order-sr-kc-confirm', '提交', 1, 102004006, '/102/102004/102004006/', NULL, 0, '/order/salSoReturn/rWOrderSubmit', 'POST', NULL, NULL, 458747224501436416, '2021-09-07 14:35:13.487958', 458747224501436416, '2021-09-07 14:35:13.487958', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466640485408632832, 'oms-order-sr-kc-del-item', '删除商品', 1, 102004006, '/102/102004/102004006/', NULL, 0, '/order/salSoReturn/deleteSalSoDs', 'POST', NULL, NULL, 458747224501436416, '2021-09-07 14:35:39.291337', 458747224501436416, '2021-09-07 14:35:39.291337', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466672193021472768, 'sup-item-cate-cate-export', '品类导出', 1, 106002001, '/106/106002/106002001/', NULL, 0, '/itm/itmItemCate/export', 'GET', NULL, NULL, 356948235909079040, '2021-09-07 16:41:38.975172', 356948235909079040, '2021-09-07 16:41:38.975172', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466672343714426880, 'sup-item-attr-import', '导入', 1, 106002002, '/106/106002/106002002/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-09-07 16:42:14.903552', 356948235909079040, '2021-09-07 16:42:14.903552', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466672568256491520, 'sup-item-attr-export', '导出', 1, 106002002, '/106/106002/106002002/', NULL, 0, '/itm/itmCateProp/export', 'POST', NULL, NULL, 356948235909079040, '2021-09-07 16:43:08.438383', 356948235909079040, '2021-09-07 16:43:08.438383', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466672752289968128, 'sup-item-brand-export', '导出', 1, 106003001, '/106/106003/106003001/', NULL, 0, '/itm/brand/itemBrandExport', 'POST', NULL, NULL, 356948235909079040, '2021-09-07 16:43:52.315030', 356948235909079040, '2021-09-07 16:43:52.315030', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466672927448297472, 'sup-item-list-item-export', '导出', 1, 106004001, '/106/106004/106004001/', NULL, 0, '/itm/item/export', 'POST', NULL, NULL, 356948235909079040, '2021-09-07 16:44:34.076384', 356948235909079040, '2021-09-07 16:44:34.076384', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466727864781828096, 'b2b-credit-detail-del', '删除', 1, 114002006, '/114/114002/114002006/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-09-07 20:22:52.157956', 458611982234804224, '2021-09-07 20:22:52.157956', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466729245374738432, 'b2b-shell-refundMg-return', '退押金编辑', 0, 114002, '/114/114002/', NULL, 0, '/shell/salesCollectionManagement/refundMg/return/:id', NULL, NULL, NULL, 458611982234804224, '2021-09-07 20:28:21.316215', 458611982234804224, '2021-09-07 20:28:21.316215', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466729498358378496, 'b2b-refund-detail-save', '保存', 1, 466729245374738432, '/114/114002/466729245374738432/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-09-07 20:29:21.632821', 458611982234804224, '2021-09-07 20:29:21.632821', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466729531858284544, 'b2b-refund-detail-submit', '提交', 1, 466729245374738432, '/114/114002/466729245374738432/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-09-07 20:29:29.619115', 458611982234804224, '2021-09-07 20:29:38.510104', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (466729651916042240, 'b2b-refund-detail-re-order', '选择退货订单', 1, 466729245374738432, '/114/114002/466729245374738432/', NULL, 0, '/', NULL, NULL, NULL, 458611982234804224, '2021-09-07 20:29:58.243205', 458611982234804224, '2021-09-07 20:29:58.243205', 0, NULL, 'EL-BSY', 'EL-BSY', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469457639266877440, 'invoice', '发票管理', 0, 112, '/112/', NULL, 0, '/invoice', NULL, NULL, NULL, 356948235909079040, '2021-09-15 09:10:01.111805', 356948235909079040, '2021-09-15 09:10:01.111805', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469458017198833664, 'invoiceApply', '开票申请', 0, 469457639266877440, '/112/469457639266877440/', NULL, 0, '/invoice/apply', NULL, NULL, NULL, 356948235909079040, '2021-09-15 09:11:31.216684', 356948235909079040, '2021-09-15 09:11:31.216684', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469458109951672320, 'invoicePendingApply', '待开发票申请', 0, 469457639266877440, '/112/469457639266877440/', NULL, 0, '/invoice/pendingApply', NULL, NULL, NULL, 356948235909079040, '2021-09-15 09:11:53.331442', 356948235909079040, '2021-09-15 09:11:53.331442', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469458191103066112, 'invoiceRedDashed', '发票红冲', 0, 469457639266877440, '/112/469457639266877440/', NULL, 0, '/invoice/redDashed', NULL, NULL, NULL, 356948235909079040, '2021-09-15 09:12:12.679519', 356948235909079040, '2021-09-15 09:12:12.679519', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469458291346931712, 'invoiceApplyEdit', '发票明细', 0, 469457639266877440, '/112/469457639266877440/', NULL, 0, '/invoice/apply/detail/:id', NULL, NULL, NULL, 356948235909079040, '2021-09-15 09:12:36.579810', 356948235909079040, '2022-01-07 17:34:12.837118', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469458393302073344, 'invoicePendingApplyEdit', '发票开具明细', 0, 469457639266877440, '/112/469457639266877440/', NULL, 0, '/invoice/pendingApply/detail/:id', NULL, NULL, NULL, 356948235909079040, '2021-09-15 09:13:00.887722', 356948235909079040, '2022-01-07 17:34:51.075242', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469458936196005888, 'fin-pur-kp-query', '查询', 1, 469458017198833664, '/112/469457639266877440/469458017198833664/', NULL, 0, '/inv/applyCust/list', 'POST', NULL, NULL, 356948235909079040, '2021-09-15 09:15:10.323790', 356948235909079040, '2021-09-15 09:15:10.323790', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469458995134365696, 'fin-inv-kp-export', '导出', 1, 469458017198833664, '/112/469457639266877440/469458017198833664/', NULL, 0, '/inv/applyCust/export', 'POST', NULL, NULL, 356948235909079040, '2021-09-15 09:15:24.375193', 356948235909079040, '2021-09-15 09:15:24.375193', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469459068429828096, 'fin-inv-kp-id-detail', '发票号跳详情', 1, 469458017198833664, '/112/469457639266877440/469458017198833664/', NULL, 0, '/inv/applyCust/inv/{id}', 'GET', NULL, NULL, 356948235909079040, '2021-09-15 09:15:41.850137', 356948235909079040, '2021-09-15 09:15:41.850137', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469459155910426624, 'fin-inv-kp-download', '发票下载', 1, 469458017198833664, '/112/469457639266877440/469458017198833664/', NULL, 0, '/inv/applyCust/add', 'POST', NULL, NULL, 356948235909079040, '2021-09-15 09:16:02.707114', 356948235909079040, '2021-09-17 10:52:05.694367', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469459419589541888, 'fin-inv-ped-query', '查询', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/list', 'POST', NULL, NULL, 356948235909079040, '2021-09-15 09:17:05.573561', 356948235909079040, '2021-09-15 09:20:09.695728', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469459491538632704, 'fin-inv-ped-edit', '编辑', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/inv/{id}', 'GET', NULL, NULL, 356948235909079040, '2021-09-15 09:17:22.727849', 356948235909079040, '2021-09-15 09:17:22.727849', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469459561390571520, 'fin-inv-ped-save', '保存', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/update/{id}', 'PUT', NULL, NULL, 356948235909079040, '2021-09-15 09:17:39.381475', 356948235909079040, '2021-09-15 09:17:39.381475', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469459636128874496, 'fin-inv-ped-export', '导出', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/export', 'POST', NULL, NULL, 356948235909079040, '2021-09-15 09:17:57.200920', 356948235909079040, '2021-09-15 09:17:57.200920', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469459748980817920, 'fin-inv-ped-affirm', '确认开票', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/openInv/{id}', 'PUT', NULL, NULL, 356948235909079040, '2021-09-15 09:18:24.106306', 356948235909079040, '2021-09-27 16:49:39.902474', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469459842660597760, 'fin-inv-ped-update', '更新开票状态', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/updateInv', 'POST', NULL, NULL, 356948235909079040, '2021-09-15 09:18:46.441594', 356948235909079040, '2021-09-27 16:49:53.827453', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469459893348761600, 'fin-inv-ped-cancel', '作废', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/details', 'POST', NULL, NULL, 356948235909079040, '2021-09-15 09:18:58.526096', 356948235909079040, '2021-09-27 15:18:58.674055', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469459956523368448, 'fin-inv-ped-id-detail', '开票申请号跳详情', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/inv/{id}', 'GET', NULL, NULL, 356948235909079040, '2021-09-15 09:19:13.588626', 356948235909079040, '2021-09-15 09:19:13.588626', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469460373059698688, 'fin-inv-red-query', '查询', 1, 469458191103066112, '/112/469457639266877440/469458191103066112/', NULL, 0, '/inv/redCust/list', 'POST', NULL, NULL, 356948235909079040, '2021-09-15 09:20:52.898744', 356948235909079040, '2021-09-15 09:20:52.898744', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469460584997879808, 'fin-inv-red-edit', '编辑', 1, 469458191103066112, '/112/469457639266877440/469458191103066112/', NULL, 0, '/inv/redCust/inv/{id}', 'GET', NULL, NULL, 356948235909079040, '2021-09-15 09:21:43.428841', 356948235909079040, '2021-09-15 09:21:43.428841', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469460659455164416, 'fin-inv-red-save', '保存', 1, 469458191103066112, '/112/469457639266877440/469458191103066112/', NULL, 0, '/inv/redCust/update/{id}', 'PUT', NULL, NULL, 356948235909079040, '2021-09-15 09:22:01.180045', 356948235909079040, '2021-09-15 09:22:01.180045', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469891897697607680, 'oms-allocManage', '总部配货管理', 0, 102, '/102/', NULL, 0, '/order/allocManage', NULL, NULL, NULL, 356948235909079040, '2021-09-16 13:55:36.389895', 356948235909079040, '2021-09-16 13:55:36.389895', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892009450643456, 'oms-allocManage-saleOrderAllocIndex', '销售订单配货', 0, 469891897697607680, '/102/469891897697607680/', NULL, 0, '/order/allocManage/saleOrderAlloc/index', NULL, NULL, NULL, 356948235909079040, '2021-09-16 13:56:03.033294', 356948235909079040, '2021-09-16 13:56:03.033294', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892135418175488, 'oms-allocManage-awaitPurIndex', '待采购项', 0, 469891897697607680, '/102/469891897697607680/', NULL, 0, '/order/allocManage/awaitPur/index', NULL, NULL, NULL, 356948235909079040, '2021-09-16 13:56:33.066844', 356948235909079040, '2021-09-16 13:56:33.066844', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892228070350848, 'oms-order-db-mark', '标记妥投', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/markBatch', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 13:56:55.156412', 356948235909079040, '2021-09-16 13:56:55.156412', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892256386097152, 'oms-allocManage-batchSuppFlag', '批量修改一件代发', 0, 469891897697607680, '/102/469891897697607680/', NULL, 0, '/order/allocManage/batchSuppFlag/index', NULL, NULL, NULL, 356948235909079040, '2021-09-16 13:57:01.907342', 356948235909079040, '2021-09-16 13:57:01.907342', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892320235986944, 'oms-order-db-updateLogis', '修改物流', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/updateLogis', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 13:57:17.130194', 356948235909079040, '2021-09-16 13:57:17.130194', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892426842611712, 'oms-order-am-order-query', '查询', 1, 469892009450643456, '/102/469891897697607680/469892009450643456/', NULL, 0, '/order/salSo/searchAlloc', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 13:57:42.547524', 356948235909079040, '2021-09-16 13:57:42.547524', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892437634555904, 'oms-order-db-retrySyncLogis', '重新同步C端', 1, 102002002, '/102/102002/102002002/', NULL, 0, '/order/salDo/retrySyncLogis', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 13:57:45.120517', 356948235909079040, '2021-09-16 13:57:45.120517', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892543242936320, 'oms-order-am-order-alloc', '配货', 1, 469892009450643456, '/102/469891897697607680/469892009450643456/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 13:58:10.299838', 356948235909079040, '2021-09-16 13:58:10.299838', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892796054609920, 'oms-order-ap-query', '查询', 1, 469892135418175488, '/102/469891897697607680/469892135418175488/', NULL, 0, '/order/salSoTobuy/search', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 13:59:10.574599', 356948235909079040, '2021-09-16 13:59:10.574599', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892870566420480, 'oms-order-am-create-pur', '生成采购单', 1, 469892009450643456, '/102/469891897697607680/469892009450643456/', NULL, 0, '/order/salSoAlloc/createBatchPurPo', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 13:59:28.339100', 356948235909079040, '2021-09-16 13:59:28.339100', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892902019506176, 'oms-order-ap-add', '生成采购单', 1, 469892135418175488, '/102/469891897697607680/469892135418175488/', NULL, 0, '/order/salSoTobuy/createPurVOBySalTobuy', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 13:59:35.838291', 356948235909079040, '2021-09-16 13:59:35.838291', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892992318676992, 'oms-order-ap-del', '删除', 1, 469892135418175488, '/102/469891897697607680/469892135418175488/', NULL, 0, '/order/salSoTobuy/deleteBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-09-16 13:59:57.367350', 356948235909079040, '2021-09-16 13:59:57.367350', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469892992767467520, 'oms-order-am-await-pur', '生成待采购项', 1, 469892009450643456, '/102/469891897697607680/469892009450643456/', NULL, 0, '/order/salSoTobuy/createBatch', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 13:59:57.474128', 356948235909079040, '2021-09-16 13:59:57.474128', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469893081774792704, 'oms-order-am-view-pur', '查看待采购项', 1, 469892009450643456, '/102/469891897697607680/469892009450643456/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-09-16 14:00:18.695885', 356948235909079040, '2021-09-16 14:00:18.695885', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469893087932030976, 'oms-order-bs-query', '查询', 1, 469892256386097152, '/102/469891897697607680/469892256386097152/', NULL, 0, '/order/salSo/queryDetails', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 14:00:20.163074', 356948235909079040, '2021-09-16 14:00:20.163074', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469893196887465984, 'oms-order-bs-nosuppflag', '改成非一件代发', 1, 469892256386097152, '/102/469891897697607680/469892256386097152/', NULL, 0, '/order/salSo/updateSuppFlag', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 14:00:46.140566', 356948235909079040, '2021-09-16 14:00:46.140566', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (469897606682222592, 'oms-order-sr-export', '导出', 1, 102004001, '/102/102004/102004001/', NULL, 0, '/order/salSoReturn/exportSalRSo', 'POST', NULL, NULL, 356948235909079040, '2021-09-16 14:18:17.517125', 356948235909079040, '2021-09-16 14:18:17.517125', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (470286068610605056, 'oms-cardOrderManage', '购物卡销售订单管理', 0, 102, '/102/', NULL, 0, '/order/cardOrderManage', NULL, NULL, NULL, 356948235909079040, '2021-09-17 16:01:54.058688', 481905661183741952, '2021-10-20 17:23:36.899123', 0, NULL, 'admin', 'xixi', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (470286189586915328, 'oms-cardOrderManage-list', '购物卡销售订单列表', 0, 470286068610605056, '/102/470286068610605056/', NULL, 0, '/order/cardOrderManage/list', NULL, NULL, NULL, 356948235909079040, '2021-09-17 16:02:22.901104', 356948235909079040, '2021-09-17 16:02:22.901104', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472363891605315584, 'oms-order-db-upload-nosuppflag', '上传发货信息（非一件代发）', 1, 102002001, '/102/102002/102002001/', NULL, 0, '/order/salDo/importOrderList2', 'POST', NULL, NULL, 356948235909079040, '2021-09-23 09:38:25.664072', 356948235909079040, '2021-09-23 09:38:25.664072', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472364111722389504, 'oms-order-db-upload-suppflag', '上传发货信息（一件代发）', 1, 102002001, '/102/102002/102002001/', NULL, 0, '/order/salDo/importOrderList1', 'POST', NULL, NULL, 356948235909079040, '2021-09-23 09:39:18.144692', 356948235909079040, '2021-09-23 09:39:18.144692', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472364175874269184, 'oms-order-db-export-bill', '导出待发货信息', 1, 102002001, '/102/102002/102002001/', NULL, 0, '/order/salSoAlloc/export', 'POST', NULL, NULL, 356948235909079040, '2021-09-23 09:39:33.439017', 356948235909079040, '2021-09-23 09:39:33.439017', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472428660823629824, 'oms-order-so-edit-altype', '修改一件代发', 1, 102001004, '/102/102001/102001004/', NULL, 0, '/order/salSo/updateSuppFlag', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 13:55:47.849288', 458747224501436416, '2021-09-23 13:55:47.849288', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472428715345387520, 'oms-order-so-cancel-qty', '取消部分数量', 1, 102001004, '/102/102001/102001004/', NULL, 0, '/order/salSo/cancelPartQty', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 13:56:00.848950', 458747224501436416, '2021-09-23 13:56:00.848950', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472428773616852992, 'oms-order-so-close-sod', '关闭订单行', 1, 102001004, '/102/102001/102001004/', NULL, 0, '/order/salSo/closeSalSoD', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 13:56:14.741328', 458747224501436416, '2021-09-23 13:56:14.741328', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472428903388618752, 'oms-order-gro-edit-altype', '修改一件代发', 1, 102003003, '/102/102003/102003003/', NULL, 0, '/order/salSo/updateSuppFlag', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 13:56:45.681246', 458747224501436416, '2021-09-23 13:56:45.681246', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472429003531821056, 'oms-order-ct-edit-altype', '修改一件代发', 1, 450675719851139072, '/102/450675135555231744/450675719851139072/', NULL, 0, '/order/salSo/updateSuppFlag', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 13:57:09.557798', 458747224501436416, '2021-09-23 13:57:09.557798', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472429359477235712, 'oms-cardOrderManage-orderQueryCardOrder-create', '购物卡订单新建', 0, 470286068610605056, '/102/470286068610605056/', NULL, 0, '/order/cardOrderManage/orderQuery/cardOrder/create', NULL, NULL, NULL, 458747224501436416, '2021-09-23 13:58:34.421188', 458747224501436416, '2021-09-23 13:58:34.421188', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472429436165890048, 'oms-cardOrderManage-orderQueryCardOrder-edit', '购物卡订单编辑', 0, 470286068610605056, '/102/470286068610605056/', NULL, 0, '/order/cardOrderManage/orderQuery/cardOrder/edit/:id', NULL, NULL, NULL, 458747224501436416, '2021-09-23 13:58:52.705617', 458747224501436416, '2021-09-23 13:58:52.705617', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472429614063099904, 'oms-cardOrderManage-orderQueryCardOrder-view', '购物卡订单详情', 0, 470286068610605056, '/102/470286068610605056/', NULL, 0, '/order/cardOrderManage/orderQuery/cardOrder/view/:id', NULL, NULL, NULL, 458747224501436416, '2021-09-23 13:59:35.119384', 458747224501436416, '2021-09-23 13:59:35.119384', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472429698272141312, 'oms-order-sale-save', '保存', 1, 472429359477235712, '/102/470286068610605056/472429359477235712/', NULL, 0, '/order/salSo/save', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 13:59:55.196472', 458747224501436416, '2021-09-23 13:59:55.196472', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472429766161145856, 'oms-order-sale-submit', '提交', 1, 472429359477235712, '/102/470286068610605056/472429359477235712/', NULL, 0, '/order/salSo/submit', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:00:11.382083', 458747224501436416, '2021-09-23 14:00:11.382083', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472429893856731136, 'oms-order-sale-del-item', '删除商品', 1, 472429359477235712, '/102/470286068610605056/472429359477235712/', NULL, 0, '/order/salSo/deleteSalsod', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:00:41.827444', 458747224501436416, '2021-09-23 14:00:41.827444', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472430021887860736, 'oms-order-sale-hand-atc', '激活购物卡', 1, 472429359477235712, '/102/470286068610605056/472429359477235712/', NULL, 0, '/order/salSo/cardActive/', 'GET', NULL, NULL, 458747224501436416, '2021-09-23 14:01:12.352867', 458747224501436416, '2021-09-23 14:01:12.352867', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472430074656399360, 'oms-order-sale-corder-import', '导入', 1, 472429359477235712, '/102/470286068610605056/472429359477235712/', NULL, 0, '/order/salSo/saveSalSoCard', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:01:24.933909', 458747224501436416, '2021-09-23 14:01:24.933909', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472430160421527552, 'oms-order-sale-del-item', '删除商品', 1, 472429436165890048, '/102/470286068610605056/472429436165890048/', NULL, 0, '删除商品', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:01:45.381658', 458747224501436416, '2021-09-23 14:01:45.381658', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472430222862131200, 'oms-order-sale-save', '保存', 1, 472429436165890048, '/102/470286068610605056/472429436165890048/', NULL, 0, '/order/salSo/save', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:02:00.268721', 458747224501436416, '2021-09-23 14:02:00.268721', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472430284891693056, 'oms-order-sale-submit', '提交', 1, 472429436165890048, '/102/470286068610605056/472429436165890048/', NULL, 0, '/order/salSo/submit', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:02:15.057172', 458747224501436416, '2021-09-23 14:02:15.057172', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472430349748215808, 'oms-order-sale-hand-atc', '激活购物卡', 1, 472429436165890048, '/102/470286068610605056/472429436165890048/', NULL, 0, '/order/salSo/cardActive/', 'GET', NULL, NULL, 458747224501436416, '2021-09-23 14:02:30.520973', 458747224501436416, '2021-09-23 14:02:30.520973', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472430412281094144, 'oms-order-sale-corder-import', '导入', 1, 472429436165890048, '/102/470286068610605056/472429436165890048/', NULL, 0, '/order/salSo/saveSalSoCard', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:02:45.429482', 458747224501436416, '2021-09-23 14:02:45.429482', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472430500021739520, 'oms-order-sale-corder-approve', '批准', 1, 472429614063099904, '/102/470286068610605056/472429614063099904/', NULL, 0, '/order/salSo/cardOrderApprove', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:03:06.348569', 458747224501436416, '2021-09-23 14:03:06.348569', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472430565331247104, 'oms-order-sale-corder-reject', '拒绝', 1, 472429614063099904, '/102/470286068610605056/472429614063099904/', NULL, 0, '/order/salSo/cardOrderReject', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:03:21.919949', 458747224501436416, '2021-09-23 14:03:21.919949', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472430627943817216, 'oms-order-gro-edit-altype', '修改一件代发', 1, 472429614063099904, '/102/470286068610605056/472429614063099904/', NULL, 0, '/order/salSo/updateSuppFlag', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:03:36.847271', 458747224501436416, '2021-09-23 14:03:36.847271', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472432999000645632, 'oms-order-salelist-query', '查询', 1, 470286189586915328, '/102/470286068610605056/470286189586915328/', NULL, 0, '/order/salSo/query', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:13:02.151320', 458747224501436416, '2021-09-23 14:13:02.151320', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472433051756601344, 'oms-order-salelist-cancel', '取消', 1, 470286189586915328, '/102/470286068610605056/470286189586915328/', NULL, 0, '/order/salSo/calcelSalSo', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:13:14.729568', 458747224501436416, '2021-09-23 14:13:14.729568', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472433104248315904, 'oms-order-salelist-close', '关闭', 1, 470286189586915328, '/102/470286068610605056/470286189586915328/', NULL, 0, '/order/salSo/closeSalSo', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:13:27.244272', 458747224501436416, '2021-09-23 14:13:27.244272', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472433161999687680, 'oms-order-salelist-audit-pending', '暂挂', 1, 470286189586915328, '/102/470286068610605056/470286189586915328/', NULL, 0, '/order/salSoHold/artificialHold', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:13:41.013607', 458747224501436416, '2021-09-23 14:13:41.013607', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472433213908393984, 'oms-order-salelist-export', '导出', 1, 470286189586915328, '/102/470286068610605056/470286189586915328/', NULL, 0, '/order/salSo/export', 'POST', NULL, NULL, 458747224501436416, '2021-09-23 14:13:53.389337', 458747224501436416, '2021-09-23 14:13:53.389337', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472433253733310464, 'oms-order-salelist-related-order', '相关发货订单', 1, 470286189586915328, '/102/470286068610605056/470286189586915328/', NULL, 0, '/', NULL, NULL, NULL, 458747224501436416, '2021-09-23 14:14:02.884934', 458747224501436416, '2021-09-23 14:14:02.884934', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472433290706100224, 'oms-order-salelist-pending-query', '暂挂查询', 1, 470286189586915328, '/102/470286068610605056/470286189586915328/', NULL, 0, '/', NULL, NULL, NULL, 458747224501436416, '2021-09-23 14:14:11.699585', 458747224501436416, '2021-09-23 14:14:11.699585', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472433327813107712, 'oms-order-salelist-card-create', '创建', 1, 470286189586915328, '/102/470286068610605056/470286189586915328/', NULL, 0, '/', NULL, NULL, NULL, 458747224501436416, '2021-09-23 14:14:20.546496', 458747224501436416, '2021-09-23 14:14:20.546496', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472433363418554368, 'oms-order-salelist-card-edit', '编辑', 1, 470286189586915328, '/102/470286068610605056/470286189586915328/', NULL, 0, '/', NULL, NULL, NULL, 458747224501436416, '2021-09-23 14:14:29.035301', 458747224501436416, '2021-09-23 14:14:29.035301', 0, NULL, 'cyt', 'cyt', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472728712867684352, 'oms-order-sale-select-sod', '选择原单明细', 1, 102001005, '/102/102001/102001005/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-09-24 09:48:05.831329', 356948235909079040, '2021-09-24 09:48:05.831329', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472728904027283456, 'oms-order-sale-del-item', '删除商品', 1, 102001005, '/102/102001/102001005/', NULL, 0, '/order/salSo/deleteSalsod', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 09:48:51.407709', 356948235909079040, '2021-09-24 09:48:51.407709', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472729025695653888, 'oms-order-sale-del-alloc', '删除配货信息', 1, 102001005, '/102/102001/102001005/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-09-24 09:49:20.415177', 356948235909079040, '2021-09-24 09:49:20.415177', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472729085791641600, 'oms-order-sale-auto-alloc', '自动配货', 1, 102001005, '/102/102001/102001005/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 09:49:34.743271', 356948235909079040, '2021-09-24 09:49:34.743271', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472729155303841792, 'oms-order-sale-hand-alloc', '手工配货', 1, 102001005, '/102/102001/102001005/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 09:49:51.316022', 356948235909079040, '2021-09-24 09:49:51.316022', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472729240813117440, 'oms-order-sale-submit', '提交', 1, 102001005, '/102/102001/102001005/', NULL, 0, '/order/salSo/submit', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 09:50:11.703222', 356948235909079040, '2021-09-24 10:24:01.977956', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472729293422272512, 'oms-order-sale-save', '保存', 1, 102001005, '/102/102001/102001005/', NULL, 0, '/order/salSo/save', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 09:50:24.245995', 356948235909079040, '2021-09-24 09:50:24.245995', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472729496002961408, 'oms-saleOrderManage-orderQueryTradeOrder-edit', '贸易订单编辑', 0, 102001, '/102/102001/', NULL, 0, '/order/saleOrderManage/orderQuery/tradeOrder/edit/:id', NULL, NULL, NULL, 356948235909079040, '2021-09-24 09:51:12.545101', 356948235909079040, '2021-09-24 09:51:12.545101', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472729797061713920, 'oms-saleOrderManage-orderQueryTradeOrder-view', '贸易订单详情', 0, 102001, '/102/102001/', NULL, 0, '/order/saleOrderManage/orderQuery/tradeOrder/view/:id', NULL, NULL, NULL, 356948235909079040, '2021-09-24 09:52:24.323813', 356948235909079040, '2021-09-24 09:52:24.323813', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472730315381219328, 'oms-order-sale-del-item', '删除商品', 1, 472729496002961408, '/102/102001/472729496002961408/', NULL, 0, '/order/salSo/deleteSalsod', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 09:54:27.900445', 356948235909079040, '2021-09-24 09:54:27.900445', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472735283463004160, 'oms-order-sale-del-alloc', '删除配货信息', 1, 472729496002961408, '/102/102001/472729496002961408/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-09-24 10:14:12.383522', 356948235909079040, '2021-09-24 10:14:12.383522', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472735343366053888, 'oms-order-sale-hand-alloc', '手工配货', 1, 472729496002961408, '/102/102001/472729496002961408/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 10:14:26.665038', 356948235909079040, '2021-09-24 10:14:26.665038', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472735418460872704, 'oms-order-sale-auto-alloc', '自动配货', 1, 472729496002961408, '/102/102001/472729496002961408/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 10:14:44.569604', 356948235909079040, '2021-09-24 10:14:44.569604', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472735475620847616, 'oms-order-sale-save', '保存', 1, 472729496002961408, '/102/102001/472729496002961408/', NULL, 0, '/order/salSo/save', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 10:14:58.197206', 356948235909079040, '2021-09-24 10:14:58.197206', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472735526065741824, 'oms-order-sale-submit', '提交', 1, 472729496002961408, '/102/102001/472729496002961408/', NULL, 0, '/order/salSo/submit', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 10:15:10.224944', 356948235909079040, '2021-09-24 10:15:10.224944', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472736434170306560, 'oms-order-sale-hand-alloc', '手工配货', 1, 472729797061713920, '/102/102001/472729797061713920/', NULL, 0, '/order/salSoAlloc/createList', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 10:18:46.733606', 356948235909079040, '2021-09-24 10:18:46.733606', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472736527199969280, 'oms-order-sale-auto-alloc', '自动配货', 1, 472729797061713920, '/102/102001/472729797061713920/', NULL, 0, '/order/salSoAlloc/autoAlloc', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 10:19:08.913931', 356948235909079040, '2021-09-24 10:19:08.913931', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472736616693833728, 'oms-order-sale-del-alloc', '删除配货信息', 1, 472729797061713920, '/102/102001/472729797061713920/', NULL, 0, '/order/salSoAlloc/deleteBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-09-24 10:19:30.250211', 356948235909079040, '2021-09-24 10:19:30.250211', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472736676055818240, 'oms-order-so-edit-altype', '修改一件代发', 1, 472729797061713920, '/102/102001/472729797061713920/', NULL, 0, '/order/salSo/updateSuppFlag', 'POST', NULL, NULL, 356948235909079040, '2021-09-24 10:19:44.403260', 356948235909079040, '2021-09-24 10:19:44.403260', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472748346169827328, 'oms-order-so-edit-altype', '修改一件代发', 1, 466354582689738752, '/102/102001/466354582689738752/', NULL, 0, '/order/salSo/updateSuppFlag', 'POST', NULL, NULL, 0, '2021-09-24 11:06:06.775510', 0, '2021-09-24 11:06:06.775510', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472748412397887488, 'oms-order-so-cancel-qty', '取消部分数量', 1, 466354582689738752, '/102/102001/466354582689738752/', NULL, 0, '/order/salSo/cancelPartQty', 'POST', NULL, NULL, 0, '2021-09-24 11:06:22.565268', 0, '2021-09-24 11:06:22.565268', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (472748478961491968, 'oms-order-so-close-sod', '关闭订单行', 1, 466354582689738752, '/102/102001/466354582689738752/', NULL, 0, '/order/salSo/closeSalSoD', 'POST', NULL, NULL, 0, '2021-09-24 11:06:38.435560', 0, '2021-09-24 11:06:38.435560', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (473526278601437184, 'support-orgCenter-administrativeArea-list', '行政区划', 0, 108003, '/108/108003/', NULL, 0, '/orgCenter/administrativeArea/list', NULL, NULL, NULL, 356948235909079040, '2021-09-26 14:37:20.320009', 356948235909079040, '2021-09-26 14:37:20.320009', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (473526646609670144, 'sup-org-area-add', '新建', 1, 473526278601437184, '/108/108003/473526278601437184/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-09-26 14:38:48.060590', 356948235909079040, '2021-09-26 14:38:48.060590', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (473575082247479296, 'sup-org-area-edit', '编辑', 1, 473526278601437184, '/108/108003/473526278601437184/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-09-26 17:51:16.016801', 356948235909079040, '2021-09-26 17:51:16.016801', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (473899499393540096, 'fin-inv-ped-confirm', '确定', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/cancel', 'PUT', NULL, NULL, 356948235909079040, '2021-09-27 15:20:23.090959', 356948235909079040, '2021-09-29 14:17:28.239262', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (473899606423789568, 'fin-inv-ped-reject', '开票拒绝', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/approve', 'POST', NULL, NULL, 356948235909079040, '2021-09-27 15:20:48.609278', 356948235909079040, '2021-09-27 15:20:48.609278', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (473899671892680704, 'fin-inv-ped-red', '红冲', 1, 469458109951672320, '/112/469457639266877440/469458109951672320/', NULL, 0, '/inv/awaitCust/red/id', 'PUT', NULL, NULL, 356948235909079040, '2021-09-27 15:21:04.218498', 356948235909079040, '2021-09-27 15:21:04.218498', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (474671236976631808, 'oms-order-db-save', '保存', 1, 102002004, '/102/102002/102002004/', NULL, 0, '/order/salDo/saveOne', 'POST', NULL, NULL, 356948235909079040, '2021-09-29 18:26:59.669296', 356948235909079040, '2021-09-29 18:26:59.669296', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (474671288189083648, 'oms-order-db-confirm', '确认', 1, 102002004, '/102/102002/102002004/', NULL, 0, '/order/salDo/confirmOne', 'POST', NULL, NULL, 356948235909079040, '2021-09-29 18:27:11.879007', 356948235909079040, '2021-09-29 18:27:11.879007', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (474671324260098048, 'oms-order-db-del', '删除', 1, 102002004, '/102/102002/102002004/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-09-29 18:27:20.479828', 356948235909079040, '2021-09-29 18:27:20.479828', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (478939820464902144, 'mg-pur-form-export', '导出', 1, 104008008, '/104/104008/104008008/', NULL, 0, '/yst-pur/pur/inv/downloadAllData', 'POST', NULL, NULL, 356948235909079040, '2021-10-11 13:08:49.279669', 356948235909079040, '2021-10-11 13:08:49.279669', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479632846140940288, 'oms-order-sale-sod-import', '导入', 1, 102001003, '/102/102001/102001003/', NULL, 0, '/order/salSo/salSoDetailImport', 'POST', NULL, NULL, 356948235909079040, '2021-10-13 11:02:39.476600', 356948235909079040, '2021-10-13 11:05:40.878903', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479633528227045376, 'oms-order-sale-sod-import', '导入', 1, 102001002, '/102/102001/102001002/', NULL, 0, '/order/salSo/salSoDetailImport', 'POST', NULL, NULL, 356948235909079040, '2021-10-13 11:05:22.098357', 356948235909079040, '2021-10-13 11:05:29.786283', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479634184518180864, 'oms-order-salelist-copy', '复制', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-13 11:07:58.570648', 356948235909079040, '2021-10-13 11:07:58.570648', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479634774459621376, 'oms-order-salelist-regOrder-import', '常规订单导入', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-13 11:10:19.222721', 356948235909079040, '2021-10-13 11:10:19.222721', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479634950410674176, 'oms-order-salelist-trade-create', '贸易订单新建', 1, 102001001, '/102/102001/102001001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-13 11:11:01.173355', 356948235909079040, '2021-10-13 11:11:01.173355', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479646178931580928, 'b2b-credit-rv-return-ct', '预收款退款', 1, 114002005, '/114/114002/114002005/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-13 11:55:38.261953', 356948235909079040, '2021-10-13 11:55:38.261953', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479970260319412224, 'sup-item-list-edit', '变更', 1, 106004001, '/106/106004/106004001/', NULL, 0, '/', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:23:25.285693', 464821658974744576, '2021-10-14 09:23:25.285693', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479970485301878784, 'sup-item-list-submit-publish', '发布', 1, 106004001, '/106/106004/106004001/', NULL, 0, '/itm/item/spu/publish', 'POST', NULL, NULL, 464821658974744576, '2021-10-14 09:24:18.925285', 464821658974744576, '2021-10-14 09:24:18.925285', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479971055530090496, 'support-itemCenter-audit', '商品审核', 0, 106, '/106/', NULL, 0, '/itemCenter/audit', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:26:34.878124', 464821658974744576, '2021-10-14 09:26:34.878124', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479972604771770368, 'support-itemCenter-item-apply-list', '商品申请列表', 0, 479971055530090496, '/106/479971055530090496/', NULL, 0, '/itemCenter/itemApply/list', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:32:44.246183', 464821658974744576, '2021-10-14 09:32:44.246183', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479974650296082432, 'sup-itemApply-list-query', '查询', 1, 479972604771770368, '/106/479971055530090496/479972604771770368/', NULL, 0, '/itm/item-apply/spu/list', 'POST', NULL, NULL, 464821658974744576, '2021-10-14 09:40:51.937711', 464821658974744576, '2021-10-14 09:40:51.937711', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479974762468548608, 'sup-itemApply-list-create', '新增', 1, 479972604771770368, '/106/479971055530090496/479972604771770368/', NULL, 0, '/', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:41:18.681186', 464821658974744576, '2021-10-14 09:41:18.681186', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479974879800008704, 'sup-itemApply-list-item-import', '导入', 1, 479972604771770368, '/106/479971055530090496/479972604771770368/', NULL, 0, '/', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:41:46.655046', 464821658974744576, '2021-10-14 09:41:46.655046', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479975009043292160, 'sup-itemApply-list-edit', '编辑', 1, 479972604771770368, '/106/479971055530090496/479972604771770368/', NULL, 0, '/', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:42:17.469768', 464821658974744576, '2021-10-14 09:42:17.469768', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479975257488695296, 'sup-itemApply-list-del', '删除', 1, 479972604771770368, '/106/479971055530090496/479972604771770368/', NULL, 0, '/itm/item-apply/delete/batch', 'POST', NULL, NULL, 464821658974744576, '2021-10-14 09:43:16.703408', 464821658974744576, '2021-10-14 09:43:16.703408', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479975393845518336, 'sup-itemApply-list-submit-audit', '提交审核', 1, 479972604771770368, '/106/479971055530090496/479972604771770368/', NULL, 0, '/', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:43:49.213265', 464821658974744576, '2021-10-14 09:43:49.213265', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479975643561795584, 'support-itemCenter-itemApply-create', '填写商品信息', 0, 479971055530090496, '/106/479971055530090496/', NULL, 0, '/itemCenter/itemApply/add/:type/:id', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:44:48.750116', 464821658974744576, '2021-10-14 09:44:48.750116', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479976329217253376, 'support-itemCenter-itemApply-edit', '编辑商品信息', 0, 479971055530090496, '/106/479971055530090496/', NULL, 0, '/itemCenter/itemApply/detail/:type/:id/:docNo', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:47:32.223883', 464821658974744576, '2021-10-14 09:47:32.223883', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479976637825753088, 'support-itemCenter-itemApply-view', '商品详情', 0, 479971055530090496, '/106/479971055530090496/', NULL, 0, '/itemCenter/itemApply/view/:type/:id/:docNo', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:48:45.801834', 464821658974744576, '2021-10-14 09:48:45.801834', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479976879291834368, 'support-itemCenter-audit-list', '商品审核查询', 0, 479971055530090496, '/106/479971055530090496/', NULL, 0, '/itemCenter/audit/list', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:49:43.371983', 464821658974744576, '2021-10-14 09:49:43.371983', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479977235912531968, 'sup-item-audit-list-edit', '编辑', 1, 479976879291834368, '/106/479971055530090496/479976879291834368/', NULL, 0, '/', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:51:08.396171', 464821658974744576, '2021-10-14 09:51:08.396171', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479977387209465856, 'sup-item-audit-list-invalid', '作废', 1, 479976879291834368, '/106/479971055530090496/479976879291834368/', NULL, 0, '/itm/approve/details/void/{docNo}', 'GET', NULL, NULL, 464821658974744576, '2021-10-14 09:51:44.468713', 464821658974744576, '2021-10-14 09:51:44.468713', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479977550770544640, 'support-itemCenter-audit-view', '商品审核详情', 0, 479971055530090496, '/106/479971055530090496/', NULL, 0, '/itemCenter/audit/view/:type/:id', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:52:23.464542', 464821658974744576, '2021-10-14 09:52:23.464542', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479977788285591552, 'support-itemCenter-audit-edit', '商品审核编辑', 0, 479971055530090496, '/106/479971055530090496/', NULL, 0, '/itemCenter/audit/edit/:type/:id', NULL, NULL, NULL, 464821658974744576, '2021-10-14 09:53:20.092117', 464821658974744576, '2021-10-14 09:53:20.092117', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479991083646365696, 'support-itemCenter-infoMaintenance', '商品段信息维护', 0, 106, '/106/', NULL, 0, '/itemCenter/infoMaintenance', NULL, NULL, NULL, 464821658974744576, '2021-10-14 10:46:09.953259', 464821658974744576, '2021-10-14 10:46:09.953259', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479992136617996288, 'support-itemCenter-infoMaintenance-list', '商品段信息维护', 0, 479991083646365696, '/106/479991083646365696/', NULL, 0, '/itemCenter/infoMaintenance/List', NULL, NULL, NULL, 464821658974744576, '2021-10-14 10:50:21.000138', 464821658974744576, '2021-10-14 10:50:21.000138', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479992788668690432, 'sup-item-infoMaintenance-edit', '编辑', 1, 479992136617996288, '/106/479991083646365696/479992136617996288/', NULL, 0, '/', NULL, NULL, NULL, 464821658974744576, '2021-10-14 10:52:56.462064', 464821658974744576, '2021-10-14 10:52:56.462064', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479993296896700416, 'support-itemCenter-infoMaintenance-edit', '商品段信息编辑', 0, 479991083646365696, '/106/479991083646365696/', NULL, 0, '/itemCenter/infoMaintenance/Edit', NULL, NULL, NULL, 464821658974744576, '2021-10-14 10:54:57.633532', 464821658974744576, '2021-10-14 10:54:57.633532', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (479995919590797312, 'sup-item-infoMaintenance-query', '查询', 1, 479992136617996288, '/106/479991083646365696/479992136617996288/', NULL, 0, '/itm/segment/list', 'POST', NULL, NULL, 464821658974744576, '2021-10-14 11:05:22.932938', 464821658974744576, '2021-10-14 11:05:22.932938', 0, NULL, 'zhangyang', 'zhangyang', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (482225915436945408, 'oms-workOrder', '工单类订单管理', 0, 102, '/102/', NULL, 0, '/order/workOrder', NULL, NULL, NULL, 356948235909079040, '2021-10-20 14:46:35.373784', 356948235909079040, '2021-10-20 14:46:35.373784', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (482226366601449472, 'oms-workOrder-list', '工单类订单列表', 0, 482225915436945408, '/102/482225915436945408/', NULL, 0, '/order/workOrder/list', NULL, NULL, NULL, 356948235909079040, '2021-10-20 14:48:22.938584', 356948235909079040, '2021-10-20 14:48:22.938584', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (482226524038844416, 'oms-order-workList-query', '查询', 1, 482226366601449472, '/102/482225915436945408/482226366601449472/', NULL, 0, '/order/salSo/query', 'POST', NULL, NULL, 356948235909079040, '2021-10-20 14:49:00.475612', 356948235909079040, '2021-10-20 14:49:00.475612', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (482226593337135104, 'oms-order-workList-export', '导出', 1, 482226366601449472, '/102/482225915436945408/482226366601449472/', NULL, 0, '/order/salSo/twExport', 'POST', NULL, NULL, 356948235909079040, '2021-10-20 14:49:16.997418', 356948235909079040, '2021-10-20 14:49:16.997418', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484052761782841344, 'b2bShop', 'B2B商城管理', 0, 0, '/', NULL, 0, '/b2bShop', NULL, NULL, NULL, 356948235909079040, '2021-10-25 15:45:49.483409', 356948235909079040, '2021-10-25 15:45:49.483409', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484052928393179136, 'b2b-itemManagement', '商品管理', 0, 484052761782841344, '/484052761782841344/', NULL, 0, '/shop/ItemManagement', NULL, NULL, NULL, 356948235909079040, '2021-10-25 15:46:29.206896', 356948235909079040, '2021-10-25 15:46:29.206896', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484053058848616448, 'shop-itemManagement-categoryList', '商品分类', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/Category', NULL, NULL, NULL, 356948235909079040, '2021-10-25 15:47:00.309553', 356948235909079040, '2021-10-25 15:47:00.309553', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484053141480599552, 'shop-itemManagement-stayItemList', '待上架商品列表', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/stayItemList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 15:47:20.009021', 356948235909079040, '2021-10-25 15:47:20.009021', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484053244710809600, 'shop-itemManagement-AuthItemList', '商品上下架审核', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/AuthItemList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 15:47:44.622279', 356948235909079040, '2021-10-25 15:48:07.337267', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484053444175130624, 'shop-itemManagement-onLineItemList', '已上架商品列表', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/onLineItemList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 15:48:32.178176', 356948235909079040, '2021-10-25 15:48:32.178176', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484053651759624192, 'shop-itemManagement-offLineItemList', '已下架商品列表', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/offLineItemList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 15:49:21.670347', 356948235909079040, '2021-10-25 15:49:21.670347', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484054442012635136, 'b2b-shop-Category-add', '新增同级分类', 1, 484053058848616448, '/484052761782841344/484052928393179136/484053058848616448/', NULL, 0, '/yst-support/org/emp/user/current', 'GET', NULL, NULL, 356948235909079040, '2021-10-25 15:52:30.081210', 356948235909079040, '2021-10-25 15:52:30.081210', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484054672997150720, 'b2b-shop-Category-secondadd', '新增子分类', 1, 484053058848616448, '/484052761782841344/484052928393179136/484053058848616448/', NULL, 0, '/yst-support/org/emp/user/current', 'GET', NULL, NULL, 356948235909079040, '2021-10-25 15:53:25.152717', 356948235909079040, '2021-10-25 15:53:25.152717', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484054829620850688, 'b2b-shop-Category-edit', '编辑', 1, 484053058848616448, '/484052761782841344/484052928393179136/484053058848616448/', NULL, 0, '/bip/itemCat/{ids}/', 'GET', NULL, NULL, 356948235909079040, '2021-10-25 15:54:02.494113', 356948235909079040, '2021-10-25 15:54:02.494113', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484054924789608448, 'b2b-shop-Category-delete', '删除', 1, 484053058848616448, '/484052761782841344/484052928393179136/484053058848616448/', NULL, 0, '/bip/itemCat/{ids}/', 'DELETE', NULL, NULL, 356948235909079040, '2021-10-25 15:54:25.184323', 356948235909079040, '2021-10-25 15:54:25.184323', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484055123939356672, 'b2b-shop-Category-Enable', '启用', 1, 484053058848616448, '/484052761782841344/484052928393179136/484053058848616448/', NULL, 0, '/bip/itemCat/{ids}/', 'PATCH', NULL, NULL, 356948235909079040, '2021-10-25 15:55:12.665278', 356948235909079040, '2021-10-25 15:55:12.665278', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484055256940736512, 'b2b-shop-stayItemList-timingPut', '批量定时上架', 1, 484053141480599552, '/484052761782841344/484052928393179136/484053141480599552/', NULL, 0, '/bip/item/batch/onShelf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 15:55:44.375893', 356948235909079040, '2021-12-29 11:45:45.357471', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484055340545798144, 'b2b-shop-Category-search', '查询', 1, 484053058848616448, '/484052761782841344/484052928393179136/484053058848616448/', NULL, 0, '/bip/itemCat/tree/{ids}/', 'GET', NULL, NULL, 356948235909079040, '2021-10-25 15:56:04.308818', 356948235909079040, '2021-10-25 15:56:20.410241', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484055556258852864, 'b2b-shop-stayItemList-search', '查询', 1, 484053141480599552, '/484052761782841344/484052928393179136/484053141480599552/', NULL, 0, '/bip/item/search/toShelf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 15:56:55.738342', 356948235909079040, '2021-10-25 15:56:55.738342', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484055654950825984, 'b2b-shop-stayItemList-immediatelyPut', '批量立即上架', 1, 484053141480599552, '/484052761782841344/484052928393179136/484053141480599552/', NULL, 0, '/bip/item/batch/onShelf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 15:57:19.268001', 356948235909079040, '2021-12-29 11:45:34.413438', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484055992495828992, 'b2b-shop-stayItemList-edit', '编辑', 1, 484053141480599552, '/484052761782841344/484052928393179136/484053141480599552/', NULL, 0, '/bip/item/{id}', 'GET', NULL, NULL, 356948235909079040, '2021-10-25 15:58:39.745106', 356948235909079040, '2021-12-29 11:45:22.815913', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484056060783292416, 'b2b-shop-stayItemList-delete', '删除', 1, 484053141480599552, '/484052761782841344/484052928393179136/484053141480599552/', NULL, 0, '/bip/item/batch', 'DELETE', NULL, NULL, 356948235909079040, '2021-10-25 15:58:56.026699', 356948235909079040, '2021-12-29 11:45:15.757885', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484056178500628480, 'b2b-shop-stayItemList-add', '新增商品', 1, 484053141480599552, '/484052761782841344/484052928393179136/484053141480599552/', NULL, 0, 'bip/item', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 15:59:24.092766', 356948235909079040, '2021-10-25 15:59:24.092766', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484056285115641856, 'b2b-shop-AuthItemList-search', '查询', 1, 484053244710809600, '/484052761782841344/484052928393179136/484053244710809600/', NULL, 0, '/bip/item/search/toApprove', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 15:59:49.511883', 356948235909079040, '2021-10-25 15:59:49.511883', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484056385481142272, 'b2b-shop-AuthItemList-adopt', '审核通过', 1, 484053244710809600, '/484052761782841344/484052928393179136/484053244710809600/', NULL, 0, 'bip/item/approve', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:00:13.440223', 356948235909079040, '2021-10-25 16:00:13.440223', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484056452770361344, 'b2b-shop-AuthItemList-refuse', '审核拒绝', 1, 484053244710809600, '/484052761782841344/484052928393179136/484053244710809600/', NULL, 0, 'bip/item/approve', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:00:29.483182', 356948235909079040, '2021-10-25 16:00:29.483182', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484056584203071488, 'b2b-shop-onLineItemList-search', '查询', 1, 484053444175130624, '/484052761782841344/484052928393179136/484053444175130624/', NULL, 0, '/bip/item/search/onShelf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:01:00.819803', 356948235909079040, '2021-10-25 16:01:00.819803', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484056662124851200, 'b2b-shop-onLineItemList-timingOff', '批量定时下架', 1, 484053444175130624, '/484052761782841344/484052928393179136/484053444175130624/', NULL, 0, '/bip/item/timing/offShelf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:01:19.397546', 356948235909079040, '2021-10-25 16:01:38.069966', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484056845260746752, 'b2b-shop-onLineItemList-immediatelyOff', '批量立即下架', 1, 484053444175130624, '/484052761782841344/484052928393179136/484053444175130624/', NULL, 0, '/bip/item/batch/offShelf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:02:03.060359', 356948235909079040, '2021-10-25 16:02:03.060359', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484056917356638208, 'b2b-shop-onLineItemList-adjustment', '库存调整', 1, 484053444175130624, '/484052761782841344/484052928393179136/484053444175130624/', NULL, 0, '/bip/item/{id}/stock', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:02:20.249904', 356948235909079040, '2021-12-29 11:50:26.086271', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484057017042661376, 'b2b-shop-offLineItemList-search', '查询', 1, 484053651759624192, '/484052761782841344/484052928393179136/484053651759624192/', NULL, 0, '/bip/item/search/offShelf', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 16:02:44.016508', 356948235909079040, '2021-10-25 16:02:44.016508', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484057127906504704, 'b2b-shop-offLineItemList-timingPut', '批量定时上架', 1, 484053651759624192, '/484052761782841344/484052928393179136/484053651759624192/', NULL, 0, '/bip/item/timing/onShelf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:03:10.448702', 356948235909079040, '2021-10-25 16:03:10.448702', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484057226778832896, 'b2b-shop-offLineItemList-immediatelyPut', '批量立即上架', 1, 484053651759624192, '/484052761782841344/484052928393179136/484053651759624192/', NULL, 0, '/bip/item/batch/onShelf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:03:34.021685', 356948235909079040, '2021-10-25 16:03:46.738935', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484057381322158080, 'b2b-shop-offLineItemList-edit', '编辑', 1, 484053651759624192, '/484052761782841344/484052928393179136/484053651759624192/', NULL, 0, '/bip/item/{id}/', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 16:04:10.867764', 356948235909079040, '2021-10-25 16:04:10.867764', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484059763611332608, 'fin-pur-re-order-confirm', '订单对账', 1, 112004001, '/112/112004/112004001/', NULL, 0, 'sal/receiveSettle/orderCheck', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:13:38.849292', 356948235909079040, '2021-10-25 16:13:38.849292', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484062433461989376, 'financeSalesBillCheck', '销售账单核对', 0, 112004, '/112/112004/', NULL, 0, '/finance/sales/BillCheck', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:24:15.391700', 356948235909079040, '2021-10-25 16:24:15.391700', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484063606080335872, 'fin-wd-reject', '驳回', 1, 112005002, '/112/112005/112005002/', NULL, 0, '/fin/wdmApply/overrule', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:28:54.965908', 356948235909079040, '2021-10-25 16:28:54.965908', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484063953372901376, 'fin-wd-query', '查询', 1, 112005002, '/112/112005/112005002/', NULL, 0, '/fin/wdmApply/details', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:30:17.766318', 356948235909079040, '2021-10-25 16:30:17.766318', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484064118116773888, 'fin-wd-export', '导出', 1, 112005002, '/112/112005/112005002/', NULL, 0, '/fin/wdmApply/exportWorkFlow', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:30:57.044578', 356948235909079040, '2021-10-25 16:30:57.044578', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484066209560326144, 'fin-sal-vt-query', '查询销售订单', 1, 484062433461989376, '/112/112004/484062433461989376/', NULL, 0, '/fin/salSettleCheck/list', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:39:15.683674', 356948235909079040, '2021-10-25 16:39:15.683674', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484066428150673408, 'fin-back-vt-query', '查询银行流水', 1, 484062433461989376, '/112/112004/484062433461989376/', NULL, 0, '/fin/salSettleCheck/queryByFlowNo', 'GET', NULL, NULL, 356948235909079040, '2021-10-25 16:40:07.799949', 356948235909079040, '2021-10-25 16:40:07.799949', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484066515870347264, 'shop-customerManagement', '客户管理', 0, 484052761782841344, '/484052761782841344/', NULL, 0, '/shop/customerManagement', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:40:28.713026', 356948235909079040, '2021-10-25 16:41:25.572286', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484066640575393792, 'shop-itemManagement-MainMenuMg', '首页菜单管理', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/MainMenuMg', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:40:58.445668', 356948235909079040, '2021-10-25 16:40:58.445668', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484066659844026368, 'fin-sal-vt-confirm', '自动对账', 1, 484062433461989376, '/112/112004/484062433461989376/', NULL, 0, '/fin/salSettleCheck/checkAutomatic', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:41:03.039810', 356948235909079040, '2021-10-25 16:41:03.039810', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484066791247376384, 'fin-sal-force-confirm', '强制对账', 1, 484062433461989376, '/112/112004/484062433461989376/', NULL, 0, '/fin/salSettleCheck/check', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 16:41:34.368775', 356948235909079040, '2021-10-25 16:41:34.368775', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484066913695887360, 'shop-itemManagement-firstSingleZone', '首单专区', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/firstSingleZone/list', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:42:03.562394', 356948235909079040, '2021-10-25 16:42:03.562394', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484066940149362688, 'shop-customerManagement-accountInfoList', '账户信息管理', 0, 484066515870347264, '/484052761782841344/484066515870347264/', NULL, 0, '/shop/customerManagement/accountInfoList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:42:09.869672', 356948235909079040, '2021-10-25 16:42:09.869672', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484067036706435072, 'shop-itemManagement-LogisticsfreighttemplateList', '物流运费模板', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/LogisticsfreighttemplateList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:42:32.890765', 356948235909079040, '2021-10-25 16:42:32.890765', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484067168386609152, 'shop-itemManagement-ZoneSetting', '专区设置', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/ZoneSetting', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:43:04.285953', 356948235909079040, '2021-10-25 16:43:04.285953', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484067168998977536, 'shop-orderManagement', '订单管理', 0, 484052761782841344, '/484052761782841344/', NULL, 0, '/shop/orderManagement', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:43:04.431203', 356948235909079040, '2021-10-25 16:43:04.431203', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484067212762345472, 'fin-sal-cancel-confirm', '撤销对账', 1, 484062433461989376, '/112/112004/484062433461989376/', NULL, 0, '/fin/salSettleCheck/bolt', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 16:43:14.865310', 356948235909079040, '2021-10-25 16:49:59.790512', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484067821334884352, 'b2b-shop-mmslist-search', '查询', 1, 484066640575393792, '/484052761782841344/484052928393179136/484066640575393792/', NULL, 0, '/menu/conf/menuConfPaging', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:45:39.960875', 356948235909079040, '2021-10-25 16:45:39.960875', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484067879384051712, 'shop-orderManagement-project', '订单查询', 0, 484067168998977536, '/484052761782841344/484067168998977536/', NULL, 0, 'shop/orderManagement/project', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:45:53.800366', 356948235909079040, '2021-10-25 16:45:53.800366', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484067906407952384, 'b2b-shop-mmslist-create', '新增菜单', 1, 484066640575393792, '/484052761782841344/484052928393179136/484066640575393792/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:46:00.243174', 356948235909079040, '2021-10-25 16:46:00.243174', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484067970241064960, 'b2b-shop-mmslist-edit', '编辑', 1, 484066640575393792, '/484052761782841344/484052928393179136/484066640575393792/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:46:15.461987', 356948235909079040, '2021-10-25 16:46:15.461987', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068045193277440, 'b2b-shop-mmslist-enable', '启用', 1, 484066640575393792, '/484052761782841344/484052928393179136/484066640575393792/', NULL, 0, '/menu/conf/openMenuConf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:46:33.332901', 356948235909079040, '2021-10-25 16:46:33.332901', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068069205667840, 'shop-customerManagement-feedBackList', '客户意见反馈', 0, 484066515870347264, '/484052761782841344/484066515870347264/', NULL, 0, '/shop/customerManagement/feedBackList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:46:39.057157', 356948235909079040, '2021-10-25 16:46:39.057157', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068125015076864, 'b2b-shop-mmslist-disable', '停用', 1, 484066640575393792, '/484052761782841344/484052928393179136/484066640575393792/', NULL, 0, '/menu/conf/stopMenuConf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:46:52.363192', 356948235909079040, '2021-10-25 16:46:52.363192', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068210507575296, 'b2b-shop-mmslist-del', '删除', 1, 484066640575393792, '/484052761782841344/484052928393179136/484066640575393792/', NULL, 0, '/menu/conf/delMenuConf', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:47:12.746548', 356948235909079040, '2021-10-25 16:47:12.746548', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068237250457600, 'shop-orderManagement-refundOrder', '退款订单', 0, 484067168998977536, '/484052761782841344/484067168998977536/', NULL, 0, '/shop/orderManagement/refundOrder', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:47:19.122782', 356948235909079040, '2021-10-25 16:47:19.122782', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068437218095104, 'b2b-shop-actlist-search', '查询', 1, 484066940149362688, '/484052761782841344/484066515870347264/484066940149362688/', NULL, 0, '/bip/custUserBind/search', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:48:06.798315', 356948235909079040, '2021-10-25 16:48:06.798315', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068476569055232, 'b2b-shop-management-search', '查询', 1, 484067879384051712, '/484052761782841344/484067168998977536/484067879384051712/', NULL, 0, '/bip/order/page/search', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:48:16.180164', 356948235909079040, '2021-10-25 16:48:16.180164', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068607280345088, 'b2b-shop-refundOrder-search', '查询', 1, 484068237250457600, '/484052761782841344/484067168998977536/484068237250457600/', NULL, 0, '/bip/orderBack/page/search', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:48:47.344190', 356948235909079040, '2021-10-25 16:48:47.344190', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068612007325696, 'b2b-shop-actlist-enable', '启用', 1, 484066940149362688, '/484052761782841344/484066515870347264/484066940149362688/', NULL, 0, '/bip/custUserBind/state/{id}/{status}', 'PATCH', NULL, NULL, 356948235909079040, '2021-10-25 16:48:48.471910', 356948235909079040, '2021-10-25 16:48:48.471910', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068671587414016, 'b2b-shop-actlist-disable', '禁用', 1, 484066940149362688, '/484052761782841344/484066515870347264/484066940149362688/', NULL, 0, '/bip/custUserBind/state/{id}/{status}', 'PATCH', NULL, NULL, 356948235909079040, '2021-10-25 16:49:02.676294', 356948235909079040, '2021-10-25 17:51:51.583907', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068720652382208, 'b2b-shop-refundOrder-adopt', '审核通过', 1, 484068237250457600, '/484052761782841344/484067168998977536/484068237250457600/', NULL, 0, '无', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:49:14.374740', 356948235909079040, '2021-10-25 16:49:14.374740', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068743440035840, 'b2b-shop-actlist-approve', '审核通过', 1, 484066940149362688, '/484052761782841344/484066515870347264/484066940149362688/', NULL, 0, '/bip/custUserBind/stateApply/{id}/{status}', 'PATCH', NULL, NULL, 356948235909079040, '2021-10-25 16:49:19.806987', 356948235909079040, '2021-10-25 17:52:02.463163', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068767037190144, 'b2b-shop-fszlist-search', '查询', 1, 484066913695887360, '/484052761782841344/484052928393179136/484066913695887360/', NULL, 0, '/bip/firstspecial/search', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:49:25.433861', 356948235909079040, '2021-10-25 16:49:25.433861', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068808908926976, 'b2b-shop-refundOrder-refuse', '审核拒绝', 1, 484068237250457600, '/484052761782841344/484067168998977536/484068237250457600/', NULL, 0, '无', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:49:35.416040', 356948235909079040, '2021-10-25 16:49:35.416040', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068815712088064, 'b2b-shop-actlist-reject', '审核拒绝', 1, 484066940149362688, '/484052761782841344/484066515870347264/484066940149362688/', NULL, 0, '/bip/custUserBind/stateApply/{id}/{status}', 'PATCH', NULL, NULL, 356948235909079040, '2021-10-25 16:49:37.038971', 356948235909079040, '2021-10-25 17:52:11.657675', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068837711212544, 'b2b-shop-fszlist-create', '新增商品', 1, 484066913695887360, '/484052761782841344/484052928393179136/484066913695887360/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:49:42.283687', 356948235909079040, '2021-10-25 16:49:42.283687', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068887287885824, 'b2b-shop-fszlist-edit', '编辑', 1, 484066913695887360, '/484052761782841344/484052928393179136/484066913695887360/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:49:54.103408', 356948235909079040, '2021-10-25 16:49:54.103408', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068898121773056, 'b2b-shop-cmfblist-search', '查询', 1, 484068069205667840, '/484052761782841344/484066515870347264/484068069205667840/', NULL, 0, '/bip/feedBack/query', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:49:56.686117', 356948235909079040, '2021-10-25 17:52:26.299822', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484068955709566976, 'b2b-shop-fszlist-del', '删除', 1, 484066913695887360, '/484052761782841344/484052928393179136/484066913695887360/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:50:10.416021', 356948235909079040, '2021-10-25 16:50:10.416021', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069031689383936, 'b2b-shop-fszlist-enable', '激活', 1, 484066913695887360, '/484052761782841344/484052928393179136/484066913695887360/', NULL, 0, '/bip/firstspecial/closeOrActive', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:50:28.531192', 356948235909079040, '2021-10-25 16:50:28.531192', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069110621990912, 'b2b-shop-fszlist-disable', '禁用', 1, 484066913695887360, '/484052761782841344/484052928393179136/484066913695887360/', NULL, 0, '/bip/firstspecial/closeOrActive', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:50:47.350395', 356948235909079040, '2021-10-25 16:50:47.350395', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069220927991808, 'b2b-shop-izzlist-search', '查询', 1, 484067168386609152, '/484052761782841344/484052928393179136/484067168386609152/', NULL, 0, '/zone/conf/zonePaging', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:51:13.649672', 356948235909079040, '2021-12-30 09:15:43.493886', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069271419023360, 'b2b-shop-izzlist-create', '新增专区', 1, 484067168386609152, '/484052761782841344/484052928393179136/484067168386609152/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:51:25.687672', 356948235909079040, '2021-10-25 16:51:25.687672', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069283926437888, '/shop/salesManagement', '营销管理', 0, 484052761782841344, '/484052761782841344/', NULL, 0, 'shop-salesManagement', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:51:28.669587', 356948235909079040, '2021-10-25 16:51:28.669587', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069347361091584, 'b2b-shop-izzlist-edit', '编辑', 1, 484067168386609152, '/484052761782841344/484052928393179136/484067168386609152/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:51:43.793751', 356948235909079040, '2021-10-25 16:51:43.793751', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069349495992320, 'shop-InvoicingManagement', '开票管理', 0, 484052761782841344, '/484052761782841344/', NULL, 0, '/shop/InvoicingManagement/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:51:44.302294', 356948235909079040, '2021-10-25 16:51:44.302294', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069427719761920, 'shop-salesManagement-fullReduceList', '满减促销查询', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/fullReduceList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:52:02.952379', 356948235909079040, '2021-10-25 16:52:02.952379', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069437194694656, 'b2b-shop-izzlist-enable', '激活', 1, 484067168386609152, '/484052761782841344/484052928393179136/484067168386609152/', NULL, 0, '/zone/conf/activeZone', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:52:05.211231', 356948235909079040, '2021-10-25 16:52:05.211231', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069540106137600, 'b2b-shop-izzlist-disable', '禁用', 1, 484067168386609152, '/484052761782841344/484052928393179136/484067168386609152/', NULL, 0, '/zone/conf/closedZone', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:52:29.747071', 356948235909079040, '2021-10-25 16:52:29.747071', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069577364140032, 'shop-salesManagement-fullReduceList-create', '添加满减促销', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/fullReduceList/create', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:52:38.630480', 356948235909079040, '2021-10-25 16:52:38.630480', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069606661353472, 'b2b-shop-izzlist-del', '删除', 1, 484067168386609152, '/484052761782841344/484052928393179136/484067168386609152/', NULL, 0, '/zone/conf/delZone', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:52:45.615338', 356948235909079040, '2021-10-25 16:52:45.615338', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069652437987328, 'shop-salesManagement-fullReduceList-edit', '编辑满减促销', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/fullReduceList/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:52:56.529398', 356948235909079040, '2021-10-25 16:52:56.529398', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069689830207488, 'shop-InvoicingManagement-invoicingQuery', '开票查询', 0, 484069349495992320, '/484052761782841344/484069349495992320/', NULL, 0, '/shop/InvoicingManagement/invoicingQuery', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:53:05.444362', 356948235909079040, '2021-10-25 16:53:05.444362', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069744163221504, 'shop-salesManagement-fullReduceList-detail', '满减促销详情', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/fullReduceList/view/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:53:18.398811', 356948235909079040, '2021-10-25 16:53:18.398811', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069751033491456, 'b2b-shop-LogisticsfreighttemplateList-search', '查询', 1, 484067036706435072, '/484052761782841344/484052928393179136/484067036706435072/', NULL, 0, '/logistics/conf/pageList', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:53:20.036315', 356948235909079040, '2021-10-25 16:53:20.036315', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069858898407424, 'b2b-shop-LogisticsfreighttemplateList-add', '新增', 1, 484067036706435072, '/484052761782841344/484052928393179136/484067036706435072/', NULL, 0, '/logistics/conf/saveLogistics', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:53:45.753420', 356948235909079040, '2021-12-29 13:12:49.433700', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069867198935040, 'b2b-shop-Invoicing-search', '查询', 1, 484069689830207488, '/484052761782841344/484069349495992320/484069689830207488/', NULL, 0, '/bip/inv/findAll', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:53:47.732432', 356948235909079040, '2021-10-25 16:53:47.732432', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069918285557760, 'b2b-shop-LogisticsfreighttemplateList-edit', '编辑', 1, 484067036706435072, '/484052761782841344/484052928393179136/484067036706435072/', NULL, 0, '/logistics/conf/saveLogistics', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:53:59.912648', 356948235909079040, '2021-12-29 13:12:40.608868', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484069947532439552, 'shop-salesManagement-salesPresentList', '买赠促销查询', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/salesPresentList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:54:06.885971', 356948235909079040, '2021-10-25 16:54:06.885971', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070000183537664, 'b2b-shop-LogisticsfreighttemplateList-enable', '启用', 1, 484067036706435072, '/484052761782841344/484052928393179136/484067036706435072/', NULL, 0, '/logistics/conf/openLogistics', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:54:19.438090', 356948235909079040, '2021-10-25 16:54:19.438090', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070037252796416, 'shop-EvaluationManagement', '订单评价管理', 0, 484052761782841344, '/484052761782841344/', NULL, 0, '/shop/EvaluationManagement/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:54:28.276772', 356948235909079040, '2021-10-25 16:54:28.276772', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070038620139520, 'shop-salesManagement-salesPresentList-create', '添加买赠促销', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/salesPresentList/create', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:54:28.602832', 356948235909079040, '2021-10-25 16:54:28.602832', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070082018603008, 'b2b-shop-LogisticsfreighttemplateList-disable', '禁用', 1, 484067036706435072, '/484052761782841344/484052928393179136/484067036706435072/', NULL, 0, '/logistics/conf/stopLogistics', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:54:38.949122', 356948235909079040, '2021-10-25 16:54:38.949122', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070121457643520, 'shop-salesManagement-salesPresentList-edit', '编辑买赠促销', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/salesPresentList/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:54:48.352407', 356948235909079040, '2021-10-25 16:54:48.352407', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070168555483136, 'b2b-shop-LogisticsfreighttemplateList-delete', '删除', 1, 484067036706435072, '/484052761782841344/484052928393179136/484067036706435072/', NULL, 0, '/logistics/conf/delLogistics', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:54:59.581414', 356948235909079040, '2021-12-29 13:12:30.613861', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070190441361408, 'shop-EvaluationManagement-evaluationManagement', '订单评价管理', 0, 484070037252796416, '/484052761782841344/484070037252796416/', NULL, 0, '/shop/EvaluationManagement/evaluationManagement', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:55:04.799051', 356948235909079040, '2021-10-25 16:55:04.799051', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070309635092480, 'b2b-shop-evaluation-search', '查询', 1, 484070190441361408, '/484052761782841344/484070037252796416/484070190441361408/', NULL, 0, '/bip/eval/page/search', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:55:33.217540', 356948235909079040, '2021-10-25 16:55:33.217540', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070446205825024, 'shop-salesManagement-bannerList', '轮播图查询', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/bannerList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:56:05.778872', 356948235909079040, '2021-10-25 16:56:05.778872', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070481366675456, 'b2b-shop-evaluation-hide', '隐藏', 1, 484070190441361408, '/484052761782841344/484070037252796416/484070190441361408/', NULL, 0, '/bip/eval/update/isShow', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:56:14.161472', 356948235909079040, '2021-10-25 16:56:14.161472', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070551247974400, 'shop-salesManagement-bannerList-create', '添加轮播图', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/bannerList/create', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:56:30.822337', 356948235909079040, '2021-10-25 16:56:30.822337', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070568163602432, 'b2b-shop-evaluation-display', '取消隐藏', 1, 484070190441361408, '/484052761782841344/484070037252796416/484070190441361408/', NULL, 0, '/bip/eval/update/isShow', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:56:34.855341', 356948235909079040, '2021-10-25 16:56:34.855341', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070648488718336, 'shop-salesManagement-bannerList-detail', '编辑轮播图', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/bannerList/view/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:56:54.006044', 356948235909079040, '2021-10-25 16:56:54.006044', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070777048330240, 'shop-salesManagement-couponCenter-list', '优惠券查询', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/couponCenter/list', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:57:24.657405', 356948235909079040, '2021-10-25 16:57:24.657405', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070785390800896, 'b2b-shop-evaluation-delete', '删除', 1, 484070190441361408, '/484052761782841344/484070037252796416/484070190441361408/', NULL, 0, '/bip/eval/delete', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 16:57:26.646372', 356948235909079040, '2021-10-25 16:57:26.646372', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070856391979008, 'shop-salesManagement-couponCenter-create', '优惠券新增', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/couponCenter/create', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:57:43.574489', 356948235909079040, '2021-10-25 16:57:43.574489', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070873336967168, 'b2b-shop-evaluation-save', '保存', 1, 484070190441361408, '/484052761782841344/484070037252796416/484070190441361408/', NULL, 0, '/proj/detail/{ids}/', 'GET', NULL, NULL, 356948235909079040, '2021-10-25 16:57:47.614341', 356948235909079040, '2021-10-25 16:57:47.614341', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484070998859902976, 'shop-salesManagement-couponCenter-edit', '优惠券编辑', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/couponCenter/edit/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:58:17.541691', 356948235909079040, '2021-10-25 16:58:17.541691', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071080778854400, 'shop-salesManagement-couponCenter-view', '优惠券查看', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/couponCenter/view/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:58:37.071987', 356948235909079040, '2021-10-25 16:58:37.071987', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071155785592832, 'shop-salesManagement-couponCenter-useRecord-list', '优惠券领用记录', 0, 484069283926437888, '/484052761782841344/484069283926437888/', NULL, 0, '/shop/salesManagement/couponCenter/useRecord/list', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:58:54.955449', 356948235909079040, '2021-10-25 16:58:54.955449', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071421675106304, 'shop-MeManagement', '我的', 0, 484052761782841344, '/484052761782841344/', NULL, 0, '/shop/MeManagement/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 16:59:58.348484', 356948235909079040, '2021-10-25 16:59:58.348484', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071429904330752, 'b2b-shop-frlist-search', '查询', 1, 484069427719761920, '/484052761782841344/484069283926437888/484069427719761920/', NULL, 0, '/mkt/discountOffset/search', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:00:00.310908', 356948235909079040, '2021-10-25 17:00:58.124325', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071491942281216, 'b2b-shop-frlist-create', '创建', 1, 484069427719761920, '/484052761782841344/484069283926437888/484069427719761920/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:00:15.101022', 356948235909079040, '2021-10-25 17:00:48.738853', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071553871179776, 'b2b-shop-frlist-edit', '编辑', 1, 484069427719761920, '/484052761782841344/484069283926437888/484069427719761920/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:00:29.866294', 356948235909079040, '2021-10-25 17:00:29.866294', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071632321441792, 'shop-MeManagement-helpCenter', '帮助中心查询', 0, 484071421675106304, '/484052761782841344/484071421675106304/', NULL, 0, '/shop/MeManagement/helpCenter/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:00:48.570171', 356948235909079040, '2021-10-25 17:00:48.570171', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071683882020864, 'mg-inv-sup-cerateDelivery', '创建配送单', 1, 103004001, '/103/103004/103004001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:01:00.863836', 356948235909079040, '2021-10-25 17:01:00.863836', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071777696018432, 'b2b-shop-frlist-enable', '启用', 1, 484069427719761920, '/484052761782841344/484069283926437888/484069427719761920/', NULL, 0, '/mkt/discountOffset/appr/{ids}/{status}', 'PATCH', NULL, NULL, 356948235909079040, '2021-10-25 17:01:23.230409', 356948235909079040, '2021-10-25 17:01:23.230409', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071795819606016, 'b2b-shop-helpclist-search', '查询', 1, 484071632321441792, '/484052761782841344/484071421675106304/484071632321441792/', NULL, 0, '/bip/helpCenter/findAll', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:01:27.551456', 356948235909079040, '2021-10-25 17:01:27.551456', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071843055857664, 'b2b-shop-frlist-diable', '禁用', 1, 484069427719761920, '/484052761782841344/484069283926437888/484069427719761920/', NULL, 0, '/mkt/discountOffset/appr/{ids}/{status}', 'PATCH', NULL, NULL, 356948235909079040, '2021-10-25 17:01:38.813914', 356948235909079040, '2021-10-25 17:01:38.813914', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071843466899456, 'mg-inv-sup-printing', '打印', 1, 103004001, '/103/103004/103004001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:01:38.911673', 356948235909079040, '2021-10-25 17:01:38.911673', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071875523964928, 'b2b-shop-helpclist-create', '新建', 1, 484071632321441792, '/484052761782841344/484071421675106304/484071632321441792/', NULL, 0, '/bip/helpCenter/save', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:01:46.554398', 356948235909079040, '2021-10-25 17:03:18.713519', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484071954032947200, 'b2b-shop-helpclist-edit', '编辑', 1, 484071632321441792, '/484052761782841344/484071421675106304/484071632321441792/', NULL, 0, '/bip/coupon/update', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 17:02:05.272674', 356948235909079040, '2021-10-25 17:03:55.350009', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072033607282688, 'b2b-shop-fredit-save', '保存', 1, 484069577364140032, '/484052761782841344/484069283926437888/484069577364140032/', NULL, 0, '/mkt/discountOffset/createOne', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:02:24.244740', 356948235909079040, '2021-10-25 17:02:24.244740', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072036119670784, 'deliveryMg', '配送单管理', 0, 105, '/105/', NULL, 0, '/logistics/deliveryMg', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:02:24.843189', 356948235909079040, '2021-10-25 17:02:45.541899', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072065781788672, 'b2b-shop-helpclist-enable', '启用', 1, 484071632321441792, '/484052761782841344/484071421675106304/484071632321441792/', NULL, 0, '/bip/helpCenter/status/{ids}/{status}', 'GET', NULL, NULL, 356948235909079040, '2021-10-25 17:02:31.915084', 356948235909079040, '2021-10-25 17:02:31.915084', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072113257115648, 'b2b-shop-fredit-detail-create', '新增', 1, 484069577364140032, '/484052761782841344/484069283926437888/484069577364140032/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:02:43.234976', 356948235909079040, '2021-10-25 17:02:43.234976', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072159411236864, 'b2b-shop-helpclist-close', '停用', 1, 484071632321441792, '/484052761782841344/484071421675106304/484071632321441792/', NULL, 0, '/bip/helpCenter/status/{ids}/{status}', 'GET', NULL, NULL, 356948235909079040, '2021-10-25 17:02:54.238825', 356948235909079040, '2021-10-25 17:02:54.238825', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072166612856832, 'b2b-shop-fredit-detail-delete', '删除', 1, 484069577364140032, '/484052761782841344/484069283926437888/484069577364140032/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:02:55.955534', 356948235909079040, '2021-10-25 17:02:55.955534', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072248099794944, 'deliveryMgList', '配送单管理', 0, 484072036119670784, '/105/484072036119670784/', NULL, 0, '/logistics/deliveryMg/list', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:03:15.383544', 356948235909079040, '2021-10-25 17:03:15.383544', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072278185537536, 'b2b-shop-fredit-save', '保存', 1, 484069652437987328, '/484052761782841344/484069283926437888/484069652437987328/', NULL, 0, '/mkt/discountOffset/update', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 17:03:22.556424', 356948235909079040, '2021-10-25 17:03:22.556424', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072367213834240, 'b2b-shop-fredit-detail-create', '新增', 1, 484069652437987328, '/484052761782841344/484069283926437888/484069652437987328/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:03:43.782917', 356948235909079040, '2021-10-25 17:03:43.782917', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072419722326016, 'b2b-shop-fredit-detail-delete', '删除', 1, 484069652437987328, '/484052761782841344/484069283926437888/484069652437987328/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:03:56.301948', 356948235909079040, '2021-10-25 17:03:56.301948', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072443923460096, 'deliveryMgCreate', '新增配送单', 0, 484072036119670784, '/105/484072036119670784/', NULL, 0, '/logistics/deliveryMg/create/:id/:type', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:04:02.071984', 356948235909079040, '2021-10-25 17:04:02.071984', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072522436636672, 'deliveryMgEdit', '配送单修改', 0, 484072036119670784, '/105/484072036119670784/', NULL, 0, '/logistics/deliveryMg/edit/:id/:type', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:04:20.790816', 356948235909079040, '2021-10-25 17:04:20.790816', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072585468637184, 'shop-ouManagement', '公司管理', 0, 484052761782841344, '/484052761782841344/', NULL, 0, '/shop/ouManagement/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:04:35.818038', 356948235909079040, '2021-10-25 17:04:35.818038', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072632482590720, 'deliveryMgDetial', '配送单详情', 0, 484072036119670784, '/105/484072036119670784/', NULL, 0, '/logistics/deliveryMg/detial/:id', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:04:47.027528', 356948235909079040, '2021-10-25 17:04:47.027528', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072704922415104, 'shop-ouManagement-list', '公司查询', 0, 484072585468637184, '/484052761782841344/484072585468637184/', NULL, 0, '/shop/ouManagement/list', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:05:04.297997', 356948235909079040, '2021-10-25 17:05:04.297997', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072710031077376, 'b2b-shop-splist-search', '查询', 1, 484069947532439552, '/484052761782841344/484069283926437888/484069947532439552/', NULL, 0, '/mkt/discountGift/search', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:05:05.516160', 356948235909079040, '2021-10-25 17:05:05.516160', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072769044934656, 'b2b-shop-splist-create', '创建', 1, 484069947532439552, '/484052761782841344/484069283926437888/484069947532439552/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:05:19.586478', 356948235909079040, '2021-10-25 17:05:19.586478', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072818290257920, 'b2b-shop-oumlist-search', '查询', 1, 484072704922415104, '/484052761782841344/484072585468637184/484072704922415104/', NULL, 0, '/bip/companyManage/search', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:05:31.327580', 356948235909079040, '2021-10-25 17:05:31.327580', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072827886825472, 'b2b-shop-splist-edit', '编辑', 1, 484069947532439552, '/484052761782841344/484069283926437888/484069947532439552/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:05:33.615083', 356948235909079040, '2021-10-25 17:05:33.615083', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072839337275392, 'mg-inv-sup-edit', '修改', 1, 484072248099794944, '/105/484072036119670784/484072248099794944/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:05:36.345505', 356948235909079040, '2021-10-25 17:05:36.345505', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072894081331200, 'mg-inv-sup-subDelivery', '提交承运', 1, 484072248099794944, '/105/484072036119670784/484072248099794944/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:05:49.397736', 356948235909079040, '2021-10-25 17:05:49.397736', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072902763540480, 'b2b-shop-oumlist-create', '新建', 1, 484072704922415104, '/484052761782841344/484072585468637184/484072704922415104/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:05:51.467213', 356948235909079040, '2021-10-25 17:05:51.467213', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072919914049536, 'b2b-shop-splist-enable', '启用', 1, 484069947532439552, '/484052761782841344/484069283926437888/484069947532439552/', NULL, 0, '/mkt/discountGift/appr/{ids}/{status}', 'PATCH', NULL, NULL, 356948235909079040, '2021-10-25 17:05:55.556081', 356948235909079040, '2021-10-25 17:05:55.556081', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072979120844800, 'mg-inv-sup-subdel', '删除', 1, 484072248099794944, '/105/484072036119670784/484072248099794944/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:06:09.672852', 356948235909079040, '2021-10-25 17:06:09.672852', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072998645329920, 'b2b-shop-oumlist-edit', '编辑', 1, 484072704922415104, '/484052761782841344/484072585468637184/484072704922415104/', NULL, 0, '/bip/companyManage/get/{id}', 'GET', NULL, NULL, 356948235909079040, '2021-10-25 17:06:14.327730', 356948235909079040, '2021-10-25 17:06:14.327730', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484072999761014784, 'b2b-shop-splist-disable', '禁用', 1, 484069947532439552, '/484052761782841344/484069283926437888/484069947532439552/', NULL, 0, '/mkt/discountGift/appr/{ids}/{status}', 'PATCH', NULL, NULL, 356948235909079040, '2021-10-25 17:06:14.593186', 356948235909079040, '2021-10-25 17:06:14.593186', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073126462550016, 'b2b-shop-spedit-save', '保存', 1, 484070038620139520, '/484052761782841344/484069283926437888/484070038620139520/', NULL, 0, '/mkt/discountGift/createOne', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:06:44.801868', 356948235909079040, '2021-10-25 17:06:44.801868', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073215687979008, 'b2b-shop-fredit-bmdetail-add', '新增(促销信息）', 1, 484070038620139520, '/484052761782841344/484069283926437888/484070038620139520/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:07:06.074103', 356948235909079040, '2021-10-25 17:08:15.331186', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073279617560576, 'b2b-shop-oumlist-show', '显示', 1, 484072704922415104, '/484052761782841344/484072585468637184/484072704922415104/', NULL, 0, '/bip/companyManage/switchStatus', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:07:21.316563', 356948235909079040, '2021-10-25 17:07:21.316563', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073283753144320, 'b2b-shop-fredit-givedetail-add', '新增(赠品）', 1, 484070038620139520, '/484052761782841344/484069283926437888/484070038620139520/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:07:22.302307', 356948235909079040, '2021-10-25 17:08:23.297369', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073315252367360, 'mg-purc-life-cycle', '供应商生命周期', 0, 0, '/', NULL, 0, '/purc', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:07:29.812014', 356948235909079040, '2021-10-25 17:07:29.812014', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073404469407744, 'b2b-shop-oumlist-del', '删除', 1, 484072704922415104, '/484052761782841344/484072585468637184/484072704922415104/', NULL, 0, '/bip/companyManage/delete', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:07:51.083774', 356948235909079040, '2021-10-25 17:07:51.083774', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073423628988416, 'purSupplierAssessment', '供应商评价考核', 0, 484073315252367360, '/484073315252367360/', NULL, 0, '/purc/supplier/assessment', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:07:55.651493', 356948235909079040, '2021-10-25 17:07:55.651493', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073490968539136, 'b2b-shop-oumlist-hidden', '隐藏', 1, 484072704922415104, '/484052761782841344/484072585468637184/484072704922415104/', NULL, 0, '/bip/companyManage/switchStatus', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:08:11.706567', 356948235909079040, '2021-10-25 17:08:11.706567', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073601958211584, 'b2b-shop-fredit-bmdetail-del', '删除(促销信息）', 1, 484070038620139520, '/484052761782841344/484069283926437888/484070038620139520/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:08:38.168113', 356948235909079040, '2021-10-25 17:08:38.168113', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073658426126336, 'b2b-shop-fredit-givedetail-del', '删除(赠品）', 1, 484070038620139520, '/484052761782841344/484069283926437888/484070038620139520/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:08:51.631333', 356948235909079040, '2021-10-25 17:08:51.631333', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073686104338432, 'purSupplierAssessmentEvaluating', '评价指标定义', 0, 484073423628988416, '/484073315252367360/484073423628988416/', NULL, 0, '/purc/supplier/assessment/Evaluating', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:08:58.230359', 356948235909079040, '2021-10-25 17:08:58.230359', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073799212134400, 'purSupplierAssessmentBehavior', '日常行为记录', 0, 484073423628988416, '/484073315252367360/484073423628988416/', NULL, 0, '/purc/supplier/assessment/Behavior', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:09:25.197717', 356948235909079040, '2021-10-25 17:09:25.197717', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484073962697715712, '/purc/supplier/assessment/Criterion', '分级准则配置', 0, 484073423628988416, '/484073315252367360/484073423628988416/', NULL, 0, '/purc/supplier/assessment/Criterion', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:10:04.175695', 356948235909079040, '2021-10-25 17:10:04.175695', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484074089457971200, 'purSupplierAssessmentEvaluationModelList', '评价模型列表', 0, 484073423628988416, '/484073315252367360/484073423628988416/', NULL, 0, '/purc/supplier/assessment/EvaluationModelList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:10:34.397870', 356948235909079040, '2021-10-25 17:10:34.397870', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484074149969195008, 'b2b-shop-spedit-save', '保存', 1, 484070121457643520, '/484052761782841344/484069283926437888/484070121457643520/', NULL, 0, '/mkt/discountGift/update', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 17:10:48.824062', 356948235909079040, '2021-10-25 17:10:48.824062', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484074164292743168, 'purSupplierJoinEvalList', '考评清单列表', 0, 484073423628988416, '/484073315252367360/484073423628988416/', NULL, 0, '/purc/supplier/JoinEvalList', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:10:52.239549', 356948235909079040, '2021-10-25 17:11:18.399186', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484074279967453184, 'b2b-shop-fredit-bmdetail-add', '新增(促销信息）', 1, 484070121457643520, '/484052761782841344/484069283926437888/484070121457643520/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:11:19.818530', 356948235909079040, '2021-10-25 17:11:19.818530', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484074371101290496, 'b2b-shop-fredit-bmdetail-del', '删除(促销信息）', 1, 484070121457643520, '/484052761782841344/484069283926437888/484070121457643520/', NULL, 0, '/mkt/discountGift/deleteDBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-10-25 17:11:41.546193', 356948235909079040, '2021-10-25 17:14:40.627071', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484074457210351616, 'purSupplierAssessmentSubchildsource', '供应商考核', 0, 484073423628988416, '/484073315252367360/484073423628988416/', NULL, 0, '/purc/supplier/assessment/subchildsource', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:12:02.076626', 356948235909079040, '2021-10-25 17:12:02.076626', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484074566232895488, 'purSupplierAssessmentSubsidiary', '供应商考核结果查询', 0, 484073423628988416, '/484073315252367360/484073423628988416/', NULL, 0, '/purc/supplier/assessment/Subsidiary', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:12:28.069942', 356948235909079040, '2021-10-25 17:12:28.069942', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484074913231859712, 'supplier-assessment-evaluat-new', '新增', 1, 484073686104338432, '/484073315252367360/484073423628988416/484073686104338432/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:13:50.800540', 356948235909079040, '2021-10-25 17:13:50.800540', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484074984321118208, 'supplier-assessment-evaluat-edit', '编辑', 1, 484073686104338432, '/484073315252367360/484073423628988416/484073686104338432/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:14:07.749839', 356948235909079040, '2021-10-25 17:14:07.749839', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075206451458048, 'supplier-assessment-behavior-new', '新增', 1, 484073799212134400, '/484073315252367360/484073423628988416/484073799212134400/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:15:00.709439', 356948235909079040, '2021-10-25 17:15:00.709439', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075269013696512, 'supplier-assessment-behavior-delete', '删除', 1, 484073799212134400, '/484073315252367360/484073423628988416/484073799212134400/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:15:15.625698', 356948235909079040, '2021-10-25 17:15:15.625698', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075339532529664, 'supplier-assessment-behavior-edit', '编辑', 1, 484073799212134400, '/484073315252367360/484073423628988416/484073799212134400/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:15:32.438031', 356948235909079040, '2021-10-25 17:15:32.438031', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075408042291200, 'b2b-shop-fredit-givedetail-del', '删除(赠品）', 1, 484070121457643520, '/484052761782841344/484069283926437888/484070121457643520/', NULL, 0, '/mkt/discountGift/deleteDBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-10-25 17:15:48.772545', 356948235909079040, '2021-10-25 17:16:16.232250', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075482528935936, 'b2b-shop-fredit-givedetail-add', '新增(赠品）', 1, 484070121457643520, '/484052761782841344/484069283926437888/484070121457643520/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:16:06.531394', 356948235909079040, '2021-10-25 17:16:06.531394', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075644588453888, 'b2b-shop-bnlist-search', '查询', 1, 484070446205825024, '/484052761782841344/484069283926437888/484070446205825024/', NULL, 0, '/bip/retationChart/search', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:16:45.169118', 356948235909079040, '2021-10-25 17:16:45.169118', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075667426439168, 'supplier-assessment-criter-new', '新增', 1, 484073962697715712, '/484073315252367360/484073423628988416/484073962697715712/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:16:50.614649', 356948235909079040, '2021-10-25 17:16:50.614649', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075717825196032, 'b2b-shop-bnlist-create', '创建', 1, 484070446205825024, '/484052761782841344/484069283926437888/484070446205825024/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:17:02.630251', 356948235909079040, '2021-10-25 17:17:02.630251', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075744169619456, 'supplier-assessment-criter-edit', '编辑', 1, 484073962697715712, '/484073315252367360/484073423628988416/484073962697715712/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:17:08.911028', 356948235909079040, '2021-10-25 17:17:08.911028', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075788255948800, 'b2b-shop-bnlist-edit', '编辑', 1, 484070446205825024, '/484052761782841344/484069283926437888/484070446205825024/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:17:19.422894', 356948235909079040, '2021-10-25 17:17:19.422894', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075878391541760, 'b2b-shop-bnlist-enable', '启用', 1, 484070446205825024, '/484052761782841344/484069283926437888/484070446205825024/', NULL, 0, '/bip/retationChart/change/{ids}/{status}', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 17:17:40.912856', 356948235909079040, '2021-10-25 17:17:40.912856', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075918401007616, 'supplier-assessment-evaluation-new', '新增', 1, 484074089457971200, '/484073315252367360/484073423628988416/484074089457971200/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:17:50.451803', 356948235909079040, '2021-10-25 17:17:50.451803', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075972180373504, 'b2b-shop-bnlist-disable', '停用', 1, 484070446205825024, '/484052761782841344/484069283926437888/484070446205825024/', NULL, 0, '/bip/retationChart/change/{ids}/{status}', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 17:18:03.273154', 356948235909079040, '2021-10-25 17:18:03.273154', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075978048204800, 'separateSettlement', '分账结算', 0, 112, '/112/', NULL, 0, '/Separate', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:18:04.672274', 356948235909079040, '2021-10-25 17:18:04.672274', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484075988227780608, 'supplier-assessment-evaluation-copy', '复制', 1, 484074089457971200, '/484073315252367360/484073423628988416/484074089457971200/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:18:07.099207', 356948235909079040, '2021-10-25 17:18:07.099207', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076040849518592, 'supplier-assessment-evaluation-edit', '修改', 1, 484074089457971200, '/484073315252367360/484073423628988416/484074089457971200/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:18:19.645316', 356948235909079040, '2021-10-25 17:18:19.645316', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076051423358976, 'b2b-shop-bnlist-del', '删除', 1, 484070446205825024, '/484052761782841344/484069283926437888/484070446205825024/', NULL, 0, '/bip/retationChart/deleteBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-10-25 17:18:22.166328', 356948235909079040, '2021-10-25 17:18:22.166328', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076116506374144, 'supplier-assessment-evaluation-submit', '发布', 1, 484074089457971200, '/484073315252367360/484073423628988416/484074089457971200/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:18:37.683694', 356948235909079040, '2021-10-25 17:18:37.683694', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076319112228864, 'b2b-shop-bnedit-save', '保存', 1, 484070551247974400, '/484052761782841344/484069283926437888/484070551247974400/', NULL, 0, '/bip/retationChart/createOne', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:19:25.988098', 356948235909079040, '2021-10-25 17:19:25.988098', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076420912181248, 'b2b-shop-bnedit-save', '保存', 1, 484070648488718336, '/484052761782841344/484069283926437888/484070648488718336/', NULL, 0, '/bip/retationChart/update', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 17:19:50.259188', 356948235909079040, '2021-10-25 17:51:17.335393', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076427631456256, 'pur-sup-joinEval-get', '获取参评清单', 1, 484074164292743168, '/484073315252367360/484073423628988416/484074164292743168/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:19:51.861689', 356948235909079040, '2021-10-25 17:19:51.861689', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076520904388608, 'pur-sup-joinEval-del', '删除', 1, 484074164292743168, '/484073315252367360/484073423628988416/484074164292743168/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:20:14.099419', 356948235909079040, '2021-10-25 17:20:14.099419', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076586285199360, 'separateSettlementSconfiguration', '分账结算配置', 0, 484075978048204800, '/112/484075978048204800/', NULL, 0, '/separate/Sconfiguration', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:20:29.687300', 356948235909079040, '2021-10-25 17:20:29.687300', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076612856115200, 'pur-sup-joinEval-export', '导出', 1, 484074164292743168, '/484073315252367360/484073423628988416/484074164292743168/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:20:36.022621', 356948235909079040, '2021-10-25 17:20:36.022621', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076663770771456, 'b2b-shop-cpclist-search', '查询', 1, 484070777048330240, '/484052761782841344/484069283926437888/484070777048330240/', NULL, 0, '/bip/coupon/search', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:20:48.161539', 356948235909079040, '2021-10-25 17:20:48.161539', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076712005267456, 'WeeklyLedgerSummarySheet', '每周分账汇总单', 0, 484075978048204800, '/112/484075978048204800/', NULL, 0, '/separate/SummarySheet', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:20:59.661115', 356948235909079040, '2021-10-25 17:20:59.661115', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076730300821504, 'pur-sup-joinEval-create', '生成打分表', 1, 484074164292743168, '/484073315252367360/484073423628988416/484074164292743168/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:21:04.023806', 356948235909079040, '2021-10-25 17:21:04.023806', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076751825989632, 'b2b-shop-cpclist-create', '创建', 1, 484070777048330240, '/484052761782841344/484069283926437888/484070777048330240/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:21:09.155532', 356948235909079040, '2021-10-25 17:21:09.155532', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076802929389568, 'b2b-shop-cpclist-edit', '编辑', 1, 484070777048330240, '/484052761782841344/484069283926437888/484070777048330240/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:21:21.339696', 356948235909079040, '2021-10-25 17:21:21.339696', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076804556779520, 'merchantFinanceAccount', '商家中金账号', 0, 484075978048204800, '/112/484075978048204800/', NULL, 0, '/separate/FinanceAccount', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:21:21.727370', 356948235909079040, '2021-10-25 17:21:21.727370', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076876816248832, 'merchantFinanceBill', '商家中金账单', 0, 484075978048204800, '/112/484075978048204800/', NULL, 0, '/separate/FinanceBill', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:21:38.955194', 356948235909079040, '2021-10-25 17:21:38.955194', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076906792939520, 'b2b-shop-cpclist-enable', '激活', 1, 484070777048330240, '/484052761782841344/484069283926437888/484070777048330240/', NULL, 0, '/bip/coupon/activeCoupon', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 17:21:46.102022', 356948235909079040, '2021-10-25 17:21:46.102022', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484076996819480576, 'supplier-admittance-subchildsource-new', '打分', 1, 484074457210351616, '/484073315252367360/484073423628988416/484074457210351616/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:22:07.566784', 356948235909079040, '2021-10-25 17:22:07.566784', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077065832558592, 'supplier-admittance-subchildsource-io', '线下评分', 1, 484074457210351616, '/484073315252367360/484073423628988416/484074457210351616/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:22:24.020512', 356948235909079040, '2021-10-25 17:22:24.020512', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077137215418368, 'supplier-admittance-subchildsource-submit', '提交', 1, 484074457210351616, '/484073315252367360/484073423628988416/484074457210351616/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:22:41.039180', 356948235909079040, '2021-10-25 17:22:41.039180', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077192336961536, 'b2b-shop-cpclist-disable', '禁用', 1, 484070777048330240, '/484052761782841344/484069283926437888/484070777048330240/', NULL, 0, '/bip/coupon/disableCoupon', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 17:22:54.181616', 356948235909079040, '2021-10-25 17:22:54.181616', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077201488932864, 'supplier-admittance-subchildsource-collect', '汇总评级', 1, 484074457210351616, '/484073315252367360/484073423628988416/484074457210351616/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:22:56.363380', 356948235909079040, '2021-10-25 17:22:56.363380', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077276810244096, 'b2b-shop-cpclist-bgmap', '首页弹出背景图', 1, 484070777048330240, '/484052761782841344/484069283926437888/484070777048330240/', NULL, 0, '/bip/coupon/searchBackImg', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:23:14.321556', 356948235909079040, '2021-10-25 17:23:14.321556', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077279972749312, 'supplier-admittance-subchildsource-link', '跳转考核结果', 1, 484074457210351616, '/484073315252367360/484073423628988416/484074457210351616/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:23:15.075041', 356948235909079040, '2021-10-25 17:23:15.075041', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077346486022144, 'b2b-shop-cpclist-cpcollect', '优惠券领用情况', 1, 484070777048330240, '/484052761782841344/484069283926437888/484070777048330240/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:23:30.933186', 356948235909079040, '2021-10-25 17:23:30.933186', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077431559090176, 'supplier-admittance-subsideiary-exportall', '全部导出', 1, 484074566232895488, '/484073315252367360/484073423628988416/484074566232895488/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:23:51.216619', 356948235909079040, '2021-10-25 17:23:51.216619', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077458155171840, 'b2b-shop-cpedit-save', '保存', 1, 484070856391979008, '/484052761782841344/484069283926437888/484070856391979008/', NULL, 0, '/bip/coupon/createOne', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:23:57.557240', 356948235909079040, '2021-10-25 17:23:57.557240', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077489390153728, 'supplier-admittance-subsideiary-export', '勾选导出', 1, 484074566232895488, '/484073315252367360/484073423628988416/484074566232895488/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:24:05.004928', 356948235909079040, '2021-10-25 17:24:05.004928', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077520465752064, 'b2b-shop-cpedit-itemdetail-addcfy', '添加分类', 1, 484070856391979008, '/484052761782841344/484069283926437888/484070856391979008/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:24:12.413628', 356948235909079040, '2021-10-25 17:24:12.413628', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077577164353536, 'supplier-admittance-subsideiary-link', '跳转打分表', 1, 484074566232895488, '/484073315252367360/484073423628988416/484074566232895488/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:24:25.931008', 356948235909079040, '2021-10-25 17:24:25.931008', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077595808034816, 'b2b-shop-cpedit-itemdetail-addsku', '选择商品sku', 1, 484070856391979008, '/484052761782841344/484069283926437888/484070856391979008/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:24:30.376910', 356948235909079040, '2021-10-25 17:24:30.376910', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484077669258686464, 'b2b-shop-cpedit-itemdetail-del', '删除', 1, 484070856391979008, '/484052761782841344/484069283926437888/484070856391979008/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:24:47.888703', 356948235909079040, '2021-10-25 17:24:47.888703', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484078316443987968, 'b2b-shop-cpedit-save', '保存', 1, 484070998859902976, '/484052761782841344/484069283926437888/484070998859902976/', NULL, 0, '/bip/coupon/update', 'PUT', NULL, NULL, 356948235909079040, '2021-10-25 17:27:22.189933', 356948235909079040, '2021-10-25 17:27:22.189933', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484078382642688000, 'b2b-shop-cpedit-itemdetail-addcfy', '添加分类', 1, 484070998859902976, '/484052761782841344/484069283926437888/484070998859902976/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:27:37.971987', 356948235909079040, '2021-10-25 17:27:37.971987', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484078430281592832, 'b2b-shop-cpedit-itemdetail-addsku', '选择商品sku', 1, 484070998859902976, '/484052761782841344/484069283926437888/484070998859902976/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:27:49.330925', 356948235909079040, '2021-10-25 17:27:49.330925', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484078482051887104, 'b2b-shop-cpedit-itemdetail-del', '删除', 1, 484070998859902976, '/484052761782841344/484069283926437888/484070998859902976/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:28:01.673683', 356948235909079040, '2021-10-25 17:28:01.673683', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484079671468421120, 'b2b-shop-cpedit-itemdetail-del', '删除', 1, 484071080778854400, '/484052761782841344/484069283926437888/484071080778854400/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:32:45.252923', 356948235909079040, '2021-10-25 17:32:45.252923', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484079803425419264, 'b2b-shop-cpurlist-search', '查询', 1, 484071155785592832, '/484052761782841344/484069283926437888/484071155785592832/', NULL, 0, '/bip/couponcust/pageSearch', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:33:16.713012', 356948235909079040, '2021-10-25 17:33:16.713012', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484082005112057856, 'support-itemCenter-itemFreeze-list', '商品冻结', 0, 106004, '/106/106004/', NULL, 0, '/itemCenter/itemFreeze/List', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:42:01.636968', 356948235909079040, '2021-10-25 17:42:01.636968', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484082151333883904, 'support-itemCenter-itemFreeze-create', '新增商品冻结', 0, 106004, '/106/106004/', NULL, 0, '/itemCenter/itemFreeze/create/:type', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:42:36.498253', 356948235909079040, '2021-10-25 17:43:01.909852', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484082344829710336, 'support-itemCenter-itemFreeze-edit', '编辑商品冻结', 0, 106004, '/106/106004/', NULL, 0, '/itemCenter/itemFreeze/edit/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-10-25 17:43:22.631844', 356948235909079040, '2021-10-25 17:43:22.631844', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484083221330194432, 'fin-led-set-save', '保存', 1, 484076586285199360, '/112/484075978048204800/484076586285199360/', NULL, 0, '/fin/wdmSettle/defineSave', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:46:51.605291', 356948235909079040, '2021-10-25 17:46:51.605291', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484083326288457728, 'fin-sub-account-query', '查询', 1, 484076712005267456, '/112/484075978048204800/484076712005267456/', NULL, 0, '/fin/wdmSettle/weekSumPaging', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:47:16.629233', 356948235909079040, '2021-10-25 17:47:16.629233', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484083452025303040, 'fin-sub-account-audit', '审核', 1, 484076712005267456, '/112/484075978048204800/484076712005267456/', NULL, 0, '/fin/wdmSettle/approve', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:47:46.607039', 356948235909079040, '2021-10-26 10:49:43.051709', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484083608397344768, 'fin-sub-account-export', '导出', 1, 484076712005267456, '/112/484075978048204800/484076712005267456/', NULL, 0, '/fin/wdmSettle/exportWorkFlow', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:48:23.889019', 356948235909079040, '2021-10-26 10:49:17.614236', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484085900131495936, 'fin-sp-ac-query', '查询', 1, 484076804556779520, '/112/484075978048204800/484076804556779520/', NULL, 0, '/fin/wdmSettle/accountPaging', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:57:30.281069', 356948235909079040, '2021-10-26 10:48:40.945496', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484085953671786496, 'fin-sp-ac-export', '导出', 1, 484076804556779520, '/112/484075978048204800/484076804556779520/', NULL, 0, '/fin/wdmSettle/exportNo', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:57:43.046387', 356948235909079040, '2021-10-26 10:49:01.006093', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484086044432330752, 'fin-sp-bill-query', '查询', 1, 484076876816248832, '/112/484075978048204800/484076876816248832/', NULL, 0, '/fin/wdmSettle/billPaging', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:58:04.685222', 356948235909079040, '2021-10-26 10:47:51.832167', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484086093996421120, 'fin-sp-bill-export', '导出', 1, 484076876816248832, '/112/484075978048204800/484076876816248832/', NULL, 0, '/fin/wdmSettle/exportBill', 'POST', NULL, NULL, 356948235909079040, '2021-10-25 17:58:16.502207', 356948235909079040, '2021-10-26 10:48:17.195137', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484339580550311936, 'fin-led-set-query', '查询', 1, 484076586285199360, '/112/484075978048204800/484076586285199360/', NULL, 0, '/fin/wdmSettle/definePaging', 'POST', NULL, NULL, 356948235909079040, '2021-10-26 10:45:32.406494', 356948235909079040, '2021-10-26 10:45:32.406494', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484339911988408320, 'fin-sp-ac-audit', '审核', 1, 484076804556779520, '/112/484075978048204800/484076804556779520/', NULL, 0, '/fin/wdmSettle/ciccApprove', 'POST', NULL, NULL, 356948235909079040, '2021-10-26 10:46:51.427602', 356948235909079040, '2021-10-26 10:55:44.323022', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484339986747682816, 'fin-sp-bill-audit', '审核', 1, 484076876816248832, '/112/484075978048204800/484076876816248832/', NULL, 0, '/fin/wdmSettle/billApprove', 'POST', NULL, NULL, 356948235909079040, '2021-10-26 10:47:09.251428', 356948235909079040, '2021-10-26 10:47:09.251428', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484388495517126656, 'sup-item-itemFreeze-list-query', '查询', 1, 484082005112057856, '/106/106004/484082005112057856/', NULL, 0, '/itm/lifeStatus/list', 'POST', NULL, NULL, 356948235909079040, '2021-10-26 13:59:54.643160', 356948235909079040, '2021-10-26 13:59:54.643160', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484388613314154496, 'sup-item-itemFreeze-list-create', '新增', 1, 484082005112057856, '/106/106004/484082005112057856/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-26 14:00:22.727383', 356948235909079040, '2021-10-26 14:00:22.727383', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484388704112447488, 'sup-item-itemFreeze-list-edit', '编辑', 1, 484082005112057856, '/106/106004/484082005112057856/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-26 14:00:44.376047', 356948235909079040, '2021-10-26 14:00:44.376047', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484388832873385984, 'sup-item-itemFreeze-list-del', '删除', 1, 484082005112057856, '/106/106004/484082005112057856/', NULL, 0, '/itm/lifeStatus/delete', 'DELETE', NULL, NULL, 356948235909079040, '2021-10-26 14:01:15.075183', 356948235909079040, '2021-10-26 14:01:15.075183', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (484692991137468416, 'supplier-admittance-subchildsource-pull', '拉取系统评分', 1, 484074457210351616, '/484073315252367360/484073423628988416/484074457210351616/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-10-27 10:09:52.056193', 356948235909079040, '2021-10-27 10:09:52.056193', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (486500509236260864, 'sup-item-emp-disabled', '禁用', 1, 108005001, '/108/108005/108005001/', NULL, 0, '/org/emp/switchEmpSts', 'POST', NULL, NULL, 356948235909079040, '2021-11-01 09:52:17.953063', 356948235909079040, '2021-11-01 09:52:17.953063', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487579520482504704, 'support-itemCenter-FreezeSetting-list', '冻结场景配置', 0, 106004, '/106/106004/', NULL, 0, '/itemCenter/freezeSetting/list', NULL, NULL, NULL, 356948235909079040, '2021-11-04 09:19:54.281870', 356948235909079040, '2021-11-04 09:19:54.281870', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487579758937075712, 'support-itemCenter-freezeSetting-create', '新增场景配置', 0, 106004, '/106/106004/', NULL, 0, '/itemCenter/freezeSetting/create/:type', NULL, NULL, NULL, 356948235909079040, '2021-11-04 09:20:51.132342', 356948235909079040, '2021-11-04 09:20:51.132342', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487579901979619328, 'support-itemCenter-freezeSetting-edit', '编辑场景配置', 0, 106004, '/106/106004/', NULL, 0, '/itemCenter/freezeSetting/edit/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-11-04 09:21:25.237779', 356948235909079040, '2021-11-04 09:21:25.237779', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487580277676011520, 'sup-item-freezeSetting-list-create', '新增', 1, 487579520482504704, '/106/106004/487579520482504704/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-04 09:22:54.810544', 356948235909079040, '2021-11-04 09:22:54.810544', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487580348601692160, 'sup-item-freezeSetting-list-edit', '编辑', 1, 487579520482504704, '/106/106004/487579520482504704/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-04 09:23:11.720317', 356948235909079040, '2021-11-04 09:23:11.720317', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487580628726673408, 'sup-item-freezeSetting-start', '启用', 1, 487579520482504704, '/106/106004/487579520482504704/', NULL, 0, '/itm/statusConfig/update', 'POST', NULL, NULL, 356948235909079040, '2021-11-04 09:24:18.507002', 356948235909079040, '2021-11-04 09:24:52.764100', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487580871925002240, 'sup-item-freezeSetting-disabled', '禁用', 1, 487579520482504704, '/106/106004/487579520482504704/', NULL, 0, '/itm/statusConfig/update', 'POST', NULL, NULL, 356948235909079040, '2021-11-04 09:25:16.490287', 356948235909079040, '2021-11-04 09:25:16.490287', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487580979496316928, 'sup-item-freezeSetting-del', '删除', 1, 487579520482504704, '/106/106004/487579520482504704/', NULL, 0, '/itm/statusConfig/delete/{id}', 'DELETE', NULL, NULL, 356948235909079040, '2021-11-04 09:25:42.137775', 356948235909079040, '2021-11-04 09:26:45.078021', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487681779056836608, 'fin-pur-sa-cancel', '取消核销', 1, 464139540976226304, '/112/112002/464139540976226304/', NULL, 0, '/sal/verify/cancel/{id}', 'POST', NULL, NULL, 356948235909079040, '2021-11-04 16:06:14.625838', 356948235909079040, '2021-11-04 16:09:12.137273', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487682413516619776, 'fin-pur-rv-cancel', '取消核销', 1, 112002011, '/112/112002/112002011/', NULL, 0, '/sal/salVerify/cancel/{id}', 'POST', NULL, NULL, 356948235909079040, '2021-11-04 16:08:45.892826', 356948235909079040, '2021-11-04 16:08:45.892826', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487687815264272384, 'fin-pur-setI-submit', '提交', 1, 112001004, '/112/112001/112001004/', NULL, 0, '/fin/purSettle/submit/{id}', 'POST', NULL, NULL, 356948235909079040, '2021-11-04 16:30:13.768983', 356948235909079040, '2021-11-04 16:30:13.768983', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (487688143116238848, 'fin-pur-payI-submit', '提交', 1, 112001010, '/112/112001/112001010/', NULL, 0, '/fin/purPreSettle/submit/{id}', 'POST', NULL, NULL, 356948235909079040, '2021-11-04 16:31:31.935046', 356948235909079040, '2021-11-04 16:31:31.935046', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (488047095863709696, 'mg-purc-purcSuppliersDetail', '供应商详情', 0, 104002, '/104/104002/', NULL, 0, '/purc/suppliers/suppList/detail/:id', NULL, NULL, NULL, 356948235909079040, '2021-11-05 16:17:52.939818', 356948235909079040, '2021-11-05 16:17:52.939818', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (488047795469422592, 'mg-purc-supp-acc-mg', '供应商账号管理', 0, 104002, '/104/104002/', NULL, 0, '/purc/suppliers/suppManage/acc', NULL, NULL, NULL, 356948235909079040, '2021-11-05 16:20:39.738766', 356948235909079040, '2021-11-05 16:20:39.738766', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (488047944576929792, 'pur-sup-mg-add', '新增', 1, 488047795469422592, '/104/104002/488047795469422592/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-05 16:21:15.288664', 356948235909079040, '2021-11-05 16:21:15.288664', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (488048032149803008, 'pur-sup-mg-del', '删除', 1, 488047795469422592, '/104/104002/488047795469422592/', NULL, 0, '/srm/srmUserRelate/deleteById', 'POST', NULL, NULL, 356948235909079040, '2021-11-05 16:21:36.167150', 356948235909079040, '2021-11-05 16:21:36.167150', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (489120346744008704, 'sup-item-list-toTW', '同步至售后', 1, 106004001, '/106/106004/106004001/', NULL, 0, '/api/sync/addSync', 'POST', NULL, NULL, 356948235909079040, '2021-11-08 15:22:35.889598', 356948235909079040, '2021-11-08 15:22:35.889598', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (489120493976662016, 'sup-item-list-toJD', '同步至京云仓', 1, 106004001, '/106/106004/106004001/', NULL, 0, '/api/sync/addSync', 'POST', NULL, NULL, 356948235909079040, '2021-11-08 15:23:10.992317', 356948235909079040, '2021-11-08 15:23:10.992317', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (489135856403476480, 'sup-item-bus-toJDY', '同步至激荡云', 1, 106006001, '/106/106006/106006001/', NULL, 0, '/itm/itmItemBusiness/syncItem', 'POST', NULL, NULL, 356948235909079040, '2021-11-08 16:24:13.680186', 356948235909079040, '2021-11-08 16:24:13.680186', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492354765680746496, 'b2b-cust-cmlist-export', '导出', 1, 113001001, '/113/113001/113001001/', NULL, 0, '/crm/cust/exportData', 'POST', NULL, NULL, 356948235909079040, '2021-11-17 13:35:01.456847', 356948235909079040, '2021-11-17 13:35:01.456847', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492672734717710336, 'mg-pur-pa-export', '导出', 1, 104007002, '/104/104007/104007002/', NULL, 0, '/pur/purPurcPriceApply/exportPriceApply', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 10:38:31.182355', 356948235909079040, '2021-11-18 10:40:07.405321', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492747160352129024, 'mg-inv-seq-sync', '同步售后系统', 1, 103001001, '/103/103001/103001001/', NULL, 0, '/test/purPoInfo/purSnTest', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 15:34:15.636495', 356948235909079040, '2021-11-18 15:34:15.636495', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492747953281105920, 'mg-inv-purc-sync', '同步京云仓收发货信息', 1, 103003001, '/103/103003/103003001/', NULL, 0, '/pur/purGr/jdIftQuery', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 15:37:24.685492', 356948235909079040, '2021-11-18 15:37:24.685492', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492748500352565248, 'mg-inv-iten-export', '导出', 1, 103006001, '/103/103006/103006001/', NULL, 0, '/pln/plnItemProp/export', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 15:39:35.115818', 356948235909079040, '2021-11-18 15:39:35.115818', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492748689888968704, 'mg-inv-iten-import', '导入', 1, 103006001, '/103/103006/103006001/', NULL, 0, '/pln/plnItemProp/import', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 15:40:20.306509', 356948235909079040, '2021-11-18 15:40:20.306509', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492750127939649536, 'inventorySearchLock', '库存锁定记录查询', 0, 103011, '/103/103011/', NULL, 0, '/inventory/inventorysearch/lock', NULL, NULL, NULL, 356948235909079040, '2021-11-18 15:46:03.164904', 356948235909079040, '2021-11-18 15:46:03.164904', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492750246047055872, 'inventorySearchstockshare', '共享库存查询', 0, 103011, '/103/103011/', NULL, 0, '/inventory/inventorysearch/stockshare', NULL, NULL, NULL, 356948235909079040, '2021-11-18 15:46:31.323475', 356948235909079040, '2021-11-18 15:46:31.323475', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492751038464327680, 'mg-inv-lock-query', '查询', 1, 492750127939649536, '/103/103011/492750127939649536/', NULL, 0, '/inv/invLr/searchLr', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 15:49:40.250644', 356948235909079040, '2021-11-18 15:49:40.250644', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492751699025264640, 'mg-inv-lock-export', '导出', 1, 492750127939649536, '/103/103011/492750127939649536/', NULL, 0, '/inv/invLr/search/export', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 15:52:17.740912', 356948235909079040, '2021-11-18 15:52:17.740912', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492751904692961280, 'mg-inv-lock-toDetail', '查看锁定明细', 1, 492750127939649536, '/103/103011/492750127939649536/', NULL, 0, '/inv/invIoc/searchLockIo', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 15:53:06.775168', 356948235909079040, '2021-11-18 15:53:06.775168', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492752165318623232, 'mg-inv-stockshare-query', '查询', 1, 492750246047055872, '/103/103011/492750246047055872/', NULL, 0, '/inv/invStk/searchInvShareStk', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 15:54:08.913156', 356948235909079040, '2021-11-18 15:54:08.913156', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492752426757980160, 'mg-inv-stoShare-export', '导出', 1, 492750246047055872, '/103/103011/492750246047055872/', NULL, 0, '/inv/invStk/searchInvShareStk/export', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 15:55:11.245574', 356948235909079040, '2021-11-18 15:55:11.245574', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492753209914228736, 'mg-inv-stoShare-createPo', '创建采购订单', 1, 492750246047055872, '/103/103011/492750246047055872/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-18 15:58:17.964637', 356948235909079040, '2021-11-18 15:58:17.964637', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492755803273363456, 'costaccountlog', '成本计算记录查询', 0, 103012, '/103/103012/', NULL, 0, '/inventory/costmg/costaccountlog', NULL, NULL, NULL, 356948235909079040, '2021-11-18 16:08:36.269694', 356948235909079040, '2021-11-18 16:08:36.269694', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492755890946899968, 'goodsunitcost', '单位成本查询', 0, 103012, '/103/103012/', NULL, 0, '/inventory/costmg/goodsunitcost', NULL, NULL, NULL, 356948235909079040, '2021-11-18 16:08:57.172880', 356948235909079040, '2021-11-18 16:08:57.172880', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492755991002021888, 'querycostupdate_query', '成本调整单查询', 0, 103012, '/103/103012/', NULL, 0, '/inventory/costmg/querycostupdate/query', NULL, NULL, NULL, 356948235909079040, '2021-11-18 16:09:21.027696', 356948235909079040, '2021-11-18 16:09:21.027696', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492762779889893376, 'inv-calc-log-close', '关账', 1, 492755803273363456, '/103/103012/492755803273363456/', NULL, 0, '/inv/invCostCal/closeAccounts', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 16:36:19.624689', 356948235909079040, '2021-11-18 16:36:19.624689', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492762904351670272, 'inv-calc-log-conf', '整单确认', 1, 492755803273363456, '/103/103012/492755803273363456/', NULL, 0, '/inv/invCostCal/confirmAll', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 16:36:49.298533', 356948235909079040, '2021-11-18 16:36:49.298533', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492763066100809728, 'inv-calc-log-search', '查询', 1, 492755803273363456, '/103/103012/492755803273363456/', NULL, 0, '/inv/invCostCal/search/head', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 16:37:27.862388', 356948235909079040, '2021-11-18 16:37:27.862388', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492772211193479168, 'inv-calc-unit-search', '查询', 1, 492755890946899968, '/103/103012/492755890946899968/', NULL, 0, '/inv/invCostCal/search/detail', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 17:13:48.222176', 356948235909079040, '2021-11-18 17:13:48.222176', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492772322829074432, 'inv-calc-unit-conf', '确认', 1, 492755890946899968, '/103/103012/492755890946899968/', NULL, 0, '/inv/inv/invCostCal/confirmDetails', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 17:14:14.838807', 356948235909079040, '2021-11-18 17:14:14.838807', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492773123756589056, 'inv-calc-unit-exports', '导出', 1, 492755890946899968, '/103/103012/492755890946899968/', NULL, 0, '/inv/invCostCal/downloadDetails', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 17:17:25.794037', 356948235909079040, '2021-11-18 17:17:25.794037', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492773460399816704, 'inv-calc-aj-search', '查询', 1, 492755991002021888, '/103/103012/492755991002021888/', NULL, 0, '/inv/invCostAj/search/head', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 17:18:46.056319', 356948235909079040, '2021-11-18 17:18:46.056319', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492773892450877440, 'inv-calc-aj-submit', '提交', 1, 492755991002021888, '/103/103012/492755991002021888/', NULL, 0, '/inv/inv/invCostAj/submit', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 17:20:29.065148', 356948235909079040, '2021-11-18 17:20:29.065148', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492774023413825536, 'inv-calc-aj-app', '审核通过', 1, 492755991002021888, '/103/103012/492755991002021888/', NULL, 0, '/inv/invCostAj/approved', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 17:21:00.289820', 356948235909079040, '2021-11-18 17:21:00.289820', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (492774154108338176, 'inv-calc-aj-rej', '审核拒绝', 1, 492755991002021888, '/103/103012/492755991002021888/', NULL, 0, '/inv/invCostAj/rejected', 'POST', NULL, NULL, 356948235909079040, '2021-11-18 17:21:31.449840', 356948235909079040, '2021-11-18 17:21:31.449840', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495188144629391360, 'b2b-proCust-list-import', '批量导入', 1, 113002001, '/113/113002/113002001/', NULL, 0, '/crm/scust/ImportScustData', 'POST', NULL, NULL, 356948235909079040, '2021-11-25 09:13:51.639016', 356948235909079040, '2021-11-25 09:13:51.639016', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495188406450429952, 'b2b-contract-list-import', '批量导入', 1, 114003005, '/114/114003/114003005/', NULL, 0, '/proj/contract/ImportContractData', 'POST', NULL, NULL, 356948235909079040, '2021-11-25 09:14:54.060792', 356948235909079040, '2021-11-25 09:14:54.060792', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495188989538377728, 'b2b-sell-collist-import', '批量导入', 1, 114003013, '/114/114003/114003013/', NULL, 0, '/contract/recv/ImportConRecvData', 'POST', NULL, NULL, 356948235909079040, '2021-11-25 09:17:13.081721', 356948235909079040, '2021-11-25 09:17:13.081721', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495558133035212800, 'home-b-distribution-third-party', 'B端待配货第三方入驻订单', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:44:03.749322', 356948235909079040, '2021-11-26 09:44:03.749322', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495560311309246464, 'home-c-distribution-third-party', 'C端待配货第三方入驻订单', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:52:43.090247', 356948235909079040, '2021-11-26 09:52:43.090247', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495560379550572544, 'home-b-unshipped', 'B端未发货订单', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:52:59.360638', 356948235909079040, '2021-11-26 09:52:59.360638', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495560443983470592, 'home-c-unshipped-third-party', 'C端未发货第三方入驻订单', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:53:14.722862', 356948235909079040, '2021-11-26 09:53:14.722862', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495561032826003456, 'home-more24-unshipped-third-party', '超24小时未发货第三方入驻订单（一件代发）', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:55:35.113638', 356948235909079040, '2021-11-26 09:55:35.113638', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495561093538553856, 'home-more48-unshipped-third-party', '超48小时未发货第三方入驻订单（一件代发）', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:55:49.588626', 356948235909079040, '2021-11-26 09:55:49.588626', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495561164552314880, 'home-b-distribution-self', 'B端待配货订单-自营', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:56:06.519546', 356948235909079040, '2021-11-26 09:56:06.519546', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495561336220983296, 'home-c-distribution-self', 'C端待配货订单-自营', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:56:47.448391', 356948235909079040, '2021-11-26 09:56:47.448391', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495561801390268416, 'home-c-unshipped-self', 'C端未发货订单-自营', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:58:38.353874', 356948235909079040, '2021-11-26 09:58:38.353874', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495561916297420800, 'home-more24-unshipped-self', '超24小时未发货自营订单（一件代发）', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:59:05.749750', 356948235909079040, '2021-11-26 09:59:05.749750', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495561978108878848, 'home-more48-unshipped-self', '超48小时未发货自营订单（一件代发）', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:59:20.486021', 356948235909079040, '2021-11-26 09:59:20.486021', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495562033054261248, 'home-uncollated-collection', '财务：未核对收款结算单', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:59:33.585965', 356948235909079040, '2021-11-26 09:59:33.585965', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495562094173659136, 'home-b-to-sign-order', 'B端待签收订单', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 09:59:48.158161', 356948235909079040, '2021-11-26 09:59:48.158161', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495562147793641472, 'home-b-to-audit-quotation', 'B端待审核报价单', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 10:00:00.942509', 356948235909079040, '2021-11-26 10:00:00.942509', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495562204378996736, 'home-b-to-audit-contract', 'B端待审核新增合同', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 10:00:14.433641', 356948235909079040, '2021-11-26 10:00:14.433641', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (495562256799408128, 'home-b-distribution', 'B端待配货订单', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-26 10:00:26.931225', 356948235909079040, '2021-11-26 10:00:26.931225', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497070349433597952, 'b2b-salesSupportCenter-commissiont', '销售业绩提成规则设置', 0, 113, '/113/', NULL, 0, '/salesSupportCenter/Commission', NULL, NULL, NULL, 356948235909079040, '2021-11-30 13:53:04.234470', 356948235909079040, '2021-11-30 13:53:04.234470', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497070439980232704, 'b2b-salesSupportCenter-commissiont-list', '销售业绩提成规则查询', 0, 497070349433597952, '/113/497070349433597952/', NULL, 0, '/salesSupportCenter/Commission/list', NULL, NULL, NULL, 356948235909079040, '2021-11-30 13:53:25.821097', 356948235909079040, '2021-11-30 13:53:25.821097', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497070550567251968, 'b2b-salesSupportCenter-commissiont-create', '销售业绩提成规则新增', 0, 497070349433597952, '/113/497070349433597952/', NULL, 0, '/salesSupportCenter/Commission/create', NULL, NULL, NULL, 356948235909079040, '2021-11-30 13:53:52.188928', 356948235909079040, '2021-11-30 13:53:52.188928', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497070633723523072, 'b2b-salesSupportCenter-commissiont-edit', '销售业绩提成规则编辑', 0, 497070349433597952, '/113/497070349433597952/', NULL, 0, '/salesSupportCenter/Commission/edit/:id', NULL, NULL, NULL, 356948235909079040, '2021-11-30 13:54:12.014676', 356948235909079040, '2021-11-30 13:54:12.014676', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497070736240701440, 'b2b-sale-cmtlist-add', '新增', 1, 497070439980232704, '/113/497070349433597952/497070439980232704/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-30 13:54:36.456222', 356948235909079040, '2021-11-30 13:54:36.456222', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497070795019677696, 'b2b-sale-cmtlist-edit', '编辑', 1, 497070439980232704, '/113/497070349433597952/497070439980232704/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-11-30 13:54:50.470314', 356948235909079040, '2021-11-30 13:54:50.470314', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497070864880005120, 'b2b-sale-cmtlist-del', '删除', 1, 497070439980232704, '/113/497070349433597952/497070439980232704/', NULL, 0, '/commission/deleteBatch', 'DELETE', NULL, NULL, 356948235909079040, '2021-11-30 13:55:07.126044', 356948235909079040, '2021-11-30 13:55:07.126044', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497070948816416768, 'b2b-sale-cmtlist-import', '导入', 1, 497070439980232704, '/113/497070349433597952/497070439980232704/', NULL, 0, '/commission/ImportData', 'POST', NULL, NULL, 356948235909079040, '2021-11-30 13:55:27.138877', 356948235909079040, '2021-11-30 13:55:27.138877', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497071017129046016, 'b2b-sale-cmtlist-export', '导出', 1, 497070439980232704, '/113/497070349433597952/497070439980232704/', NULL, 0, '/commission/exportData', 'POST', NULL, NULL, 356948235909079040, '2021-11-30 13:55:43.425471', 356948235909079040, '2021-11-30 13:55:43.425471', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497071121835651072, 'b2b-sale-cmtedit-save', '保存', 1, 497070550567251968, '/113/497070349433597952/497070550567251968/', NULL, 0, '/commission/createBatch', 'POST', NULL, NULL, 356948235909079040, '2021-11-30 13:56:08.389184', 356948235909079040, '2021-11-30 13:56:08.389184', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497071195940614144, 'b2b-sale-cmtedit-save', '保存', 1, 497070633723523072, '/113/497070349433597952/497070633723523072/', NULL, 0, '/commission/createBatch', 'POST', NULL, NULL, 356948235909079040, '2021-11-30 13:56:26.057299', 356948235909079040, '2021-11-30 13:56:26.057299', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (497071366632009728, 'b2b-project-list-import', '批量导入', 1, 114003001, '/114/114003/114003001/', NULL, 0, '/proj/ImportProjData', 'POST', NULL, NULL, 356948235909079040, '2021-11-30 13:57:06.753321', 356948235909079040, '2021-11-30 13:57:06.753321', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (499282594481627136, 'Notice', '消息中心', 0, 0, '/', NULL, 0, '/notice', NULL, NULL, NULL, 356948235909079040, '2021-12-06 16:23:44.555418', 356948235909079040, '2021-12-06 16:24:04.960591', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (499282836828512256, 'NoticeList', '消息通知列表', 0, 499282594481627136, '/499282594481627136/', NULL, 0, '/notice/noticeList', NULL, NULL, NULL, 356948235909079040, '2021-12-06 16:24:42.334126', 356948235909079040, '2021-12-06 16:24:42.334126', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (499283446395101184, 'NoticeList_add', '新增消息通知', 0, 499282594481627136, '/499282594481627136/', NULL, 0, '/notice/noticeList/add', NULL, NULL, NULL, 356948235909079040, '2021-12-06 16:27:07.667038', 356948235909079040, '2021-12-06 16:27:07.667038', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (499283615043870720, 'NoticeList_edit', '编辑消息通知列表', 0, 499282594481627136, '/499282594481627136/', NULL, 0, '/notice/noticeList/edit/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-06 16:27:47.876348', 356948235909079040, '2021-12-06 16:27:47.876348', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (499283758329683968, 'NoticeList_view', '消息通知详情', 0, 499282594481627136, '/499282594481627136/', NULL, 0, '/notice/noticeList/view/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-06 16:28:22.038217', 356948235909079040, '2021-12-06 16:28:22.038217', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (501735245945303040, 'sup-item-itemFreeze-list-update', '更新商品状态', 1, 484082005112057856, '/106/106004/484082005112057856/', NULL, 0, '/itm/lifeStatus/updateToItem', 'GET', NULL, NULL, 356948235909079040, '2021-12-13 10:49:42.230823', 356948235909079040, '2021-12-13 10:49:42.230823', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (501740005951860736, 'sup-item-list-toTW', '同步至售后', 1, 108005001, '/108/108005/108005001/', NULL, 0, '/api/sync/addSync', 'POST', NULL, NULL, 356948235909079040, '2021-12-13 11:08:37.106341', 356948235909079040, '2021-12-13 11:08:37.106341', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (501742026973048832, 'sup-org-emp-import', '导入', 1, 108005001, '/108/108005/108005001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-13 11:16:38.955791', 356948235909079040, '2021-12-13 11:16:38.955791', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (501751745435463680, 'sup-price-item-master-toJDY', '同步至激荡云', 1, 107001001, '/107/107001/107001001/', NULL, 0, '/pri/priMainPrice/sync', 'POST', NULL, NULL, 356948235909079040, '2021-12-13 11:55:16.017471', 356948235909079040, '2021-12-13 11:55:16.017471', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (501806838872600576, 'inv-calc-aj-edit', '修改', 1, 492755991002021888, '/103/103012/492755991002021888/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-13 15:34:11.316766', 356948235909079040, '2021-12-13 15:34:11.316766', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (501824776379887616, 'mg-inv-sup-cancelSubmit', '撤销提交', 1, 103003001, '/103/103003/103003001/', NULL, 0, '/pur/purSs/cancelSubmit/+', 'PUT', NULL, NULL, 356948235909079040, '2021-12-13 16:45:27.951372', 356948235909079040, '2021-12-13 16:45:27.951372', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (501825630445039616, 'mg-inv-check-trnAj', '转库存调整单', 1, 103008001, '/103/103008/103008001/', NULL, 0, '/invCk/syncToInvAj/+', 'PUT', NULL, NULL, 356948235909079040, '2021-12-13 16:48:51.576240', 356948235909079040, '2021-12-13 16:48:51.576240', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502475772902830080, 'srmQrcode', '供应商二维码申请', 0, 104, '/104/', NULL, 0, '/srmSynergy/srmQrcode', NULL, NULL, NULL, 356948235909079040, '2021-12-15 11:52:17.616979', 356948235909079040, '2021-12-15 11:52:17.616979', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502476041942265856, 'qrcodeList', '二维码申请单', 0, 502475772902830080, '/104/502475772902830080/', NULL, 0, '/srmSynergy/qrcode', NULL, NULL, NULL, 356948235909079040, '2021-12-15 11:53:21.761972', 356948235909079040, '2021-12-15 11:53:21.761972', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502476308242821120, 'qrcodeView', '二维码申请单详情', 0, 502475772902830080, '/104/502475772902830080/', NULL, 0, '/srmSynergy/qrcode/view/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-15 11:54:25.252506', 356948235909079040, '2021-12-15 11:54:25.252506', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502476455274147840, 'qrcodeEdit', '二维码申请单编辑', 0, 502475772902830080, '/104/502475772902830080/', NULL, 0, '/srmSynergy/qrcode/:type', NULL, NULL, NULL, 356948235909079040, '2021-12-15 11:55:00.306145', 356948235909079040, '2021-12-15 11:55:00.306145', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502476595850440704, 'qrcodePrint', '二维码申请单打印', 0, 502475772902830080, '/104/502475772902830080/', NULL, 0, '/srmSynergy/qrcode/print/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-15 11:55:33.823892', 356948235909079040, '2021-12-15 11:55:33.823892', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502476789488873472, 'mg-purc-Completion', '产品完工', 0, 104, '/104/', NULL, 0, '/purc/Completion', NULL, NULL, NULL, 356948235909079040, '2021-12-15 11:56:19.990423', 356948235909079040, '2021-12-15 11:56:19.990423', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502476929456992256, 'mg-purc-CompletionProduct', '产品完工申请单', 0, 502476789488873472, '/104/502476789488873472/', NULL, 0, '/purc/Completion/Product', NULL, NULL, NULL, 356948235909079040, '2021-12-15 11:56:53.361024', 356948235909079040, '2021-12-15 11:56:53.361024', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502477029776355328, 'mg-purc-CompletionProductView', '产品完工申请单详情', 0, 502476789488873472, '/104/502476789488873472/', NULL, 0, '/purc/Completion/Product/View/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-15 11:57:17.278989', 356948235909079040, '2021-12-15 11:57:17.278989', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502477196835483648, 'mg-purc-CompletionIq', '产品完工库存查询', 0, 502476789488873472, '/104/502476789488873472/', NULL, 0, '/purc/Completion/Iq', NULL, NULL, NULL, 356948235909079040, '2021-12-15 11:57:57.109563', 356948235909079040, '2021-12-15 11:57:57.109563', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502478464136048640, 'mg-pur-qrcode-approve', '确认', 1, 502476041942265856, '/104/502475772902830080/502476041942265856/', NULL, 0, '/srm/purSn/approval/+', 'PUT', NULL, NULL, 356948235909079040, '2021-12-15 12:02:59.257535', 356948235909079040, '2021-12-15 12:02:59.257535', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502478580658008064, 'mg-pur-qrcode-reject', '取消', 1, 502476041942265856, '/104/502475772902830080/502476041942265856/', NULL, 0, '/srm/purSn/reject/+', 'PUT', NULL, NULL, 356948235909079040, '2021-12-15 12:03:27.038716', 356948235909079040, '2021-12-15 12:03:27.038716', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502478840822296576, 'mg-pur-qrcode-query', '查询', 1, 502476041942265856, '/104/502475772902830080/502476041942265856/', NULL, 0, '/purSn/purSelect', 'POST', NULL, NULL, 356948235909079040, '2021-12-15 12:04:29.066486', 356948235909079040, '2021-12-15 12:04:29.066486', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502479754387845120, 'mg-purc-complate-product-confirm', '确认', 1, 502476929456992256, '/104/502476789488873472/502476929456992256/', NULL, 0, '/purCpApply/confirm/+', 'PUT', NULL, NULL, 356948235909079040, '2021-12-15 12:08:06.877194', 356948235909079040, '2021-12-15 12:08:06.877194', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502479981685567488, 'mg-purc-complate-product-refuse', '拒绝', 1, 502476929456992256, '/104/502476789488873472/502476929456992256/', NULL, 0, '/purCpApply/reject/+', 'PUT', NULL, NULL, 356948235909079040, '2021-12-15 12:09:01.069260', 356948235909079040, '2021-12-15 12:09:01.069260', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (502480269070888960, 'mg-purc-complate-product-query', '查询', 1, 502476929456992256, '/104/502476789488873472/502476929456992256/', NULL, 0, '/purCpApply/list', 'POST', NULL, NULL, 356948235909079040, '2021-12-15 12:10:09.587857', 356948235909079040, '2021-12-15 12:10:09.587857', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504281988427886592, 'fin-pur-wp-submit', '提交', 1, 112005002, '/112/112005/112005002/', NULL, 0, '/fin/wdmApply/submit/{id}', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:29:32.956514', 356948235909079040, '2021-12-20 11:29:32.956514', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504286306694541312, 'ThirdPartySettlement', '第三方分佣分账', 0, 112, '/112/', NULL, 0, '/fin/ThirdParty', NULL, NULL, NULL, 356948235909079040, '2021-12-20 11:46:42.510616', 356948235909079040, '2021-12-20 11:46:42.510616', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504286415243128832, 'dailyLedger', '每日分账汇总单', 0, 504286306694541312, '/112/504286306694541312/', NULL, 0, '/fin/ThirdParty/dailysummarySheet', NULL, NULL, NULL, 356948235909079040, '2021-12-20 11:47:08.391096', 356948235909079040, '2021-12-20 11:47:08.391096', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504286526643843072, 'monthlyCommission', '每月佣金和积分发放汇总单', 0, 504286306694541312, '/112/504286306694541312/', NULL, 0, '/fin/ThirdParty/monthlyCommissionPointsSummarySheet', NULL, NULL, NULL, 356948235909079040, '2021-12-20 11:47:34.951595', 356948235909079040, '2021-12-20 11:47:34.951595', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504286609888194560, 'monthlyCoupon', '每月优惠券汇总单', 0, 504286306694541312, '/112/504286306694541312/', NULL, 0, '/fin/ThirdParty/monthlyCouponSummarySheet', NULL, NULL, NULL, 356948235909079040, '2021-12-20 11:47:54.798767', 356948235909079040, '2021-12-20 11:47:54.798767', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504286694827044864, 'monthlyIntegral', '每月积分消耗汇总单', 0, 504286306694541312, '/112/504286306694541312/', NULL, 0, '/fin/ThirdParty/monthlyIntegralConsumption', NULL, NULL, NULL, 356948235909079040, '2021-12-20 11:48:15.049762', 356948235909079040, '2021-12-20 11:48:15.049762', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504286859382173696, 'fin-day-set', '财务结算', 1, 504286415243128832, '/112/504286306694541312/504286415243128832/', NULL, 0, '/fin/WdmDay/toErp', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:48:54.282883', 356948235909079040, '2021-12-20 11:48:54.282883', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504286920484794368, 'fin-day-export', '导出', 1, 504286415243128832, '/112/504286306694541312/504286415243128832/', NULL, 0, '/fin/WdmDay/export', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:49:08.850169', 356948235909079040, '2021-12-20 11:49:08.850169', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504286982405304320, 'fin-day-back', '状态回传', 1, 504286415243128832, '/112/504286306694541312/504286415243128832/', NULL, 0, '/fin/WdmDay/erpStateBack', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:49:23.613451', 356948235909079040, '2021-12-20 11:49:23.613451', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287044434866176, 'fin-day-query', '查询', 1, 504286415243128832, '/112/504286306694541312/504286415243128832/', NULL, 0, '/fin/WdmDay/search', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:49:38.402326', 356948235909079040, '2021-12-20 11:49:38.402326', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287158444437504, 'fin-month-com-set', '财务结算', 1, 504286526643843072, '/112/504286306694541312/504286526643843072/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-20 11:50:05.584188', 356948235909079040, '2021-12-20 11:50:05.584188', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287215021404160, 'fin-month-back', '状态回传', 1, 504286526643843072, '/112/504286306694541312/504286526643843072/', NULL, 0, '/fin/wdmMon/erpStateBack', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:50:19.073036', 356948235909079040, '2021-12-20 11:50:19.073036', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287302808186880, 'fin-month-com-save', '保存', 1, 504286526643843072, '/112/504286306694541312/504286526643843072/', NULL, 0, '/fin/wdmMon/comPoints/settle', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:50:40.003545', 356948235909079040, '2021-12-20 11:50:40.003545', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287384106381312, 'fin-month-com-export', '导出', 1, 504286526643843072, '/112/504286306694541312/504286526643843072/', NULL, 0, '/fin/wdmMon/comPoints/export', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:50:59.386577', 356948235909079040, '2021-12-27 11:55:09.991978', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287439265673216, 'fin-month-com-query', '查询', 1, 504286526643843072, '/112/504286306694541312/504286526643843072/', NULL, 0, '/fin/wdmMon/comPoints/search', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:51:12.537165', 356948235909079040, '2021-12-20 11:51:12.537165', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287548888002560, 'fin-month-coupon-sel', '生成销售结算单', 1, 504286609888194560, '/112/504286306694541312/504286609888194560/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-20 11:51:38.673654', 356948235909079040, '2021-12-20 11:51:38.673654', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287614084263936, 'fin-month-coupon-selSave', '生成销售结算单弹框保存', 1, 504286609888194560, '/112/504286306694541312/504286609888194560/', NULL, 0, '/fin/wdmMon/coupSum/salSettle', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:51:54.217142', 356948235909079040, '2021-12-20 11:51:54.217142', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287660846559232, 'fin-month-coupon-col', '生成收款结算单', 1, 504286609888194560, '/112/504286306694541312/504286609888194560/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-20 11:52:05.366457', 356948235909079040, '2021-12-20 11:52:05.366457', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287725027799040, 'fin-month-coupon-colSave', '生成收款结算单弹框保存', 1, 504286609888194560, '/112/504286306694541312/504286609888194560/', NULL, 0, '/fin/wdmMon/coupSum/recSettle', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:52:20.668921', 356948235909079040, '2021-12-20 11:52:20.668921', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287786944114688, 'fin-month-coupon-export', '导出', 1, 504286609888194560, '/112/504286306694541312/504286609888194560/', NULL, 0, '/fin/wdmMon/coupSum/export', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:52:35.430974', 356948235909079040, '2021-12-20 11:52:35.430974', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504287956536602624, 'fin-month-coupon-query', '查询', 1, 504286609888194560, '/112/504286306694541312/504286609888194560/', NULL, 0, '/fin/wdmMon/coupSum/search', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:53:15.864242', 356948235909079040, '2021-12-27 11:55:40.155555', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504288415879999488, 'fin-month-integral-sel', '生成销售结算单', 1, 504286694827044864, '/112/504286306694541312/504286694827044864/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-20 11:55:05.380470', 356948235909079040, '2021-12-20 11:55:05.380470', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504288478312214528, 'fin-month-integral-selSave', '生成销售结算单弹框保存', 1, 504286694827044864, '/112/504286306694541312/504286694827044864/', NULL, 0, '/fin/wdmMon/pointsSum/salSettle', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:55:20.265934', 356948235909079040, '2021-12-20 11:55:20.265934', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504288520347529216, 'fin-month-integral-col', '生成收款结算单', 1, 504286694827044864, '/112/504286306694541312/504286694827044864/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-20 11:55:30.287279', 356948235909079040, '2021-12-20 11:55:30.287279', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504288613104562176, 'fin-month-integral-colSave', '生成收款结算单弹框保存', 1, 504286694827044864, '/112/504286306694541312/504286694827044864/', NULL, 0, '/fin/wdmMon/pointsSum/recSettle', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:55:52.402653', 356948235909079040, '2021-12-20 11:55:52.402653', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504288683992494080, 'fin-month-integral-export', '导出', 1, 504286694827044864, '/112/504286306694541312/504286694827044864/', NULL, 0, '/fin/wdmMon/pointsSum/export', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:56:09.303556', 356948235909079040, '2021-12-20 11:56:09.303556', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (504288752959434752, 'fin-month-integral-query', '查询', 1, 504286694827044864, '/112/504286306694541312/504286694827044864/', NULL, 0, '/fin/wdmMon/pointsSum/search', 'POST', NULL, NULL, 356948235909079040, '2021-12-20 11:56:25.746098', 356948235909079040, '2021-12-20 11:56:25.746098', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (505068776503324672, 'sup-item-audit-list-export', '导出', 1, 479976879291834368, '/106/479971055530090496/479976879291834368/', NULL, 0, '/yst-support/itm/approve/export', 'POST', NULL, NULL, 356948235909079040, '2021-12-22 15:35:57.851341', 356948235909079040, '2021-12-22 15:35:57.851341', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (505359942599782400, 'home-pur-deliveryNotice', '采购订单收货提醒', 1, 101, '/101/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-23 10:52:57.258883', 356948235909079040, '2021-12-23 10:52:57.258883', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (505426870264868864, 'b2b-cust-detail-geterp', '获取ERP客户编码', 1, 113001003, '/113/113001/113001003/', NULL, 0, '/crm/cust/getMdmCustCode/{taxRegNo}', 'GET', NULL, NULL, 356948235909079040, '2021-12-23 15:18:54.057200', 356948235909079040, '2021-12-23 15:18:54.057200', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (505426947779801088, 'b2b-cust-detail-geterp', '获取ERP客户编码', 1, 113001005, '/113/113001/113001005/', NULL, 0, '/crm/cust/getMdmCustCode/{taxRegNo}', 'GET', NULL, NULL, 356948235909079040, '2021-12-23 15:19:12.538781', 356948235909079040, '2021-12-23 15:19:12.538781', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507148729893462016, 'fin-month-coupon-num', '收款账号', 1, 504286609888194560, '/112/504286306694541312/504286609888194560/', NULL, 0, '/fin/wdmMon/coupSum/acc', 'POST', NULL, NULL, 356948235909079040, '2021-12-28 09:20:57.383543', 356948235909079040, '2021-12-28 09:20:57.383543', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507148832469360640, 'fin-month-integral-num', '收款账号', 1, 504286694827044864, '/112/504286306694541312/504286694827044864/', NULL, 0, '/fin/wdmMon/pointsSum/acc', 'POST', NULL, NULL, 356948235909079040, '2021-12-28 09:21:21.838643', 356948235909079040, '2021-12-28 09:21:21.838643', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507609027641298944, 'shop-itemManagement-BoutiqueRecommendation', '新增专区', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/BoutiqueRecommendation', NULL, NULL, NULL, 356948235909079040, '2021-12-29 15:50:00.918279', 356948235909079040, '2021-12-29 15:50:00.918279', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507609122701004800, 'shop-itemManagement-BoutiqueRecommendationEdit', '专区设置编辑', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/BoutiqueRecommendation/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-29 15:50:23.582298', 356948235909079040, '2021-12-29 15:50:23.582298', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507611287268052992, 'b2b-shop-izzedit-save', '保存', 1, 507609027641298944, '/484052761782841344/484052928393179136/507609027641298944/', NULL, 0, '保存', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 15:58:59.653837', 356948235909079040, '2021-12-29 15:58:59.653837', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507611325520105472, 'b2b-shop-izzedit-itemdetail-add', '新增', 1, 507609027641298944, '/484052761782841344/484052928393179136/507609027641298944/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 15:59:08.775297', 356948235909079040, '2021-12-29 15:59:08.775297', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507611363067514880, 'b2b-shop-izzedit-itemdetail-del', '删除', 1, 507609027641298944, '/484052761782841344/484052928393179136/507609027641298944/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 15:59:17.727592', 356948235909079040, '2021-12-29 15:59:17.727592', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507613445258432512, 'b2b-shop-izzedit-save', '保存', 1, 507609122701004800, '/484052761782841344/484052928393179136/507609122701004800/', NULL, 0, '/zone/conf/addOrUpdateZone', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:07:34.160645', 356948235909079040, '2021-12-29 16:07:34.160645', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507613483015557120, 'b2b-shop-izzedit-itemdetail-add', '新增', 1, 507609122701004800, '/484052761782841344/484052928393179136/507609122701004800/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:07:43.162403', 356948235909079040, '2021-12-29 16:07:43.162403', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507613519510196224, 'b2b-shop-izzedit-itemdetail-del', '删除', 1, 507609122701004800, '/484052761782841344/484052928393179136/507609122701004800/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:07:51.863205', 356948235909079040, '2021-12-29 16:07:51.863205', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507613659423789056, 'shop-itemManagement-BoutiqueRecommendationDetail', '专区设置详情', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/BoutiqueRecommendation/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:08:25.221234', 356948235909079040, '2021-12-29 16:08:25.221234', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507614217593376768, 'shop-itemManagement-MainMenuadd', '首页菜单新增', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/MainMenuadd', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:10:38.299371', 356948235909079040, '2021-12-29 16:10:38.299371', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507614483415781376, 'shop-itemManagement-MainMenuedit', '首页菜单编辑', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/MainMenuadd/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:11:41.676248', 356948235909079040, '2021-12-29 16:11:41.676248', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507614599807717376, 'shop-itemManagement-MainMenuDetail', '首页菜单详情', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/MainMenuadd/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:12:09.426880', 356948235909079040, '2021-12-29 16:12:09.426880', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507616277806141440, 'b2b-shop-mmsedit-save', '保存', 1, 507614217593376768, '/484052761782841344/484052928393179136/507614217593376768/', NULL, 0, '/menu/conf/addOrUpdateMenuConf', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:18:49.492024', 356948235909079040, '2021-12-29 16:18:49.492024', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507616380105216000, 'b2b-shop-itemdetail-add', '新增', 1, 507614217593376768, '/484052761782841344/484052928393179136/507614217593376768/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:19:13.882016', 356948235909079040, '2021-12-29 16:19:13.882016', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507616501580648448, 'b2b-shop-itemdetail-del', '删除', 1, 507614217593376768, '/484052761782841344/484052928393179136/507614217593376768/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:19:42.844022', 356948235909079040, '2021-12-29 16:19:42.844022', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507616599026913280, 'b2b-shop-mmsedit-save', '保存', 1, 507614483415781376, '/484052761782841344/484052928393179136/507614483415781376/', NULL, 0, '/menu/conf/addOrUpdateMenuConf', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:20:06.077581', 356948235909079040, '2021-12-29 16:20:06.077581', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507616653087297536, 'b2b-shop-itemdetail-add', '新增', 1, 507614483415781376, '/484052761782841344/484052928393179136/507614483415781376/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:20:18.966492', 356948235909079040, '2021-12-29 16:20:18.966492', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507616689783263232, 'b2b-shop-itemdetail-del', '删除', 1, 507614483415781376, '/484052761782841344/484052928393179136/507614483415781376/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:20:27.715651', 356948235909079040, '2021-12-29 16:20:27.715651', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507616861229633536, 'shop-itemManagement-add-create', '物流运费模板新增', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/add/create', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:21:08.591919', 356948235909079040, '2021-12-29 16:21:08.591919', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507616969270710272, 'shop-itemManagement-Edit', '物流运费模板编辑', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/add/create/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:21:34.350400', 356948235909079040, '2021-12-29 16:21:34.350400', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507617053181956096, 'shop-itemManagement-Detail', '物流运费模板详情', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/add/create/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:21:54.356247', 356948235909079040, '2021-12-29 16:21:54.356247', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507617154583449600, 'b2b-shop-img-lft-save', '保存', 1, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/logistics/conf/saveLogistics', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:22:18.532905', 356948235909079040, '2021-12-29 16:22:18.532905', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507617201740009472, 'b2b-shop-img-lft-sod-add', '新增', 1, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:22:29.775284', 356948235909079040, '2021-12-29 16:22:29.775284', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507617235772592128, 'b2b-shop-img-lft-sod-del', '删除', 1, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:22:37.889759', 356948235909079040, '2021-12-29 16:22:37.889759', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507617341246754816, 'b2b-shop-img-lft-sod-add', '新增', 1, 507616969270710272, '/484052761782841344/484052928393179136/507616969270710272/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:23:03.036981', 356948235909079040, '2021-12-29 16:23:03.036981', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507617611989078016, 'b2b-shop-img-lft-sod-del', '删除', 1, 507616969270710272, '/484052761782841344/484052928393179136/507616969270710272/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:24:07.586624', 356948235909079040, '2021-12-29 16:24:07.586624', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507617660814970880, 'b2b-shop-img-lft-save', '保存', 1, 507616969270710272, '/484052761782841344/484052928393179136/507616969270710272/', NULL, 0, '/logistics/conf/saveLogistics', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:24:19.227408', 356948235909079040, '2021-12-29 16:24:19.227408', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507617785645846528, 'shop-itemManagement-firstSingleZone-create', '新增首单专区商品', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/firstSingleZone/create', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:24:48.989731', 356948235909079040, '2021-12-29 16:24:48.989731', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507617874611228672, 'shop-itemManagement-firstSingleZone-edit', '编辑首单专区商品', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/firstSingleZone/edit/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:25:10.200376', 356948235909079040, '2021-12-29 16:25:10.200376', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507617963278815232, 'shop-itemManagement-firstSingleZone-view', '查看首单专区商品', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/firstSingleZone/view/:type/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:25:31.340503', 356948235909079040, '2021-12-29 16:25:31.340503', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619175822741504, 'b2b-shop-fszedit-save', '保存', 1, 507617785645846528, '/484052761782841344/484052928393179136/507617785645846528/', NULL, 0, '/bip/firstspecial/save', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:30:20.433613', 356948235909079040, '2021-12-29 16:30:20.433613', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619237952966656, 'b2b-shop-fszedit-save', '保存', 1, 507617874611228672, '/484052761782841344/484052928393179136/507617874611228672/', NULL, 0, '/bip/firstspecial/save', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:30:35.246397', 356948235909079040, '2021-12-29 16:30:35.246397', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619366609047552, 'shop-itemManagement-addItem-create', '新增商品', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/addItem/create', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:31:05.920493', 356948235909079040, '2021-12-29 16:31:05.920493', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619461152854016, 'shop-itemManagement-addItem-edit', '编辑商品', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/addItem/edit/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:31:28.461714', 356948235909079040, '2021-12-29 16:31:28.461714', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619555105263616, 'shop-itemManagement-addItem-view', '商品详情', 0, 484052928393179136, '/484052761782841344/484052928393179136/', NULL, 0, '/shop/itemManagement/addItem/view/:id', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:31:50.860993', 356948235909079040, '2021-12-29 16:31:50.860993', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619648264949760, 'b2b-shop-sil-additem-save', '保存', 1, 507619366609047552, '/484052761782841344/484052928393179136/507619366609047552/', NULL, 0, '/bip/item/{id}', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:32:13.072147', 356948235909079040, '2021-12-29 16:32:13.072147', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619692242227200, 'b2b-shop-sil-additem-soddel', '删除(商品明细）', 1, 507619366609047552, '/484052761782841344/484052928393179136/507619366609047552/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:32:23.557663', 356948235909079040, '2021-12-29 16:32:23.557663', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619736693460992, 'b2b-shop-sil-additem-qurysku', '查询sku信息', 1, 507619366609047552, '/484052761782841344/484052928393179136/507619366609047552/', NULL, 0, '/yst-support/itm/component/item/business', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:32:34.155060', 356948235909079040, '2021-12-29 16:32:34.155060', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619775843094528, 'b2b-shop-sil-additem-player-del', '删除(视频）', 1, 507619366609047552, '/484052761782841344/484052928393179136/507619366609047552/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:32:43.489250', 356948235909079040, '2021-12-29 16:32:43.489250', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619814145478656, 'b2b-shop-sil-additem-pic-del', '删除(商品主图和封面)', 1, 507619366609047552, '/484052761782841344/484052928393179136/507619366609047552/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:32:52.621360', 356948235909079040, '2021-12-29 16:32:52.621360', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619928624812032, 'b2b-shop-sil-additem-save', '保存', 1, 507619461152854016, '/484052761782841344/484052928393179136/507619461152854016/', NULL, 0, '/bip/item/{id}', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:33:19.915756', 356948235909079040, '2021-12-29 16:33:19.915756', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507619978109210624, 'b2b-shop-sil-additem-soddel', '删除(商品明细）', 1, 507619461152854016, '/484052761782841344/484052928393179136/507619461152854016/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:33:31.713917', 356948235909079040, '2021-12-29 16:33:31.713917', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507620028818345984, 'b2b-shop-sil-additem-qurysku', '查询sku信息', 1, 507619461152854016, '/484052761782841344/484052928393179136/507619461152854016/', NULL, 0, '/yst-support/itm/component/item/business', 'POST', NULL, NULL, 356948235909079040, '2021-12-29 16:33:43.803779', 356948235909079040, '2021-12-29 16:33:43.803779', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507620069087858688, 'b2b-shop-sil-additem-player-del', '删除(视频）', 1, 507619461152854016, '/484052761782841344/484052928393179136/507619461152854016/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:33:53.404260', 356948235909079040, '2021-12-29 16:33:53.404260', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (507620116626100224, 'b2b-shop-sil-additem-pic-del', '删除(商品主图和封面)', 1, 507619461152854016, '/484052761782841344/484052928393179136/507619461152854016/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2021-12-29 16:34:04.738722', 356948235909079040, '2021-12-29 16:34:04.738722', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (508639654163312640, 'purSupplierAchievements', '供应商绩效管理', 0, 484073315252367360, '/484073315252367360/', NULL, 0, '/purc/supplier/achievements', NULL, NULL, NULL, 356948235909079040, '2022-01-01 12:05:21.429372', 356948235909079040, '2022-01-01 12:05:30.398570', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (508639900310237184, 'purSupplierAchievementsHandle', '绩效结果反馈处理-采购方', 0, 508639654163312640, '/484073315252367360/508639654163312640/', NULL, 0, '/purc/supplier/achievements/handle', NULL, NULL, NULL, 356948235909079040, '2022-01-01 12:06:20.115673', 356948235909079040, '2022-01-01 12:06:20.115673', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (508640540377804800, 'supplier-admittance-handle-approval', '同意', 1, 508639900310237184, '/484073315252367360/508639654163312640/508639900310237184/', NULL, 0, '/yst/srm/gradeRule/gradeRuleDByMasId/+', 'GET', NULL, NULL, 356948235909079040, '2022-01-01 12:08:52.719127', 356948235909079040, '2022-01-01 12:08:52.719127', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (508640619503349760, 'supplier-admittance-handle-reject', '驳回', 1, 508639900310237184, '/484073315252367360/508639654163312640/508639900310237184/', NULL, 0, '/yst/srm/examineResult/reject', 'POST', NULL, NULL, 356948235909079040, '2022-01-01 12:09:11.582818', 356948235909079040, '2022-01-01 12:09:11.582818', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (509399290353086464, 'mg-purc-purcReturnRmaView', '采购退货RMA详情', 0, 104005, '/104/104005/', NULL, 0, '/purc/return/rma/view/:id', NULL, NULL, NULL, 356948235909079040, '2022-01-03 14:23:52.810916', 356948235909079040, '2022-01-03 14:23:52.810916', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510420919171084288, 'initAmt', '额度管理', 0, 103, '/103/', NULL, 0, '/inventory/initamt', NULL, NULL, NULL, 356948235909079040, '2022-01-06 10:03:28.101117', 356948235909079040, '2022-01-06 10:03:28.101117', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510421040940118016, 'initAmtIndex', '期初额度', 0, 510420919171084288, '/103/510420919171084288/', NULL, 0, '/inventory/initamt/index', NULL, NULL, NULL, 356948235909079040, '2022-01-06 10:03:57.133501', 356948235909079040, '2022-01-06 10:03:57.133501', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510421288672489472, 'initAmtCreate', '期初额度新增', 0, 510420919171084288, '/103/510420919171084288/', NULL, 0, '/inventory/initamt/create/:type', NULL, NULL, NULL, 356948235909079040, '2022-01-06 10:04:56.197072', 356948235909079040, '2022-01-06 10:04:56.197072', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510421376920645632, 'partsAccountIndex', '配额往来账', 0, 510420919171084288, '/103/510420919171084288/', NULL, 0, '/inventory/partsaccount/index', NULL, NULL, NULL, 356948235909079040, '2022-01-06 10:05:17.237456', 356948235909079040, '2022-01-06 10:05:17.237456', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510421456507564032, '配额往来账详情', '配额往来账详情', 0, 510420919171084288, '/103/510420919171084288/', NULL, 0, '/inventory/partsaccount/view/:type', NULL, NULL, NULL, 356948235909079040, '2022-01-06 10:05:36.212726', 356948235909079040, '2022-01-06 10:05:36.212726', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510421802109825024, 'middleGround_inventory_initAmt', '查询', 1, 510421040940118016, '/103/510420919171084288/510421040940118016/', NULL, 0, '/yst/inv/initAmt/search', 'POST', NULL, NULL, 356948235909079040, '2022-01-06 10:06:58.608743', 356948235909079040, '2022-01-06 10:06:58.608743', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510421945009762304, 'middleGround_inventory_initAmt_add', '新增', 1, 510421040940118016, '/103/510420919171084288/510421040940118016/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2022-01-06 10:07:32.680575', 356948235909079040, '2022-01-06 10:07:32.680575', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510422185016225792, 'middleGround_inventory_initAmt_export', '导出', 1, 510421040940118016, '/103/510420919171084288/510421040940118016/', NULL, 0, '/yst/inv/initAmt/exportData', 'POST', NULL, NULL, 356948235909079040, '2022-01-06 10:08:29.902670', 356948235909079040, '2022-01-06 10:08:29.902670', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510422541368487936, 'middleGround_inventory_partsaccount_exports', '导出', 1, 510421376920645632, '/103/510420919171084288/510421376920645632/', NULL, 0, '/yst/inv/pur/purPartsAccount/exportData', 'POST', NULL, NULL, 356948235909079040, '2022-01-06 10:09:54.863634', 356948235909079040, '2022-01-06 10:09:54.863634', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510422719072759808, 'middleGround_inventory_partsaccount_query', '查询', 1, 510421376920645632, '/103/510420919171084288/510421376920645632/', NULL, 0, '/yst/inv/pur/purPartsAccount/search', 'POST', NULL, NULL, 356948235909079040, '2022-01-06 10:10:37.231361', 356948235909079040, '2022-01-06 10:10:37.231361', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510428974885564416, 'control-param-add', '商品段信息新增', 1, 479993296896700416, '/106/479991083646365696/479993296896700416/', NULL, 0, '/', 'GET', NULL, NULL, 356948235909079040, '2022-01-06 10:35:28.733788', 356948235909079040, '2022-01-06 10:35:28.733788', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (510429137163186176, 'control-param-del', '商品段信息参数删除', 1, 479993296896700416, '/106/479991083646365696/479993296896700416/', NULL, 0, '/', 'GET', NULL, NULL, 356948235909079040, '2022-01-06 10:36:07.423149', 356948235909079040, '2022-01-06 10:36:07.423149', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (513339752974311424, 'system-user-triggerActive', '切换启用', 1, 109002001, '/109/109002/109002001/', NULL, 0, '/cloudt-system/sys/users/:id', 'PUT', NULL, NULL, 356948235909079040, '2022-01-14 11:21:52.309558', 356948235909079040, '2022-01-14 11:23:07.186008', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (513340686290837504, 'system-user-reset', '重置密码', 1, 109002001, '/109/109002/109002001/', NULL, 0, '/cloudt-system/sys/users/reset/pwd/:userId', 'PUT', NULL, NULL, 356948235909079040, '2022-01-14 11:25:34.827596', 356948235909079040, '2022-01-14 11:25:34.827596', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (513340865630887936, 'system-user-export', '导出', 1, 109002001, '/109/109002/109002001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2022-01-14 11:26:17.587240', 356948235909079040, '2022-01-14 11:26:17.587240', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (513340968848515072, 'system-user-import', '导入', 1, 109002001, '/109/109002/109002001/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2022-01-14 11:26:42.196947', 356948235909079040, '2022-01-14 11:26:42.196947', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (525280699765190656, 'sup-item-list-issueParameter', '发布经营参数', 1, 106004001, '/106/106004/106004001/', NULL, 0, '/itm/item/businessParam/pub', 'POST', NULL, NULL, 356948235909079040, '2022-02-16 10:10:55.876522', 356948235909079040, '2022-02-16 10:10:55.876522', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (529986599402827776, 'sup-item-emp-export', '导出', 1, 108005001, '/108/108005/108005001/', NULL, 0, '/', 'POST', NULL, NULL, 356948235909079040, '2022-03-01 09:50:29.781077', 356948235909079040, '2022-03-01 09:50:29.781077', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (530013668627148800, 'sup-item-bus-export-business', '导出', 1, 106006001, '/106/106006/106006001/', NULL, 0, '/itm/itmItemBusiness/exportBusiness', 'POST', NULL, NULL, 356948235909079040, '2022-03-01 11:38:03.585742', 356948235909079040, '2022-03-01 16:53:29.820662', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (534794324794281706, 'template_log', '模板使用记录', 0, 109005, '/109/109005/', NULL, 0, '/sys/template/log', NULL, NULL, NULL, 356948235909079040, '2022-03-14 16:14:40.837451', 356948235909079040, '2022-03-14 16:14:40.837451', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (534854424921771754, 'b2b-sale-cmtedit-info-del', '删除', 1, 497070550567251968, '/113/497070349433597952/497070550567251968/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2022-03-14 20:13:29.824873', 356948235909079040, '2022-03-14 20:13:29.824873', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (534854493783854551, 'b2b-sale-cmtedit-info-del', '删除', 1, 497070633723523072, '/113/497070349433597952/497070633723523072/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2022-03-14 20:13:46.243839', 356948235909079040, '2022-03-14 20:13:46.243839', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (534854591796349315, 'b2b-sale-cmtedit-info-add', '新增', 1, 497070550567251968, '/113/497070349433597952/497070550567251968/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2022-03-14 20:14:09.611021', 356948235909079040, '2022-03-14 20:14:09.611021', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (534854684276558206, 'b2b-sale-cmtedit-info-add', '新增', 1, 497070633723523072, '/113/497070349433597952/497070633723523072/', NULL, 0, '/', NULL, NULL, NULL, 356948235909079040, '2022-03-14 20:14:31.660229', 356948235909079040, '2022-03-14 20:14:31.660229', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (543875394782191616, 'sup-org-ou-launch', '启用', 1, 108003001, '/108/108003/108003001/', NULL, 0, '/org/orgOu/updateOrgBuStatus', 'PUT', NULL, NULL, 356948235909079040, '2022-04-08 17:39:36.641305', 356948235909079040, '2022-04-08 17:39:36.641305', 0, NULL, 'admin', 'admin', NULL, 1, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109008, 'Tenant', '租户管理', 0, 109, '/109/', NULL, 0, '/sys/basic', NULL, NULL, NULL, 356948235909079040, '2022-03-17 10:30:59.748465', 356948235909079040, '2022-03-30 10:07:43.187919', 0, NULL, '', 'admin', NULL, 0, NULL, NULL, NULL);
INSERT INTO `sys_permission` VALUES (109008001, 'tenantIndex', '租户管理', 0, 109008, '/109/109008/', NULL, 0, '/sys/basic/tenant', NULL, NULL, NULL, 356948235909079040, '2022-03-17 10:31:46.146621', 356948235909079040, '2022-03-17 10:36:27.587455', 0, NULL, '', '', NULL, 0, NULL, NULL, NULL);
